/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.lookup.EglLookupDelegate;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.SerializationException;
import org.eclipse.edt.mof.serialization.TypeNotFoundException;
import org.eclipse.edt.mof.utils.NameUtile;

public class EGL2IREnvironment
implements IBindingEnvironment,
IEnvironment {
    private static final String defaultPackage = NameUtile.getAsName((String)"");
    protected IEnvironment irEnv;
    private List<File> irPathRoots = new ArrayList<File>();
    private PackageBinding rootPackageBinding = new PackageBinding(defaultPackage, null, this);
    private ICompiler compiler;
    private List<ZipFileBindingBuildPathEntry> systemPathEntries = new ArrayList<ZipFileBindingBuildPathEntry>();

    public EGL2IREnvironment() {
        this.irEnv = Environment.getCurrentEnv();
        this.irEnv.registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
    }

    public EGL2IREnvironment(IEnvironment irEnv) {
        irEnv.registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
        this.irEnv = irEnv;
    }

    public void setSystemPathEntries(List<ZipFileBindingBuildPathEntry> entries) {
        this.systemPathEntries = entries;
    }

    public void setCompiler(ICompiler compiler) {
        this.compiler = compiler;
    }

    private boolean systemPathEntriesContainPackage(String packageName) {
        for (ZipFileBindingBuildPathEntry entry : this.systemPathEntries) {
            if (!entry.hasPackage(packageName)) continue;
            return true;
        }
        return false;
    }

    protected boolean rootsContainPackage(String packageName) {
        String path = packageName.replace('.', '/');
        for (File root : this.irPathRoots) {
            File folder = new File(root, path);
            if (!folder.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPartBinding getPartBinding(String packageName, String partName) {
        IPartBinding result = null;
        if (result == null) {
            result = SourcePathEntry.getInstance().getPartBinding(packageName, partName);
        }
        if (result == null) {
            boolean hasSourcePart = false;
            if (SourcePathEntry.getInstance().hasPart(packageName, partName) != 1) {
                hasSourcePart = true;
            }
            String eglSignature = "egl:" + packageName + "." + partName;
            if (hasSourcePart) {
                long sourceLastModified = SourcePathEntry.getInstance().lastModified(packageName, partName);
                long irLastModified = this.irEnv.lastModified(eglSignature);
                if (irLastModified == -1L || sourceLastModified > irLastModified) {
                    return SourcePathEntry.getInstance().getOrCompilePartBinding(packageName, partName);
                }
            }
            try {
                EObject irPart = this.findPart(eglSignature);
                if (irPart != null) {
                    IRPartBinding partBinding = BindingUtil.createPartBinding(irPart);
                    return partBinding;
                }
            }
            catch (DeserializationException ex2) {
                throw new RuntimeException(ex2);
            }
        }
        return result;
    }

    private EObject findPart(String mofSignature) throws DeserializationException {
        try {
            return this.irEnv.find(mofSignature);
        }
        catch (MofObjectNotFoundException mofObjectNotFoundException) {
            return null;
        }
    }

    @Override
    public IPartBinding getNewPartBinding(PackageAndPartName ppName, int kind) {
        return SourcePathEntry.getInstance().getNewPartBinding(ppName, kind);
    }

    @Override
    public boolean hasPackage(String packageName) {
        return SourcePathEntry.getInstance().hasPackage(packageName) || this.rootsContainPackage(packageName) || this.systemPathEntriesContainPackage(packageName);
    }

    @Override
    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public void addRoot(File file) {
        this.irPathRoots.add(file);
    }

    public IPartBinding level01Compile(PackageAndPartName ppName) {
        int partType = SourcePathEntry.getInstance().hasPart(ppName.getPackageName(), ppName.getPartName());
        if (partType != 1) {
            IPartBinding result = BindingUtil.createPartBinding(partType, ppName);
            result.setValid(false);
            result.setEnvironment(this);
            return result;
        }
        return null;
    }

    public EObject find(String key) throws MofObjectNotFoundException, DeserializationException {
        return this.irEnv.find(key);
    }

    public EObject find(String key, boolean useProxies) throws MofObjectNotFoundException, DeserializationException {
        return this.irEnv.find(key, useProxies);
    }

    public ObjectStore getDefaultSerializeStore(String keyScheme) {
        return this.irEnv.getDefaultSerializeStore(keyScheme);
    }

    public EObject lookup(String key) throws DeserializationException {
        return this.irEnv.lookup(key);
    }

    public void registerLookupDelegate(String scheme, IEnvironment.LookupDelegate delegate) {
        this.irEnv.registerLookupDelegate(scheme, delegate);
    }

    public void registerObjectStore(String scheme, ObjectStore store) {
        this.irEnv.registerObjectStore(scheme, store);
    }

    public void remove(String key) {
        this.irEnv.remove(key);
    }

    public void save(MofSerializable object) throws SerializationException {
        this.irEnv.save(object);
    }

    public void save(MofSerializable object, boolean serialize) throws SerializationException {
        this.irEnv.save(object, serialize);
    }

    public void save(String key, EObject object) throws SerializationException {
        this.irEnv.save(key, object);
    }

    public void save(String key, EObject object, boolean serialize) throws SerializationException {
        this.irEnv.save(key, object, serialize);
    }

    public void setDefaultSerializeStore(String keyScheme, ObjectStore store) {
        this.irEnv.setDefaultSerializeStore(keyScheme, store);
    }

    public long lastModified(String key) {
        return this.irEnv.lastModified(key);
    }

    public EObject get(String key) {
        return this.irEnv.get(key);
    }

    public IEnvironment.LookupDelegate getLookupDelegateForKey(String key) {
        return this.irEnv.getLookupDelegateForKey(key);
    }

    public Map<String, List<ObjectStore>> getObjectStores() {
        return this.irEnv.getObjectStores();
    }

    public Map<String, IEnvironment.LookupDelegate> getLookupDelegates() {
        return this.irEnv.getLookupDelegates();
    }

    public List<File> getPathRoots() {
        return this.irPathRoots;
    }

    @Override
    public ICompiler getCompiler() {
        return this.compiler;
    }

    public MofSerializable findType(String mofSignature) throws TypeNotFoundException, DeserializationException {
        return this.irEnv.findType(mofSignature);
    }
}

