/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class SystemLibraryUtil {
    public static String getSystemLibraryPath(Class locatorClass, String subDir) {
        String name = locatorClass.getCanonicalName();
        URL classUrl = locatorClass.getResource(name = "/" + name.replace('.', '/') + ".class");
        if (classUrl != null && classUrl.getProtocol().equals("file")) {
            String initializerPath = classUrl.getFile();
            initializerPath = SystemLibraryUtil.getSystemLibraryPath(initializerPath, name, subDir);
            try {
                initializerPath = URLDecoder.decode(initializerPath, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            return initializerPath;
        }
        if (classUrl != null && classUrl.getProtocol().equals("jar")) {
            String initializerPath = classUrl.getFile();
            if (initializerPath.startsWith("file:")) {
                initializerPath = initializerPath.substring(5);
            }
            initializerPath = SystemLibraryUtil.getSystemLibraryPath(initializerPath, name, subDir);
            try {
                initializerPath = URLDecoder.decode(initializerPath, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            return initializerPath;
        }
        return null;
    }

    private static String getSystemLibraryPath(String fileURL, String qualClassName, String subDir) {
        String initializerPath = fileURL.replace('\\', '/');
        int index = initializerPath.lastIndexOf(qualClassName);
        initializerPath = initializerPath.substring(0, index);
        try {
            initializerPath = new URI(initializerPath).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            initializerPath = initializerPath.replaceAll("%20", " ");
        }
        boolean isJar = initializerPath.endsWith(".jar!");
        index = initializerPath.lastIndexOf("/");
        initializerPath = initializerPath.substring(0, index);
        if (isJar) {
            index = initializerPath.lastIndexOf("/");
            initializerPath = initializerPath.substring(0, index + 1);
            return String.valueOf(initializerPath) + subDir;
        }
        return String.valueOf(initializerPath) + "/" + subDir;
    }
}

