/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.IZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.internal.io.ZipFileBuildPathEntry;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;

public abstract class ZipFileBindingBuildPathEntry
extends ZipFileBuildPathEntry
implements IZipFileBindingBuildPathEntry,
IZipFileEntryManager {
    private ObjectStore store;
    private String fileExtension;
    private Map<String, Map<String, IRPartBinding>> partBindingsByPackage = new HashMap<String, Map<String, IRPartBinding>>();

    public ZipFileBindingBuildPathEntry(String path, String fileExtension) {
        super(path);
        this.fileExtension = fileExtension;
        this.processEntries();
    }

    protected abstract IEnvironment getEnvironment();

    @Override
    public void clear() {
        super.clear();
        this.partBindingsByPackage.clear();
        if (this.store instanceof CachingObjectStore) {
            ((CachingObjectStore)this.store).clearCache();
        }
    }

    @Override
    public IPartBinding getPartBinding(String packageName, String partName) {
        IRPartBinding partBinding = this.getCachedPartBinding(packageName, partName);
        if (partBinding == null) {
            partBinding = this.getPartBinding(this.getEntry(packageName, partName));
        }
        return partBinding;
    }

    @Override
    public IRPartBinding getCachedPartBinding(String packageName, String partName) {
        Map<String, IRPartBinding> partpackage;
        IRPartBinding partBinding = null;
        if (packageName == null) {
            packageName = "";
        }
        if ((partpackage = this.partBindingsByPackage.get(packageName)) != null) {
            partBinding = partpackage.get(partName);
        }
        return partBinding;
    }

    @Override
    public boolean isProject() {
        return false;
    }

    @Override
    public int hasPart(String packageName, String partName) {
        IPartBinding partBinding = this.getPartBinding(packageName, partName);
        if (partBinding != null) {
            return partBinding.getKind();
        }
        return 1;
    }

    @Override
    public Part findPart(String packageName, String partName) throws PartNotFoundException {
        EObject obj;
        if (this.hasPart(packageName, partName) != 1 && (obj = this.getPartObject(this.getEntry(packageName, partName))) instanceof Part) {
            return (Part)obj;
        }
        return null;
    }

    protected Map<String, IRPartBinding> getPackagePartBinding(String packageName) {
        Map<String, IRPartBinding> map;
        if (packageName == null) {
            packageName = "";
        }
        if ((map = this.partBindingsByPackage.get(packageName)) == null) {
            map = new HashMap<String, IRPartBinding>();
            this.partBindingsByPackage.put(packageName, map);
        }
        return map;
    }

    @Override
    public IEnvironment getRealizingEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getFileExtension() {
        return this.fileExtension;
    }

    public void setStore(ObjectStore store) {
        this.store = store;
    }

    public IRPartBinding getPartBinding(String entry) {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        IRPartBinding retVal = null;
        String partname = this.getPartName(entry);
        String packageName = this.getPackageName(entry);
        retVal = this.getCachedPartBinding(packageName, partname);
        if (retVal != null) {
            return retVal;
        }
        EObject part = this.getPartObject(entry);
        if (part != null && (retVal = BindingUtil.createPartBinding(part)) != null) {
            Map<String, IRPartBinding> partpackage = this.getPackagePartBinding(packageName);
            partpackage.put(retVal.getIrPart().getName(), retVal);
            retVal.setEnvironment(this.getEnvironment());
            if (this.shouldSetEnvironmentOnIr()) {
                BindingUtil.setEnvironment((Element)retVal.getIrPart(), this.getEnvironment());
            }
            this.bindingLoaded(retVal);
        }
        return retVal;
    }

    protected boolean shouldSetEnvironmentOnIr() {
        return false;
    }

    protected EObject getPartObject(String entry) {
        if (entry == null || entry.length() == 0) {
            return null;
        }
        String key = this.convertToStoreKey(entry);
        try {
            return this.store.get(key);
        }
        catch (DeserializationException e) {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    protected void bindingLoaded(IRPartBinding partBinding) {
    }

    @Override
    public ObjectStore[] getObjectStores() {
        return new ObjectStore[]{this.store};
    }

    public boolean hasEntry(String entry) {
        entry = entry.toUpperCase().toLowerCase();
        String[] entries = this.getAllEntries();
        int i = 0;
        while (i < entries.length) {
            if (entry.equalsIgnoreCase(entries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ObjectStore getObjectStore() {
        return this.store;
    }
}

