/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import org.eclipse.edt.compiler.binding.AnnotationTypeValueGatherer;
import org.eclipse.edt.compiler.binding.AnnotationValueGatherer;
import org.eclipse.edt.compiler.binding.AnnotationValueValidator;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationRightHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EMemberContainer;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.utils.NameUtile;

public class AnnotationTypeCompletor
extends DefaultBinder {
    private AnnotationType annotationType;
    private IRPartBinding irBinding;

    public AnnotationTypeCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, (Part)((AnnotationType)irBinding.getIrPart()), dependencyRequestor, problemRequestor, compilerOptions);
        this.annotationType = (AnnotationType)irBinding.getIrPart();
        this.irBinding = irBinding;
    }

    @Override
    public boolean visit(Record record) {
        record.getSubType().setBindAttempted(true);
        if (record.isPrivate()) {
            this.annotationType.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        record.getName().setType((org.eclipse.edt.mof.egl.Type)this.annotationType);
        this.processFields(record);
        this.processSettingsBlocks(record);
        return false;
    }

    private void processSettingsBlocks(Record record) {
        record.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                if (assignment.getLeftHandSide() instanceof SimpleName) {
                    SimpleName simpName = (SimpleName)assignment.getLeftHandSide();
                    EField field = AnnotationTypeCompletor.this.annotationType.getEClass().getEField(simpName.getIdentifier());
                    if (field != null) {
                        AnnotationRightHandScope rhScope = new AnnotationRightHandScope(AnnotationTypeCompletor.this.currentScope, field);
                        Object obj = new AnnotationTypeValueGatherer(assignment.getRightHandSide(), field, rhScope, (Part)AnnotationTypeCompletor.this.annotationType, AnnotationTypeCompletor.this.dependencyRequestor, AnnotationTypeCompletor.this.problemRequestor, AnnotationTypeCompletor.this.compilerOptions).getValue();
                        AnnotationValueValidator validator = new AnnotationValueValidator(AnnotationTypeCompletor.this.problemRequestor);
                        Object result = validator.validateValue(obj, assignment.getRightHandSide(), field, field.getEType(), field.isNullable());
                        if (result != null) {
                            AnnotationTypeCompletor.this.annotationType.eSet(field, result);
                        }
                        simpName.setBindAttempted(true);
                    }
                }
                return false;
            }

            @Override
            public void endVisit(SettingsBlock settingsBlock) {
                AnnotationLeftHandScope scope = new AnnotationLeftHandScope(NullScope.INSTANCE, (Element)AnnotationTypeCompletor.this.annotationType, (org.eclipse.edt.mof.egl.Type)AnnotationTypeCompletor.this.annotationType, (Element)AnnotationTypeCompletor.this.annotationType);
                SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(AnnotationTypeCompletor.this.currentScope, (Part)AnnotationTypeCompletor.this.annotationType, scope, AnnotationTypeCompletor.this.dependencyRequestor, AnnotationTypeCompletor.this.problemRequestor, AnnotationTypeCompletor.this.compilerOptions);
                settingsBlock.accept(blockCompletor);
            }
        });
    }

    private void processFields(Record record) {
        final HashSet definedNames = new HashSet();
        record.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                return true;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                EType eType = null;
                try {
                    eType = AnnotationTypeCompletor.this.bindEType(structureItem.getType());
                }
                catch (ResolutionException e) {
                    AnnotationTypeCompletor.this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                    if (structureItem.hasSettingsBlock()) {
                        AnnotationTypeCompletor.setBindAttemptedForNames(structureItem.getSettingsBlock());
                    }
                    return false;
                }
                final EField field = this.createEField(structureItem, eType);
                if (definedNames.contains(NameUtile.getAsName((String)field.getName()))) {
                    AnnotationTypeCompletor.this.problemRequestor.acceptProblem((Node)structureItem.getName(), 3010, new String[]{structureItem.getName().getCanonicalName(), AnnotationTypeCompletor.this.annotationType.getCaseSensitiveName()});
                } else {
                    definedNames.add(NameUtile.getAsName((String)field.getName()));
                    AnnotationTypeCompletor.this.annotationType.getEFields().add(field);
                    structureItem.getName().setElement(field);
                }
                if (structureItem.hasSettingsBlock()) {
                    AnnotationLeftHandScope lhScope = new AnnotationLeftHandScope(NullScope.INSTANCE, null, null, null);
                    SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(AnnotationTypeCompletor.this.currentScope, (Part)AnnotationTypeCompletor.this.annotationType, lhScope, AnnotationTypeCompletor.this.dependencyRequestor, AnnotationTypeCompletor.this.problemRequestor, AnnotationTypeCompletor.this.compilerOptions);
                    structureItem.getSettingsBlock().accept(blockCompletor);
                    structureItem.getSettingsBlock().accept(new DefaultASTVisitor(){

                        @Override
                        public boolean visit(SettingsBlock settingsBlock) {
                            return true;
                        }

                        @Override
                        public boolean visit(AnnotationExpression annExpr) {
                            if (annExpr.resolveAnnotation() != null) {
                                field.getMetadataList().add(annExpr.resolveAnnotation());
                            }
                            return false;
                        }
                    });
                }
                if (structureItem.hasInitializer()) {
                    AnnotationRightHandScope rhScope = new AnnotationRightHandScope(AnnotationTypeCompletor.this.currentScope, field);
                    Object obj = new AnnotationValueGatherer(structureItem.getInitializer(), rhScope, (Part)AnnotationTypeCompletor.this.annotationType, AnnotationTypeCompletor.this.dependencyRequestor, AnnotationTypeCompletor.this.problemRequestor, AnnotationTypeCompletor.this.compilerOptions).getValue();
                    AnnotationValueValidator validator = new AnnotationValueValidator(AnnotationTypeCompletor.this.problemRequestor);
                    Object result = validator.validateValue(obj, structureItem.getInitializer(), field, field.getEType(), field.isNullable());
                    if (result != null) {
                        field.setInitialValue(result);
                    }
                }
                return false;
            }

            public EField createEField(StructureItem structureItem, EType etype) {
                String fieldName = structureItem.getName().getCaseSensitiveIdentifier();
                EField field = MofFactory.INSTANCE.createEField(true);
                field.setName(fieldName);
                field.setDeclarer((EMemberContainer)AnnotationTypeCompletor.this.annotationType);
                field.setEType(etype);
                field.setIsNullable(structureItem.isNullable());
                structureItem.getName().setBindAttempted(true);
                return field;
            }
        });
    }

    @Override
    public void endVisit(Record record) {
        this.irBinding.setValid(true);
        super.endVisit(record);
    }

    public EType bindEType(Type type) throws ResolutionException {
        switch (type.getKind()) {
            case 1: {
                ArrayType arrayType = (ArrayType)type;
                if (arrayType.hasInitialSize()) {
                    this.problemRequestor.acceptProblem((Node)arrayType.getInitialSize(), 3248, new String[0]);
                }
                EType elementType = this.bindEType(arrayType.getElementType());
                EGenericType genType = MofFactory.INSTANCE.createEGenericType(true);
                try {
                    genType.setEClassifier((EClassifier)Environment.getCurrentEnv().findType("org.eclipse.edt.mof.EList"));
                }
                catch (Exception exception) {}
                genType.getETypeArguments().add(elementType);
                return genType;
            }
            case 0: {
                NameType nameType = (NameType)type;
                org.eclipse.edt.mof.egl.Type result = this.bindTypeName(nameType.getName());
                if (nameType.getArguments() != null && nameType.getArguments().size() > 0) {
                    this.problemRequestor.acceptProblem((Node)type, 3514, new String[0]);
                }
                return this.translateToEType(result, nameType);
            }
        }
        throw new RuntimeException("Shouldn't come into here");
    }

    private EType translateToEType(org.eclipse.edt.mof.egl.Type type, NameType nameType) throws ResolutionException {
        if (type == null || type.getClassifier() == null) {
            return null;
        }
        try {
            EObject proxiedType;
            Classifier classifier = type.getClassifier();
            if (classifier.equals(TypeUtils.Type_ANY).booleanValue()) {
                return (EType)Environment.getCurrentEnv().find("org.eclipse.edt.mof.JavaObject");
            }
            if (classifier.equals(TypeUtils.Type_BOOLEAN).booleanValue()) {
                return (EType)Environment.getCurrentEnv().find("org.eclipse.edt.mof.EBoolean");
            }
            if (classifier.equals(TypeUtils.Type_STRING).booleanValue()) {
                return (EType)Environment.getCurrentEnv().find("org.eclipse.edt.mof.EString");
            }
            if (classifier.equals(TypeUtils.Type_INT).booleanValue() || type.equals(TypeUtils.Type_SMALLINT).booleanValue() || type.equals(TypeUtils.Type_BIGINT).booleanValue()) {
                return (EType)Environment.getCurrentEnv().find("org.eclipse.edt.mof.EInt32");
            }
            if (classifier.equals(TypeUtils.Type_FLOAT).booleanValue() || type.equals(TypeUtils.Type_SMALLFLOAT).booleanValue()) {
                return (EType)Environment.getCurrentEnv().find("org.eclipse.edt.mof.EFloat");
            }
            if (classifier.equals(TypeUtils.Type_DECIMAL).booleanValue()) {
                return (EType)Environment.getCurrentEnv().find("org.eclipse.edt.mof.EDecimal");
            }
            EType etype = BindingUtil.getETypeFromProxy((Element)type);
            if (etype != null) {
                return etype;
            }
            if (type instanceof EType) {
                return (EType)type;
            }
            if (type instanceof Classifier && (proxiedType = BindingUtil.getMofClassProxyFor((Classifier)type)) instanceof EType) {
                return (EType)proxiedType;
            }
        }
        catch (Exception exception) {}
        throw new ResolutionException(nameType.getName().getOffset(), nameType.getName().getOffset() + nameType.getName().getLength(), 3515, new String[]{nameType.getName().getCanonicalName(), this.annotationType.getCaseSensitiveName()});
    }
}

