/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;

public class ClassBindingCompletor
extends FunctionContainerBindingCompletor {
    private EGLClass classBinding;

    public ClassBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(irBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.classBinding = (EGLClass)irBinding.getIrPart();
    }

    @Override
    public boolean visit(Class eglClass) {
        eglClass.getName().setType((Type)this.classBinding);
        eglClass.accept(this.getPartSubTypeAndAnnotationCollector());
        if (eglClass.isPrivate()) {
            this.classBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        this.classBinding.setIsAbstract(Boolean.valueOf(eglClass.isAbstract()));
        if (eglClass.getExtends() != null) {
            try {
                Type typeBinding = this.bindTypeName(eglClass.getExtends());
                if (typeBinding instanceof StructPart) {
                    this.classBinding.getSuperTypes().add((StructPart)typeBinding);
                }
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        for (Name nextName : eglClass.getImplementedInterfaces()) {
            try {
                Type typeBinding = this.bindTypeName(nextName);
                if (!(typeBinding instanceof StructPart)) continue;
                this.classBinding.getSuperTypes().add((StructPart)typeBinding);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        this.setDefaultSuperType();
        return true;
    }

    @Override
    public void endVisit(Class eglClass) {
        this.processSettingsBlocks();
        this.endVisitFunctionContainer(eglClass);
    }

    @Override
    protected StereotypeType getDefaultStereotypeType() {
        return null;
    }
}

