/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.EnumerationScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class EnumerationBindingCompletor
extends AbstractBinder {
    private org.eclipse.edt.mof.egl.Enumeration enumerationBinding;
    private IProblemRequestor problemRequestor;
    private Set<String> fieldNames = new HashSet<String>();

    public EnumerationBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, irBinding.getIrPart(), dependencyRequestor, compilerOptions);
        this.enumerationBinding = (org.eclipse.edt.mof.egl.Enumeration)irBinding.getIrPart();
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Enumeration enumeration) {
        enumeration.getName().setType((Type)this.enumerationBinding);
        if (enumeration.isPrivate()) {
            this.enumerationBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        return true;
    }

    @Override
    public void endVisit(Enumeration enumeration) {
        BindingUtil.setValid((Part)this.enumerationBinding, true);
    }

    @Override
    public boolean visit(EnumerationField enumerationField) {
        int constantValue = -1;
        if (enumerationField.hasConstantValue()) {
            final int[] constantValueAry = new int[]{-1};
            enumerationField.getConstantValue().accept(new AbstractASTExpressionVisitor(){

                @Override
                public void endVisit(IntegerLiteral integerLiteral) {
                    try {
                        constantValueAry[0] = Integer.parseInt(integerLiteral.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }

                @Override
                public boolean visit(UnaryExpression unaryExpression) {
                    return true;
                }

                @Override
                public void endVisit(UnaryExpression unaryExpression) {
                    if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                        constantValueAry[0] = constantValueAry[0] * -1;
                    }
                }

                @Override
                public void endVisitExpression(Expression expression) {
                }
            });
            constantValue = constantValueAry[0];
        } else {
            constantValue = this.fieldNames.size();
        }
        EnumerationEntry enumEntry = IrFactory.INSTANCE.createEnumerationEntry();
        enumEntry.setContainer((Container)this.enumerationBinding);
        enumEntry.setName(enumerationField.getName().getCaseSensitiveIdentifier());
        enumEntry.setValue(constantValue);
        enumerationField.getName().setElement(enumEntry);
        enumEntry.setIsStatic(Boolean.valueOf(true));
        if (enumerationField.hasSettingsBlock()) {
            SettingsBlock settingsBlock = enumerationField.getSettingsBlock();
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, (Element)enumEntry, (Type)this.enumerationBinding, (Element)enumEntry);
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, (Part)this.enumerationBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            settingsBlock.accept(blockCompletor);
        }
        if (this.fieldNames.contains(enumerationField.getName().getIdentifier())) {
            this.problemRequestor.acceptProblem((Node)enumerationField.getName(), 3010, new String[]{enumerationField.getName().getCanonicalName(), this.enumerationBinding.getCaseSensitiveName()});
        } else {
            this.fieldNames.add(enumerationField.getName().getIdentifier());
            this.enumerationBinding.getEntries().add(enumEntry);
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        EnumerationScope enumScope = new EnumerationScope(NullScope.INSTANCE, this.enumerationBinding);
        AnnotationLeftHandScope scope = new AnnotationLeftHandScope(enumScope, (Element)this.enumerationBinding, (Type)this.enumerationBinding, (Element)this.enumerationBinding);
        SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, (Part)this.enumerationBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        settingsBlock.accept(blockCompletor);
        return false;
    }
}

