/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class FunctionBindingCompletor
extends AbstractBinder {
    private FunctionMember functionBinding;
    private Part partBinding;
    private IProblemRequestor problemRequestor;
    private Set<String> definedParameters = new HashSet<String>();

    public FunctionBindingCompletor(Part partBinding, Scope currentScope, FunctionMember function, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, partBinding, dependencyRequestor, compilerOptions);
        this.partBinding = partBinding;
        this.functionBinding = function;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(NestedFunction function) {
        function.getName().setMember((Member)this.functionBinding);
        this.functionBinding.setIsStatic(Boolean.valueOf(function.isStatic()));
        this.functionBinding.setIsAbstract(Boolean.valueOf(function.isAbstract()));
        if (function.isPrivate()) {
            this.functionBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        if (function.hasReturnType()) {
            org.eclipse.edt.mof.egl.Type typeBinding = null;
            try {
                typeBinding = this.bindType(function.getReturnType());
                this.functionBinding.setType(typeBinding);
                this.functionBinding.setIsNullable(function.getReturnDeclaration().isNullable());
                Field returnField = IrFactory.INSTANCE.createField();
                returnField.setContainer((Container)this.functionBinding);
                returnField.setType(typeBinding);
                returnField.setIsNullable(function.getReturnDeclaration().isNullable());
                ((Function)this.functionBinding).setReturnField(returnField);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return true;
    }

    @Override
    public void endVisit(NestedFunction function) {
        function.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedFunction function) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                FunctionScope functionScope = new FunctionScope(NullScope.INSTANCE, FunctionBindingCompletor.this.functionBinding);
                AnnotationLeftHandScope scope = new AnnotationLeftHandScope(functionScope, (Element)FunctionBindingCompletor.this.functionBinding, null, (Element)FunctionBindingCompletor.this.functionBinding);
                functionScope = new FunctionScope(FunctionBindingCompletor.this.currentScope, FunctionBindingCompletor.this.functionBinding);
                SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(functionScope, FunctionBindingCompletor.this.partBinding, scope, FunctionBindingCompletor.this.dependencyRequestor, FunctionBindingCompletor.this.problemRequestor, FunctionBindingCompletor.this.compilerOptions);
                settingsBlock.accept(blockCompletor);
                return false;
            }
        });
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
        String parmName = functionParameter.getName().getIdentifier();
        Type parmType = functionParameter.getType();
        org.eclipse.edt.mof.egl.Type typeBinding = null;
        FunctionParameter parm = IrFactory.INSTANCE.createFunctionParameter();
        parm.setContainer((Container)this.functionBinding);
        parm.setName(functionParameter.getName().getCaseSensitiveIdentifier());
        functionParameter.getName().setMember((Member)parm);
        try {
            typeBinding = this.bindType(parmType);
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            return false;
        }
        parm.setType(typeBinding);
        parm.setIsNullable(functionParameter.isNullable());
        parm.setIsConst(Boolean.valueOf(functionParameter.isParmConst()));
        FunctionParameter.UseType useType = functionParameter.getUseType();
        if (useType == FunctionParameter.UseType.IN) {
            parm.setParameterKind(ParameterKind.PARM_IN);
        } else if (useType == FunctionParameter.UseType.OUT) {
            parm.setParameterKind(ParameterKind.PARM_OUT);
        } else if (useType == null && typeBinding != null && TypeUtils.isReferenceType((org.eclipse.edt.mof.egl.Type)typeBinding)) {
            parm.setParameterKind(ParameterKind.PARM_IN);
        } else {
            parm.setParameterKind(ParameterKind.PARM_INOUT);
        }
        if (this.definedParameters.contains(parmName)) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 3012, new String[]{parmName, this.functionBinding.getCaseSensitiveName()});
        } else {
            this.functionBinding.addParameter(parm);
            this.definedParameters.add(parmName);
        }
        return false;
    }
}

