/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.Type;

public class InterfaceBindingCompletor
extends FunctionContainerBindingCompletor {
    private Interface interfaceBinding;

    public InterfaceBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(irBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.interfaceBinding = (Interface)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Interface interfaceAST) {
        interfaceAST.getName().setType((Type)this.interfaceBinding);
        interfaceAST.accept(this.getPartSubTypeAndAnnotationCollector());
        if (interfaceAST.isPrivate()) {
            this.interfaceBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        this.processExtends(interfaceAST);
        this.setDefaultSuperType();
        return true;
    }

    private void processExtends(org.eclipse.edt.compiler.core.ast.Interface interfaceAST) {
        if (interfaceAST.hasExtendedType()) {
            for (Name name : interfaceAST.getExtendedTypes()) {
                try {
                    Type typeBinding = this.bindTypeName(name);
                    if (!(typeBinding instanceof Interface)) continue;
                    this.interfaceBinding.getSuperTypes().add((Interface)typeBinding);
                }
                catch (ResolutionException e) {
                    this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                }
            }
        }
    }

    @Override
    public void endVisit(org.eclipse.edt.compiler.core.ast.Interface interfaceNode) {
        this.processSettingsBlocks();
        this.endVisitFunctionContainer(interfaceNode);
    }

    @Override
    protected StereotypeType getDefaultStereotypeType() {
        return null;
    }
}

