/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Statement;

public class ContinueStatement
extends Statement {
    private ContinueModifier continueModifierOpt;

    public ContinueStatement(ContinueModifier continueModifierOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (continueModifierOpt != null) {
            this.continueModifierOpt = continueModifierOpt;
        }
    }

    public boolean isContinueFor() {
        return this.continueModifierOpt == DefaultContinueModifier.FOR;
    }

    public boolean isContinueForEach() {
        return this.continueModifierOpt == DefaultContinueModifier.FOREACH;
    }

    public boolean isContinueWhile() {
        return this.continueModifierOpt == DefaultContinueModifier.WHILE;
    }

    public boolean isContinueLabel() {
        return this.continueModifierOpt == null ? false : this.continueModifierOpt.hasLabel();
    }

    public String getLabel() {
        return this.continueModifierOpt == null ? null : this.continueModifierOpt.getLabel();
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ContinueStatement(this.continueModifierOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public static abstract class ContinueModifier {
        public String getLabel() {
            return null;
        }

        public boolean hasLabel() {
            return false;
        }

        protected abstract Object clone() throws CloneNotSupportedException;
    }

    public static class DefaultContinueModifier
    extends ContinueModifier {
        public static final ContinueModifier FOR = new DefaultContinueModifier();
        public static final ContinueModifier FOREACH = new DefaultContinueModifier();
        public static final ContinueModifier WHILE = new DefaultContinueModifier();

        private DefaultContinueModifier() {
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return this;
        }
    }

    public static class LabelContinueModifier
    extends ContinueModifier {
        private String label;

        public LabelContinueModifier(String label) {
            this.label = label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            String newLabel = this.label != null ? new String(this.label) : null;
            return new LabelContinueModifier(newLabel);
        }
    }
}

