/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;

public class ExitStatement
extends Statement {
    private ExitModifier exitModifierOpt;
    private SettingsBlock settingsBlockOpt;

    public ExitStatement(ExitModifier exitModifierOpt, SettingsBlock settingsBlockOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (exitModifierOpt != null) {
            this.exitModifierOpt = exitModifierOpt;
            exitModifierOpt.setParent(this);
        }
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
    }

    public ExitModifier getExitModifierOpt() {
        return this.exitModifierOpt;
    }

    public boolean isExitProgram() {
        return this.exitModifierOpt != null && this.exitModifierOpt.isProgramExitModifier();
    }

    public Expression getReturnCode() {
        return this.exitModifierOpt == null ? null : this.exitModifierOpt.getExpression();
    }

    public boolean isExitStack() {
        return this.exitModifierOpt != null && this.exitModifierOpt.isStackExitModifier();
    }

    public boolean isExitRunUnit() {
        return this.exitModifierOpt != null && this.exitModifierOpt.isRunUnitExitModifier();
    }

    public String getLabel() {
        return this.exitModifierOpt == null ? null : this.exitModifierOpt.getLabel();
    }

    public boolean isExitCase() {
        return this.exitModifierOpt == DefaultExitModifier.CASE;
    }

    public boolean isExitIf() {
        return this.exitModifierOpt == DefaultExitModifier.IF;
    }

    public boolean isExitWhile() {
        return this.exitModifierOpt == DefaultExitModifier.WHILE;
    }

    public boolean isExitFor() {
        return this.exitModifierOpt == DefaultExitModifier.FOR;
    }

    public boolean isExitForEach() {
        return this.exitModifierOpt == DefaultExitModifier.FOREACH;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.exitModifierOpt != null) {
                this.exitModifierOpt.accept(visitor);
            }
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ExitModifier newExitModifierOpt = this.exitModifierOpt != null ? (ExitModifier)this.exitModifierOpt.clone() : null;
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        return new ExitStatement(newExitModifierOpt, newSettingsBlockOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public static class DefaultExitModifier
    extends ExitModifier {
        public static final DefaultExitModifier CASE = new DefaultExitModifier();
        public static final DefaultExitModifier IF = new DefaultExitModifier();
        public static final DefaultExitModifier WHILE = new DefaultExitModifier();
        public static final DefaultExitModifier FOR = new DefaultExitModifier();
        public static final DefaultExitModifier FOREACH = new DefaultExitModifier();

        private DefaultExitModifier() {
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return this;
        }
    }

    public static abstract class ExitModifier
    implements Cloneable {
        public boolean isProgramExitModifier() {
            return false;
        }

        public boolean isRunUnitExitModifier() {
            return false;
        }

        public boolean isStackExitModifier() {
            return false;
        }

        public boolean isLabelExitModifier() {
            return false;
        }

        public Expression getExpression() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public void setParent(Node parent) {
        }

        public void accept(IASTVisitor visitor) {
        }

        protected abstract Object clone() throws CloneNotSupportedException;
    }

    public static class LabelExitModifier
    extends ExitModifier {
        private String label;

        public LabelExitModifier(String simpleNameOpt) {
            this.label = simpleNameOpt;
        }

        @Override
        public boolean isLabelExitModifier() {
            return true;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            String newLabel = this.label != null ? new String(this.label) : null;
            return new LabelExitModifier(newLabel);
        }
    }

    public static abstract class OptionalExpressionExitModifier
    extends ExitModifier {
        protected Expression parenthesizedExprOpt;

        protected OptionalExpressionExitModifier(Expression parenthesizedExprOpt) {
            if (parenthesizedExprOpt != null) {
                this.parenthesizedExprOpt = parenthesizedExprOpt;
            }
        }

        @Override
        public Expression getExpression() {
            return this.parenthesizedExprOpt;
        }

        @Override
        public void setParent(Node parent) {
            if (this.parenthesizedExprOpt != null) {
                this.parenthesizedExprOpt.setParent(parent);
            }
        }

        @Override
        public void accept(IASTVisitor visitor) {
            if (this.parenthesizedExprOpt != null) {
                this.parenthesizedExprOpt.accept(visitor);
            }
        }
    }

    public static class ProgramExitModifier
    extends OptionalExpressionExitModifier {
        public ProgramExitModifier(Expression parenthesizedExprOpt) {
            super(parenthesizedExprOpt);
        }

        @Override
        public boolean isProgramExitModifier() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            Expression newParenthesizedExprOpt = this.parenthesizedExprOpt != null ? (Expression)this.parenthesizedExprOpt.clone() : null;
            return new ProgramExitModifier(newParenthesizedExprOpt);
        }
    }

    public static class RunUnitExitModifier
    extends OptionalExpressionExitModifier {
        public RunUnitExitModifier(Expression parenthesizedExprOpt) {
            super(parenthesizedExprOpt);
        }

        @Override
        public boolean isRunUnitExitModifier() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            Expression newParenthesizedExprOpt = this.parenthesizedExprOpt != null ? (Expression)this.parenthesizedExprOpt.clone() : null;
            return new RunUnitExitModifier(newParenthesizedExprOpt);
        }
    }

    public static class StackExitModifier
    extends ExitModifier {
        private String label;

        public StackExitModifier(String simpleNameOpt) {
            this.label = simpleNameOpt;
        }

        @Override
        public boolean isStackExitModifier() {
            return true;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            String newLabel = this.label != null ? new String(this.label) : null;
            return new StackExitModifier(newLabel);
        }
    }
}

