/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.Type;

public class ForStatement
extends Statement {
    private Expression lvalue;
    private Expression fromExprOpt;
    private Expression expr;
    private ForStep stepOpt;
    private List stmts;
    private SimpleName declarationName;
    private Type declarationType;
    private boolean isNullable;

    public ForStatement(Expression lvalue, SimpleName declarationName, Type declarationType, Boolean isNullable, Expression fromExprOpt, Expression expr, ForStep stepOpt, List stmts, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (lvalue != null) {
            this.lvalue = lvalue;
            lvalue.setParent(this);
        }
        if (declarationName != null) {
            this.declarationName = declarationName;
            declarationName.setParent(this);
        }
        if (declarationType != null) {
            this.declarationType = declarationType;
            declarationType.setParent(this);
        }
        if (fromExprOpt != null) {
            this.fromExprOpt = fromExprOpt;
            fromExprOpt.setParent(this);
        }
        this.expr = expr;
        expr.setParent(this);
        if (stepOpt != null) {
            this.stepOpt = stepOpt;
            stepOpt.setParent(this);
        }
        this.stmts = this.setParent(stmts);
        this.isNullable = isNullable;
    }

    public boolean hasVariableDeclaration() {
        return this.declarationName != null;
    }

    public Expression getCounterVariable() {
        return this.lvalue;
    }

    public Name getVariableDeclarationName() {
        return this.declarationName;
    }

    public Type getVariableDeclarationType() {
        return this.declarationType;
    }

    public boolean hasFromIndex() {
        return this.fromExprOpt != null;
    }

    public Expression getFromIndex() {
        return this.fromExprOpt;
    }

    public Expression getEndIndex() {
        return this.expr;
    }

    public boolean hasPositiveDelta() {
        return this.stepOpt != null && this.stepOpt.isIncrement();
    }

    public boolean hasNegativeDelta() {
        return this.stepOpt != null && this.stepOpt.isDecrement();
    }

    public Expression getDeltaExpression() {
        return this.stepOpt == null ? null : this.stepOpt.getExpression();
    }

    public List<Node> getStmts() {
        return this.stmts;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.lvalue == null) {
                this.declarationName.accept(visitor);
                this.declarationType.accept(visitor);
            } else {
                this.lvalue.accept(visitor);
            }
            if (this.fromExprOpt != null) {
                this.fromExprOpt.accept(visitor);
            }
            this.expr.accept(visitor);
            if (this.stepOpt != null) {
                this.stepOpt.accept(visitor);
            }
            ForStatement.acceptChildren(visitor, this.stmts);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    public List getStatementBlocks() {
        return Arrays.asList(this.stmts);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Expression newFromExprOpt = this.fromExprOpt != null ? (Expression)this.fromExprOpt.clone() : null;
        ForStep newStepOpt = this.stepOpt != null ? (ForStep)this.stepOpt.clone() : null;
        Expression lval = this.lvalue == null ? null : (Expression)this.lvalue.clone();
        SimpleName declName = this.declarationName == null ? null : (SimpleName)this.declarationName.clone();
        Type declType = this.declarationType == null ? null : (Type)this.declarationType.clone();
        return new ForStatement(lval, declName, declType, this.isNullable, newFromExprOpt, (Expression)this.expr.clone(), newStepOpt, this.cloneList(this.stmts), this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class DecrementForStep
    extends ForStep {
        public DecrementForStep(Expression expr) {
            super(expr);
        }

        @Override
        boolean isDecrement() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new DecrementForStep((Expression)this.expr.clone());
        }
    }

    public static class ForStep
    implements Cloneable {
        Expression expr;

        public ForStep(Expression expr) {
            this.expr = expr;
        }

        boolean isIncrement() {
            return false;
        }

        boolean isDecrement() {
            return false;
        }

        Expression getExpression() {
            return this.expr;
        }

        void setParent(Node parent) {
            this.expr.setParent(parent);
        }

        void accept(IASTVisitor visitor) {
            this.expr.accept(visitor);
        }

        protected Object clone() throws CloneNotSupportedException {
            return new ForStep((Expression)this.expr.clone());
        }
    }

    public static class IncrementForStep
    extends ForStep {
        public IncrementForStep(Expression expr) {
            super(expr);
        }

        @Override
        boolean isIncrement() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new IncrementForStep((Expression)this.expr.clone());
        }
    }
}

