/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ElseBlock;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Statement;

public class IfStatement
extends Statement {
    private Expression expr;
    private List stmts;
    private ElseBlock elseOpt;

    public IfStatement(Expression expr, List stmts, ElseBlock elseOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
        this.stmts = this.setParent(stmts);
        if (elseOpt != null) {
            this.elseOpt = elseOpt;
            elseOpt.setParent(this);
        }
    }

    public Expression getCondition() {
        return this.expr;
    }

    public List getStmts() {
        return this.stmts;
    }

    public boolean hasElse() {
        return this.elseOpt != null;
    }

    public ElseBlock getElse() {
        return this.elseOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            IfStatement.acceptChildren(visitor, this.stmts);
            if (this.elseOpt != null) {
                this.elseOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    public List getStatementBlocks() {
        ArrayList<List> result = new ArrayList<List>();
        result.add(this.stmts);
        if (this.elseOpt != null) {
            result.add(this.elseOpt.getStmts());
        }
        return result;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ElseBlock newElseOpt = this.elseOpt != null ? (ElseBlock)this.elseOpt.clone() : null;
        return new IfStatement((Expression)this.expr.clone(), this.cloneList(this.stmts), newElseOpt, this.getOffset(), this.getOffset() + this.getLength());
    }
}

