/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;

public class IntegerLiteral
extends LiteralExpression {
    private final int type;
    private final String value;

    public IntegerLiteral(int type, String value, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.type = type;
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int getLiteralKind() {
        return this.type;
    }

    @Override
    public String getCanonicalString() {
        if (this.type == 0) {
            return this.value;
        }
        return String.valueOf(this.value) + (this.type == 13 ? "i" : "I");
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new IntegerLiteral(this.type, new String(this.value), this.getOffset(), this.getOffset() + this.getLength());
    }
}

