/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.Type;

public class NestedFunction
extends Node {
    private SimpleName name;
    private boolean isPrivate;
    private boolean isStatic;
    private boolean isAbstract;
    private List functionParameters;
    private ReturnsDeclaration returnsOpt;
    private SettingsBlock settingsBlockOpt;
    private List<Statement> stmts;

    public NestedFunction(Boolean privateAccessModifierOpt, Boolean staticAccessModifierOpt, SimpleName name, List functionParameters, ReturnsDeclaration returnsOpt, SettingsBlock settingsBlockOpt, List stmts, boolean isAbstract, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
        this.isPrivate = privateAccessModifierOpt;
        this.isStatic = staticAccessModifierOpt;
        this.isAbstract = isAbstract;
        this.functionParameters = this.setParent(functionParameters);
        if (returnsOpt != null) {
            this.returnsOpt = returnsOpt;
            returnsOpt.setParent(this);
        }
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
        this.stmts = this.setParent(stmts);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Name getName() {
        return this.name;
    }

    public List getFunctionParameters() {
        return this.functionParameters;
    }

    public boolean hasReturnType() {
        return this.returnsOpt != null;
    }

    public Type getReturnType() {
        return this.returnsOpt.getType();
    }

    public ReturnsDeclaration getReturnDeclaration() {
        return this.returnsOpt;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public List<Statement> getStmts() {
        return this.stmts;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
            NestedFunction.acceptChildren(visitor, this.functionParameters);
            if (this.returnsOpt != null) {
                this.returnsOpt.accept(visitor);
            }
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
            NestedFunction.acceptChildren(visitor, this.stmts);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ReturnsDeclaration newReturnsOpt = this.returnsOpt != null ? (ReturnsDeclaration)this.returnsOpt.clone() : null;
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        return new NestedFunction(new Boolean(this.isPrivate), new Boolean(this.isStatic), (SimpleName)this.name.clone(), this.cloneList(this.functionParameters), newReturnsOpt, newSettingsBlockOpt, this.cloneList(this.stmts), this.isAbstract, this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        if (this.isPrivate) {
            buf.append("private ");
        }
        if (this.isStatic) {
            buf.append("static ");
        }
        if (this.isAbstract) {
            buf.append("abstract ");
        }
        buf.append("function ");
        buf.append(this.name.toString());
        buf.append('(');
        boolean first = true;
        for (Node n : this.functionParameters) {
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            buf.append(n.toString());
        }
        buf.append(')');
        if (this.returnsOpt != null) {
            buf.append(' ');
            buf.append(this.returnsOpt.toString());
        }
        if (this.settingsBlockOpt != null) {
            buf.append(this.settingsBlockOpt.toString());
        }
        return buf.toString();
    }
}

