/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.mof.egl.Constructor;

public class NewExpression
extends Expression {
    private Type type;
    private SettingsBlock settingsBlockOpt;
    private Constructor constructor;

    public NewExpression(Type type, SettingsBlock settingsBlockOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.type = type;
        type.setParent(this);
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getCanonicalString() {
        return "new " + this.type.getCanonicalName();
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public Constructor resolveConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.type.accept(visitor);
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        return new NewExpression((Type)this.type.clone(), newSettingsBlockOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("new ");
        buf.append(this.type.toString());
        if (this.settingsBlockOpt != null) {
            buf.append(this.settingsBlockOpt.toString());
        }
        return buf.toString();
    }
}

