/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;

public class ObjectExpressionEntry
extends Node {
    private String id;
    private Expression expr;

    public ObjectExpressionEntry(String id, Expression expr, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.id = id;
        this.expr = expr;
        expr.setParent(this);
    }

    public String getId() {
        return this.id;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
        }
        visitor.endVisit(this);
    }

    public String getCanonicalString() {
        StringBuffer result = new StringBuffer();
        result.append(this.id);
        result.append(" : ");
        result.append(this.expr.getCanonicalString());
        return result.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ObjectExpressionEntry(new String(this.id), (Expression)this.expr.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        return this.getCanonicalString();
    }
}

