/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;

public class OnExceptionBlock
extends Node {
    private List stmts;
    private SimpleName id;
    private Type type;
    private boolean isNullable;

    public OnExceptionBlock(List stmts, SimpleName id, Type type, Boolean isNullable, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.stmts = this.setParent(stmts);
        this.id = id;
        id.setParent(this);
        this.type = type;
        type.setParent(this);
        this.isNullable = isNullable;
    }

    public List<Node> getStmts() {
        return this.stmts;
    }

    public Name getExceptionName() {
        return this.id;
    }

    public Type getExceptionType() {
        return this.type;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            OnExceptionBlock.acceptChildren(visitor, this.stmts);
            this.id.accept(visitor);
            this.type.accept(visitor);
        }
        visitor.endVisit(this);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SimpleName newName = (SimpleName)this.id.clone();
        Type newType = (Type)this.type.clone();
        return new OnExceptionBlock(this.cloneList(this.stmts), newName, newType, this.isNullable, this.getOffset(), this.getOffset() + this.getLength());
    }
}

