/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;

public abstract class Part
extends Node {
    public static final int PROGRAM = 0;
    public static final int RECORD = 1;
    public static final int FUNCTION = 2;
    public static final int DATAITEM = 3;
    public static final int LIBRARY = 8;
    public static final int HANDLER = 9;
    public static final int SERVICE = 10;
    public static final int INTERFACE = 11;
    public static final int DELEGATE = 12;
    public static final int EXTERNALTYPE = 13;
    public static final int ENUMERATION = 14;
    public static final int CLASS = 15;
    protected boolean isPrivate;
    protected SimpleName name;
    protected List<Node> contents;
    private String identifier;

    public Part(Boolean isPrivate, SimpleName name, List contents, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
        this.contents = this.setParent(contents);
        this.isPrivate = isPrivate;
    }

    public Name getName() {
        return this.name;
    }

    public List<Node> getContents() {
        return this.contents;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isAbstract() {
        return false;
    }

    @Override
    protected abstract Object clone() throws CloneNotSupportedException;

    protected ArrayList cloneContents() throws CloneNotSupportedException {
        return this.cloneList(this.contents);
    }

    public Part clonePart() {
        try {
            Part newPart = (Part)this.clone();
            File newFile = new File(null, Collections.EMPTY_LIST, Collections.EMPTY_LIST, -1, -1);
            File oldFile = this.getFile();
            if (oldFile != null) {
                newFile.setSyntaxErrors(oldFile.getSyntaxErrors());
            }
            newPart.setParent(newFile);
            return newPart;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private File getFile() {
        if (this.getParent() instanceof File) {
            return (File)this.getParent();
        }
        return null;
    }

    public abstract String getPartTypeName();

    public abstract int getPartType();

    public abstract boolean hasSubType();

    public abstract Name getSubType();

    public void accept(ISyntaxErrorRequestor syntaxErrorRequestor) {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        file.accept(new SyntaxErrorRequestorSWrapper(syntaxErrorRequestor));
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.getName().getIdentifier();
        }
        return this.identifier;
    }

    public String toString() {
        return String.valueOf(this.isAbstract() ? "abstract " : "") + this.getPartTypeName() + " " + this.getName();
    }

    private class SyntaxErrorRequestorSWrapper
    implements ISyntaxErrorRequestor {
        int thisStart;
        int thisEnd;
        ISyntaxErrorRequestor requestor;

        public SyntaxErrorRequestorSWrapper(ISyntaxErrorRequestor requestor) {
            this.thisStart = Part.this.getOffset();
            this.thisEnd = Part.this.getOffset() + Part.this.getLength() - 1;
            this.requestor = requestor;
        }

        @Override
        public void incorrectNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.incorrectNonTerminal(nonTerminalType, startOffset, endOffset);
            }
        }

        @Override
        public void incorrectPhrase(int nonTerminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.incorrectPhrase(nonTerminalType, startOffset, endOffset);
            }
        }

        @Override
        public void incorrectPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.incorrectPreviousNonTerminal(nonTerminalType, startOffset, endOffset);
            }
        }

        @Override
        public void incorrectPreviousTerminal(int terminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.incorrectPreviousTerminal(terminalType, startOffset, endOffset);
            }
        }

        @Override
        public void incorrectTerminal(int terminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.incorrectTerminal(terminalType, startOffset, endOffset);
            }
        }

        @Override
        public void invalidCharacterInHexLiteral(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.invalidCharacterInHexLiteral(startOffset, endOffset);
            }
        }

        @Override
        public void invalidEscapeSequence(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.invalidEscapeSequence(startOffset, endOffset);
            }
        }

        @Override
        public void keywordAsName(int terminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.keywordAsName(terminalType, startOffset, endOffset);
            }
        }

        @Override
        public void missingEndForPart(int startOffset, int endOffset) {
            if (startOffset > this.thisStart && endOffset <= this.thisEnd || startOffset == this.thisEnd + 1) {
                this.requestor.missingEndForPart(startOffset, endOffset);
            }
        }

        @Override
        public void missingNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.missingNonTerminal(nonTerminalType, startOffset, endOffset);
            }
        }

        @Override
        public void missingPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.missingPreviousNonTerminal(nonTerminalType, startOffset, endOffset);
            }
        }

        @Override
        public void missingPreviousTerminal(int terminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.missingPreviousTerminal(terminalType, startOffset, endOffset);
            }
        }

        @Override
        public void missingScopeCloser(int terminalType, int startOffset, int endOffset) {
            if (startOffset > this.thisStart && endOffset <= this.thisEnd || startOffset == this.thisEnd + 1) {
                this.requestor.missingScopeCloser(terminalType, startOffset, endOffset);
            }
        }

        @Override
        public void missingTerminal(int terminalType, int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.missingTerminal(terminalType, startOffset, endOffset);
            }
        }

        @Override
        public void panicPhrase(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.panicPhrase(startOffset, endOffset);
            }
        }

        @Override
        public void tooManyErrors() {
        }

        @Override
        public void unclosedBlockComment(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.unclosedBlockComment(startOffset, endOffset);
            }
        }

        @Override
        public void unclosedSQL(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.unclosedSQL(startOffset, endOffset);
            }
        }

        @Override
        public void unclosedSQLCondition(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.unclosedSQLCondition(startOffset, endOffset);
            }
        }

        @Override
        public void unclosedString(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.unclosedString(startOffset, endOffset);
            }
        }

        @Override
        public void unexpectedPhrase(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.unexpectedPhrase(startOffset, endOffset);
            }
        }

        @Override
        public void unexpectedPreviousTerminal(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.unexpectedPreviousTerminal(startOffset, endOffset);
            }
        }

        @Override
        public void unexpectedTerminal(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.unexpectedTerminal(startOffset, endOffset);
            }
        }

        @Override
        public void whitespaceInSQL(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.whitespaceInSQL(startOffset, endOffset);
            }
        }

        @Override
        public void whitespaceInSQLCondition(int startOffset, int endOffset) {
            if (startOffset >= this.thisStart && endOffset <= this.thisEnd) {
                this.requestor.whitespaceInSQLCondition(startOffset, endOffset);
            }
        }
    }
}

