/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.mof.utils.NameUtile;

public class QualifiedName
extends Name {
    private Name qualifier;

    public QualifiedName(Name qualifier, String ID, int startOffset, int endOffset) {
        super(ID, startOffset, endOffset);
        this.qualifier = qualifier;
        qualifier.setParent(this);
    }

    @Override
    public boolean isQualifiedName() {
        return true;
    }

    public Name getQualifier() {
        return this.qualifier;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.qualifier.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalName() {
        return this.getCanonicalNameBuffer().toString();
    }

    @Override
    protected StringBuffer getCanonicalNameBuffer() {
        StringBuffer buffer = this.qualifier.getCanonicalNameBuffer();
        buffer.append('.');
        buffer.append(this.identifier);
        return buffer;
    }

    @Override
    public String getNameComponents() {
        return NameUtile.getAsName((String)this.getCanonicalName());
    }

    @Override
    protected List<String> getNameComponentsList() {
        List<String> nameComponentsList = this.qualifier.getNameComponentsList();
        nameComponentsList.add(this.identifier);
        return nameComponentsList;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new QualifiedName((Name)this.qualifier.clone(), this.identifier, this.getOffset(), this.getOffset() + this.getLength());
    }
}

