/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;

public class SettingsBlock
extends Node {
    private List settings;

    public SettingsBlock(List settings, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.settings = this.setParent(settings);
    }

    public List getSettings() {
        return this.settings;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            SettingsBlock.acceptChildren(visitor, this.settings);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new SettingsBlock(this.cloneList(this.settings), this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append('{');
        boolean first = true;
        for (Object setting : this.settings) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(setting.toString());
        }
        buf.append('}');
        return buf.toString();
    }
}

