/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class TernaryExpression
extends Expression {
    private Expression firstExpr;
    private Expression secondExpr;
    private Expression thirdExpr;

    public TernaryExpression(Expression firstExpr, Expression secondExpr, Expression thirdExpr, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.firstExpr = firstExpr;
        this.secondExpr = secondExpr;
        this.thirdExpr = thirdExpr;
    }

    public Expression getFirstExpr() {
        return this.firstExpr;
    }

    public void setFirstExpr(Expression firstExpr) {
        this.firstExpr = firstExpr;
    }

    public Expression getSecondExpr() {
        return this.secondExpr;
    }

    public void setSecondExpr(Expression secondExpr) {
        this.secondExpr = secondExpr;
    }

    public Expression getThirdExpr() {
        return this.thirdExpr;
    }

    public void setThirdExpr(Expression thirdExpr) {
        this.thirdExpr = thirdExpr;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.firstExpr.accept(visitor);
            this.secondExpr.accept(visitor);
            this.thirdExpr.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.firstExpr.getCanonicalString());
        buf.append(" ? ");
        buf.append(this.secondExpr.getCanonicalString());
        buf.append(" : ");
        buf.append(this.thirdExpr.getCanonicalString());
        return buf.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new TernaryExpression(this.firstExpr, this.secondExpr, this.thirdExpr, this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        return String.valueOf(this.firstExpr.toString()) + " ? " + this.secondExpr.toString() + " : " + this.thirdExpr.toString();
    }
}

