/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import org.eclipse.edt.compiler.internal.enumerations.EGLEnumeration;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Field;

public class EGLPropertyRule
implements Comparable {
    protected String name;
    protected String description = "";
    protected int[] types;
    protected int[] elementTypes;
    protected EGLPropertyRule[] elementAnnotationTypes;
    private String[] specificValues;
    private String packageName;
    private boolean arrayOnly;
    private boolean isComplex = false;
    private boolean isValueless = false;
    private boolean isAnnotationField = false;
    private EGLEnumeration enumeration;
    private int specialRules = 0;
    private AnnotationType elementAnnotationType;
    public static int DONT_VALIDATE_IN_OPENUI_STATEMENT = 2;
    public static int IS_DLI_NAME = 4;

    public EGLPropertyRule(String name, String description, int[] types, String[] specificValues, boolean arrayOnly) {
        this.name = name;
        this.description = description;
        this.types = types;
        this.specificValues = specificValues;
        this.arrayOnly = arrayOnly;
    }

    public EGLPropertyRule(String name, int[] types, String[] specificValues, boolean arrayOnly) {
        this(name, "", types, specificValues, arrayOnly);
    }

    public EGLPropertyRule(String name, String description, int[] types, String[] specificValues) {
        this(name, description, types, specificValues, false);
    }

    public EGLPropertyRule(String name, int[] types, String[] specificValues) {
        this(name, types, specificValues, false);
    }

    public EGLPropertyRule(String name, String description, int[] types) {
        this(name, types);
        this.description = description;
    }

    public EGLPropertyRule(String name, int[] types) {
        this(name, types, null, false);
    }

    public EGLPropertyRule(String name, int[] types, int[] elementTypes, EGLPropertyRule[] elementAnnotationTypes) {
        this(name, types, null, true);
        this.elementTypes = elementTypes;
        this.elementAnnotationTypes = elementAnnotationTypes;
    }

    public EGLPropertyRule(String name, EGLPropertyRule[] elementAnnotationTypes) {
        this.name = name;
        this.elementAnnotationTypes = elementAnnotationTypes;
        this.isComplex = true;
    }

    public EGLPropertyRule(AnnotationType annType) {
    }

    private EField getEField(AnnotationType annType, String name) {
        for (EField f : annType.getEFields()) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public EGLPropertyRule(AnnotationType annType, String fieldName) {
    }

    public EGLPropertyRule(Field field) {
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String[] getSpecificValues() {
        return this.specificValues;
    }

    public int[] getTypes() {
        return this.types;
    }

    public boolean hasType(int type) {
        if (this.getTypes() != null) {
            int i = 0;
            while (i < this.getTypes().length) {
                if (this.getTypes()[i] == type) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int[] getElementTypes() {
        return this.elementTypes;
    }

    public boolean hasElementType(int type) {
        if (this.getElementTypes() != null) {
            int i = 0;
            while (i < this.getElementTypes().length) {
                if (this.getElementTypes()[i] == type) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public EGLPropertyRule[] getElementAnnotationTypes() {
        return this.elementAnnotationTypes;
    }

    public AnnotationType getElementAnnotationType() {
        return this.elementAnnotationType;
    }

    public boolean isSQLItemPropertyRule() {
        return false;
    }

    public boolean isPageItemPropertyRule() {
        return false;
    }

    public boolean isFormattingPropertyRule() {
        return false;
    }

    public boolean isValidationPropertyRule() {
        return false;
    }

    public boolean isFieldPresentationPropertyRule() {
        return false;
    }

    public boolean isArrayOnly() {
        return this.arrayOnly;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public boolean isValueless() {
        return this.isValueless;
    }

    public boolean isCombo() {
        return this.name.equals("currency") || this.name.equals("fillCharacter") || this.name.equals("keyItem") || this.name.equals("lengthItem");
    }

    public boolean isRecordPropertyRule() {
        return false;
    }

    public boolean equals(Object arg0) {
        return this.getName().equals(((EGLPropertyRule)arg0).getName());
    }

    public int compareTo(Object arg0) {
        return this.getName().toLowerCase().compareTo(((EGLPropertyRule)arg0).getName().toLowerCase());
    }

    public void setEnumeration(EGLEnumeration enumer) {
        this.enumeration = enumer;
    }

    public EGLEnumeration getEnumeration() {
        return this.enumeration;
    }

    public boolean isEnumerationProperty() {
        return this.enumeration != null;
    }

    public void setSpecialRules(int newRules) {
        this.specialRules = newRules;
    }

    public boolean shouldValidateInOpenUIStatement() {
        return (this.specialRules & DONT_VALIDATE_IN_OPENUI_STATEMENT) == 0;
    }

    public boolean isDLIName() {
        return (this.specialRules & IS_DLI_NAME) != 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isAnnotationField() {
        return this.isAnnotationField;
    }

    public void setAnnotationField(boolean isAnnotationField) {
        this.isAnnotationField = isAnnotationField;
    }
}

