/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.builder;

import java.util.List;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.CircularBuildRequestException;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationTypeBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ClassBinder;
import org.eclipse.edt.compiler.internal.core.lookup.DelegateBinder;
import org.eclipse.edt.compiler.internal.core.lookup.EnumerationBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ExternalTypeBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FileBinder;
import org.eclipse.edt.compiler.internal.core.lookup.HandlerBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.InterfaceBinder;
import org.eclipse.edt.compiler.internal.core.lookup.LibraryBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ProgramBinder;
import org.eclipse.edt.compiler.internal.core.lookup.RecordBinder;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.ServiceBinder;
import org.eclipse.edt.compiler.internal.core.lookup.StereotypeTypeBinder;

public abstract class Compiler
extends DefaultASTVisitor {
    public synchronized void compilePart(Node astNode, IPartBinding partBinding, Scope parentScope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        switch (partBinding.getKind()) {
            case 16: {
                try {
                    astNode.accept(new FileBinder((FileBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    if (!partBinding.isValid()) {
                        throw e;
                    }
                    problemRequestor.acceptProblem(0, 0, 2, 3000, new String[]{partBinding.getName()});
                    this.logPartBinderException(e);
                    break;
                }
            }
            case 13: {
                try {
                    astNode.accept(new ProgramBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 27: {
                try {
                    astNode.accept(new DelegateBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 28: {
                try {
                    astNode.accept(new ExternalTypeBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 19: {
                try {
                    astNode.accept(new EnumerationBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 10: {
                try {
                    astNode.accept(new HandlerBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 30: {
                try {
                    astNode.accept(new ClassBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 15: {
                try {
                    astNode.accept(new InterfaceBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 11: {
                try {
                    astNode.accept(new LibraryBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 7: {
                try {
                    astNode.accept(new RecordBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 14: {
                try {
                    astNode.accept(new ServiceBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    this.validatePart(astNode, partBinding, problemRequestor, compilerOptions);
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 18: {
                try {
                    astNode.accept(new AnnotationTypeBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                    break;
                }
            }
            case 31: {
                try {
                    astNode.accept(new StereotypeTypeBinder((IRPartBinding)partBinding, parentScope, dependencyRequestor, problemRequestor, compilerOptions));
                    break;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (CircularBuildRequestException e) {
                    throw e;
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleBinderException((Part)astNode, partBinding, problemRequestor, e);
                }
            }
        }
    }

    private void validatePart(Node astNode, IPartBinding partBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        try {
            List<ASTValidator> validators = partBinding.getEnvironment().getCompiler().getValidatorsFor(astNode);
            if (validators != null && validators.size() > 0) {
                for (ASTValidator validator : validators) {
                    validator.validate(astNode, (IRPartBinding)partBinding, problemRequestor, compilerOptions);
                }
            }
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (CircularBuildRequestException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.handleValidationException((Part)astNode, problemRequestor, e);
        }
    }

    protected abstract void logPartBinderException(RuntimeException var1);

    protected abstract void logValidationException(RuntimeException var1);

    private void handleValidationException(Part astNode, IProblemRequestor problemRequestor, RuntimeException e) {
        problemRequestor.acceptProblem((Node)astNode.getName(), 3000, new String[]{astNode.getName().getCanonicalName()});
        this.logValidationException(e);
    }

    private void handleBinderException(Part astNode, IPartBinding partBinding, IProblemRequestor problemRequestor, RuntimeException e) {
        if (!partBinding.isValid()) {
            throw e;
        }
        problemRequestor.acceptProblem((Node)astNode.getName(), 3000, new String[]{astNode.getName().getCanonicalName()});
        this.logPartBinderException(e);
    }
}

