/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ILocalVariableScope;
import org.eclipse.edt.compiler.internal.core.lookup.MemberScope;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.StatementBlockScope;
import org.eclipse.edt.compiler.internal.core.lookup.TypeScope;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;

public class FunctionBinder
extends DefaultBinder {
    private FunctionMember functionBinding;
    private Part partBinding;
    private List<FunctionDataDeclaration> functionDataDecls = new ArrayList<FunctionDataDeclaration>();
    private String canonicalFunctionName;

    public FunctionBinder(Part partBinding, FunctionMember functionBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(scope, partBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.partBinding = partBinding;
        this.functionBinding = functionBinding;
    }

    @Override
    public boolean visit(NestedFunction function) {
        this.canonicalFunctionName = function.getName().getCanonicalName();
        FunctionScope functionScope = new FunctionScope((FunctionContainerScope)this.currentScope, this.functionBinding);
        this.currentScope = functionScope;
        for (FunctionParameter parm : this.functionBinding.getParameters()) {
            functionScope.addDeclaredDataName(parm.getName());
        }
        return true;
    }

    @Override
    public boolean visit(Constructor constructor) {
        this.canonicalFunctionName = "constructor";
        FunctionScope functionScope = new FunctionScope((FunctionContainerScope)this.currentScope, this.functionBinding);
        this.currentScope = functionScope;
        for (FunctionParameter parm : this.functionBinding.getParameters()) {
            functionScope.addDeclaredDataName(parm.getName());
        }
        return true;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration dataDecl) {
        this.functionDataDecls.add(dataDecl);
        this.processDataDeclaration(dataDecl.getNames(), dataDecl.getType(), dataDecl.isNullable(), dataDecl.getSettingsBlockOpt(), dataDecl.isConstant(), dataDecl.getInitializer());
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void processDataDeclaration(List<Name> names, Type type, boolean isNullable, SettingsBlock settingsBlock, boolean isConstantDeclaration, Expression initializer) {
        block7: {
            typeBinding = null;
            try {
                typeBinding = this.bindType(type);
                break block7;
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                if (settingsBlock != null) {
                    AbstractBinder.setBindAttemptedForNames(settingsBlock);
                }
                ** for (name : names)
            }
lbl-1000:
            // 1 sources

            {
                name.setBindAttempted(true);
                continue;
            }
lbl12:
            // 1 sources

            return;
        }
        for (Name name : names) {
            dataName = name.getIdentifier();
            field /* !! */  = isConstantDeclaration != false ? IrFactory.INSTANCE.createConstantField() : IrFactory.INSTANCE.createField();
            field /* !! */ .setContainer((Container)this.functionBinding);
            field /* !! */ .setType(typeBinding);
            field /* !! */ .setIsNullable(isNullable);
            field /* !! */ .setName(name.getCaseSensitiveIdentifier());
            if (((ILocalVariableScope)this.currentScope).hasDeclaredDataName(dataName)) {
                this.problemRequestor.acceptProblem((Node)name, 3012, new String[]{name.getCanonicalName(), this.canonicalFunctionName});
            } else {
                ((ILocalVariableScope)this.currentScope).addLocalVariable((Member)field /* !! */ );
                ((ILocalVariableScope)this.currentScope).addDeclaredDataName(dataName);
            }
            name.setMember((Member)field /* !! */ );
            name.setType(typeBinding);
            if (settingsBlock == null) continue;
            scope = new MemberScope(NullScope.INSTANCE, (Member)field /* !! */ );
            annotationScope = new AnnotationLeftHandScope(scope, (Element)field /* !! */ , typeBinding, (Element)field /* !! */ );
            settingsBlock.accept(new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.partBinding, annotationScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        }
    }

    @Override
    public void endVisit(NestedFunction nestedFunction) {
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        setValuesExpression.getExpression().accept(this);
        org.eclipse.edt.mof.egl.Type type = setValuesExpression.getExpression().resolveType();
        if (type != null) {
            TypeScope newScope = new TypeScope(NullScope.INSTANCE, type);
            setValuesExpression.getSettingsBlock().accept(new DefaultBinder.SetValuesExpressionCompletor(this.currentScope, (Part)this.functionBinding.getContainer(), newScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        } else if (setValuesExpression.getExpression().resolveElement() != null) {
            setValuesExpression.getSettingsBlock().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        this.bindInvocationTarget(callStatement.getInvocationTarget());
        if (callStatement.hasArguments()) {
            for (Node node : callStatement.getArguments()) {
                node.accept(this);
            }
        }
        if (callStatement.hasSettingsBlock()) {
            callStatement.getSettingsBlock().accept(this);
        }
        if (callStatement.getUsing() != null) {
            callStatement.getUsing().accept(this);
        }
        if (callStatement.getCallSynchronizationValues() != null) {
            if (callStatement.getCallSynchronizationValues().getReturns() != null) {
                callStatement.getCallSynchronizationValues().getReturns().accept(this);
            }
            if (callStatement.getCallSynchronizationValues().getReturnTo() != null) {
                callStatement.getCallSynchronizationValues().getReturnTo().accept(this);
            }
            if (callStatement.getCallSynchronizationValues().getOnException() != null) {
                callStatement.getCallSynchronizationValues().getOnException().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ExitStatement exitStatement) {
        if (exitStatement.getExitModifierOpt() != null) {
            exitStatement.getExitModifierOpt().accept(this);
        }
        if (exitStatement.hasSettingsBlock()) {
            exitStatement.getSettingsBlock().accept(this);
        }
        return false;
    }

    private void visitStatementBlocks(Statement statement) {
        for (List<Node> block : statement.getStatementBlocks()) {
            this.currentScope = new StatementBlockScope(this.currentScope);
            for (Node node : block) {
                node.accept(this);
            }
            this.currentScope = this.currentScope.getParentScope();
        }
    }

    @Override
    public boolean visit(IfStatement ifStatement) {
        ifStatement.getCondition().accept(this);
        this.visitStatementBlocks(ifStatement);
        return false;
    }

    @Override
    public boolean visit(CaseStatement caseStatement) {
        if (caseStatement.hasCriterion()) {
            Expression expr = caseStatement.getCriterion();
            expr.accept(this);
        }
        for (WhenClause whenClause : caseStatement.getWhenClauses()) {
            for (Expression expr : whenClause.getExpr_plus()) {
                expr.accept(this);
            }
        }
        this.visitStatementBlocks(caseStatement);
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        this.currentScope = new StatementBlockScope(this.currentScope);
        if (forStatement.hasVariableDeclaration()) {
            this.processDataDeclaration(Arrays.asList(forStatement.getVariableDeclarationName()), forStatement.getVariableDeclarationType(), forStatement.isNullable(), null, false, null);
        } else {
            forStatement.getCounterVariable().accept(this);
        }
        if (forStatement.hasFromIndex()) {
            forStatement.getFromIndex().accept(this);
        }
        forStatement.getEndIndex().accept(this);
        if (forStatement.hasPositiveDelta() || forStatement.hasNegativeDelta()) {
            forStatement.getDeltaExpression().accept(this);
        }
        for (Node node : forStatement.getStmts()) {
            node.accept(this);
        }
        this.currentScope = this.currentScope.getParentScope();
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        this.currentScope = new StatementBlockScope(this.currentScope);
        if (forEachStatement.hasVariableDeclaration()) {
            this.processDataDeclaration(Arrays.asList(forEachStatement.getVariableDeclarationName()), forEachStatement.getVariableDeclarationType(), forEachStatement.isNullable(), null, false, null);
        } else {
            for (Node n : forEachStatement.getTargets()) {
                n.accept(this);
            }
        }
        forEachStatement.getResultSet().getExpression().accept(this);
        for (Node node : forEachStatement.getStmts()) {
            node.accept(this);
        }
        this.currentScope = this.currentScope.getParentScope();
        return false;
    }

    @Override
    public boolean visit(WhileStatement whileStatement) {
        whileStatement.getExpr().accept(this);
        this.visitStatementBlocks(whileStatement);
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        this.currentScope = new StatementBlockScope(this.currentScope);
        for (Node node : tryStatement.getStmts()) {
            node.accept(this);
        }
        this.currentScope = this.currentScope.getParentScope();
        for (Node node : tryStatement.getOnExceptionBlocks()) {
            node.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OnExceptionBlock onExceptionBlock) {
        this.currentScope = new StatementBlockScope(this.currentScope);
        this.processDataDeclaration(Arrays.asList(onExceptionBlock.getExceptionName()), onExceptionBlock.getExceptionType(), onExceptionBlock.isNullable(), null, false, null);
        for (Node node : onExceptionBlock.getStmts()) {
            node.accept(this);
        }
        this.currentScope = this.currentScope.getParentScope();
        return false;
    }
}

