/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.internal.core.lookup.ILocalVariableScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class FunctionScope
extends Scope
implements ILocalVariableScope {
    private Map<String, Member> localVariables = new HashMap<String, Member>();
    protected Set<String> declaredDataNames = new HashSet<String>();

    public FunctionScope(Scope parentScope, FunctionMember functionBinding) {
        this(parentScope);
        List functionParameters = functionBinding.getParameters();
        for (FunctionParameter parm : functionParameters) {
            this.localVariables.put(parm.getName(), (Member)parm);
        }
    }

    protected FunctionScope(Scope parentScope) {
        super(parentScope);
    }

    @Override
    public List<Member> findMember(String simpleName) {
        Member result = this.localVariables.get(simpleName);
        if (result != null) {
            ArrayList<Member> list = new ArrayList<Member>();
            list.add(result);
            return list;
        }
        return this.parentScope.findMember(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public List<Type> findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }

    @Override
    public void addLocalVariable(Member var) {
        this.localVariables.put(var.getName(), var);
    }

    @Override
    public Scope getScopeForKeywordThis() {
        return this.parentScope.getScopeForKeywordThis();
    }

    @Override
    public Part getPart() {
        return this.parentScope.getPart();
    }

    @Override
    public void addDeclaredDataName(String name) {
        this.declaredDataNames.add(name);
    }

    @Override
    public boolean hasDeclaredDataName(String name) {
        return this.declaredDataNames.contains(name);
    }
}

