/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.validation.AbstractTypeValidator;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.IntervalType;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.TimestampType;

public class DefaultTypeValidator
extends AbstractTypeValidator {
    @Override
    public boolean visit(NameType nameType) {
        this.validateType(nameType);
        return false;
    }

    protected void validateType(Type type) {
        block11: {
            org.eclipse.edt.mof.egl.Type typeBinding;
            block13: {
                DateTimePattern dtPat;
                List<Expression> args;
                block12: {
                    block9: {
                        int decimals;
                        int len;
                        block10: {
                            typeBinding = type.resolveType();
                            if (!(typeBinding instanceof FixedPrecisionType)) break block9;
                            len = ((FixedPrecisionType)typeBinding).getLength();
                            decimals = ((FixedPrecisionType)typeBinding).getDecimals();
                            if (len < 0 || len > 32) {
                                this.problemRequestor.acceptProblem((Node)type, 4401, new String[]{Integer.toString(len), typeBinding.getClassifier().getTypeSignature(), "(1..32)"});
                            }
                            if (decimals >= 0 && decimals <= 32) break block10;
                            this.problemRequestor.acceptProblem((Node)type, 4402, new String[]{Integer.toString(decimals), typeBinding.getClassifier().getTypeSignature(), "(1..32)"});
                            break block11;
                        }
                        if (decimals <= len) break block11;
                        this.problemRequestor.acceptProblem((Node)type, 4403, new String[]{Integer.toString(decimals), typeBinding.getClassifier().getTypeSignature(), Integer.toString(len)});
                        break block11;
                    }
                    if (!(typeBinding instanceof SequenceType)) break block12;
                    int len = ((SequenceType)typeBinding).getLength();
                    if (len >= 0) break block11;
                    this.problemRequestor.acceptProblem((Node)type, 4412, new String[]{Integer.toString(len), typeBinding.getClassifier().getTypeSignature()});
                    break block11;
                }
                if (!(typeBinding instanceof TimestampType)) break block13;
                String pattern = null;
                if (type instanceof NameType && (args = ((NameType)type).getArguments()).size() > 0 && args.get(0) instanceof LiteralExpression) {
                    pattern = ((LiteralExpression)args.get(0)).getValue();
                }
                if (pattern == null) {
                    pattern = ((TimestampType)typeBinding).getPattern();
                }
                if ((dtPat = new DateTimePattern(pattern)).isValidTimeStampPattern()) break block11;
                Integer[] errors = dtPat.getErrorMessageNumbers();
                int i = 0;
                while (i < errors.length) {
                    this.problemRequestor.acceptProblem((Node)type, (int)errors[i], new String[]{pattern});
                    ++i;
                }
                break block11;
            }
            if (typeBinding instanceof IntervalType) {
                DateTimePattern dtPat;
                List<Expression> args;
                String pattern = null;
                if (type instanceof NameType && (args = ((NameType)type).getArguments()).size() > 0 && args.get(0) instanceof LiteralExpression) {
                    pattern = ((LiteralExpression)args.get(0)).getValue();
                }
                if (pattern == null) {
                    pattern = ((IntervalType)typeBinding).getPattern();
                }
                if (!(dtPat = new DateTimePattern(pattern)).isValidIntervalPattern()) {
                    Integer[] errors = dtPat.getErrorMessageNumbers();
                    int i = 0;
                    while (i < errors.length) {
                        this.problemRequestor.acceptProblem((Node)type, (int)errors[i], new String[]{pattern});
                        ++i;
                    }
                }
            }
        }
    }

    public static boolean isApplicableFor(Type type) {
        org.eclipse.edt.mof.egl.Type typeBinding = type.resolveType();
        if (typeBinding instanceof ParameterizedType) {
            return typeBinding instanceof FixedPrecisionType || typeBinding instanceof SequenceType || typeBinding instanceof TimestampType || typeBinding instanceof IntervalType;
        }
        return false;
    }

    public static class DateTimePattern {
        private String[] components;
        private boolean isValidPattern = true;
        private Set<Integer> errorMessageNumbers = new TreeSet<Integer>();
        private String text;
        static final List<Character> VALID_CHARS = new ArrayList<Character>(Arrays.asList(Character.valueOf('y'), Character.valueOf('M'), Character.valueOf('d'), Character.valueOf('H'), Character.valueOf('m'), Character.valueOf('s'), Character.valueOf('f')));
        private static Map<Character, Integer> maxOccurences = new HashMap<Character, Integer>();

        static {
            maxOccurences.put(Character.valueOf('y'), 4);
            maxOccurences.put(Character.valueOf('M'), 2);
            maxOccurences.put(Character.valueOf('d'), 2);
            maxOccurences.put(Character.valueOf('H'), 2);
            maxOccurences.put(Character.valueOf('m'), 2);
            maxOccurences.put(Character.valueOf('s'), 2);
            maxOccurences.put(Character.valueOf('f'), 6);
        }

        public DateTimePattern(String atext) {
            this.text = atext;
            if (this.text.startsWith("\"") && this.text.endsWith("\"")) {
                this.text = atext.substring(1, atext.length() - 1);
            }
            if (this.text.length() == 0) {
                this.isValidPattern = false;
                this.errorMessageNumbers.add(7635);
                return;
            }
            StringBuffer component = new StringBuffer();
            ArrayList<String> componentsList = new ArrayList<String>();
            char currentChar = this.text.charAt(0);
            int i = 0;
            while (i < this.text.length() && this.isValidPattern) {
                char ch = this.text.charAt(i);
                if (!VALID_CHARS.contains(Character.valueOf(ch))) {
                    this.isValidPattern = false;
                    this.errorMessageNumbers.add(7625);
                } else {
                    if (currentChar != ch) {
                        componentsList.add(component.toString());
                        component = new StringBuffer();
                        currentChar = ch;
                    }
                    component.append(ch);
                }
                ++i;
            }
            if (component.toString().length() != 0) {
                componentsList.add(component.toString());
            }
            this.components = componentsList.toArray(new String[0]);
        }

        private void checkOrder() {
            char currentChar = this.components[0].charAt(0);
            int currentIndex = VALID_CHARS.indexOf(Character.valueOf(currentChar));
            int i = 1;
            while (i < this.components.length && this.isValidPattern) {
                char nextChar = this.components[i].charAt(0);
                int nextIndex = VALID_CHARS.indexOf(Character.valueOf(nextChar));
                if (nextChar != currentChar && nextChar != VALID_CHARS.get(currentIndex + 1).charValue()) {
                    this.isValidPattern = false;
                    this.errorMessageNumbers.add(nextIndex < currentIndex ? 7626 : 7634);
                }
                currentChar = nextChar;
                currentIndex = nextIndex;
                ++i;
            }
        }

        private void checkOccurences(int firstFieldAllowedLength) {
            int[] occurenceMessages = new int[]{7627, 7628, 7629, 7630, 7631, 7632, 7633};
            int i = 0;
            while (i < this.components.length) {
                char currentChar = this.components[i].charAt(0);
                boolean isValid = false;
                if (i == 0 && firstFieldAllowedLength != -1) {
                    isValid = this.components[i].length() <= firstFieldAllowedLength;
                } else {
                    boolean bl = isValid = this.components[i].length() <= maxOccurences.get(Character.valueOf(currentChar));
                }
                if (!isValid) {
                    this.isValidPattern = false;
                    if (i == 0 && firstFieldAllowedLength != -1) {
                        this.errorMessageNumbers.add(7624);
                    } else {
                        this.errorMessageNumbers.add(occurenceMessages[VALID_CHARS.indexOf(Character.valueOf(currentChar))]);
                    }
                }
                ++i;
            }
        }

        private void checkIntervalSpan() {
            boolean spanValid = true;
            char firstChar = this.components[0].charAt(0);
            char lastChar = this.components[this.components.length - 1].charAt(0);
            if (firstChar == 'y') {
                spanValid = lastChar == 'M' ? this.components.length == 2 : lastChar == 'y';
            } else if (firstChar == 'M') {
                boolean bl = spanValid = this.components.length == 1;
            }
            if (!spanValid) {
                this.isValidPattern = false;
                this.errorMessageNumbers.add(7636);
            }
        }

        public boolean isValidTimeStampPattern() {
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOrder();
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOccurences(-1);
            return this.isValidPattern;
        }

        public boolean isValidIntervalPattern() {
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOrder();
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOccurences(9);
            if (!this.isValidPattern) {
                return false;
            }
            this.checkIntervalSpan();
            return this.isValidPattern;
        }

        public Integer[] getErrorMessageNumbers() {
            return this.errorMessageNumbers.toArray(new Integer[this.errorMessageNumbers.size()]);
        }
    }
}

