/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.ASTValidator;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.ClassDataDeclarationValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.UseStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;

public abstract class FunctionContainerValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    protected IPartBinding partBinding;
    protected Part partNode;
    protected ICompilerOptions compilerOptions;

    public FunctionContainerValidator(IProblemRequestor problemRequestor, IPartBinding partBinding, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.partBinding = partBinding;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        classDataDeclaration.accept(new ClassDataDeclarationValidator(this.problemRequestor, this.compilerOptions, this.partBinding));
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        List<ASTValidator> validators = this.partBinding.getEnvironment().getCompiler().getValidatorsFor(nestedFunction);
        if (validators != null && validators.size() > 0) {
            for (ASTValidator validator : validators) {
                validator.validate(nestedFunction, (IRPartBinding)this.partBinding, this.problemRequestor, this.compilerOptions);
            }
        }
        if (nestedFunction.isStatic()) {
            nestedFunction.accept(new StaticReferenceChecker(this.problemRequestor));
        }
        return false;
    }

    @Override
    public boolean visit(Constructor constructor) {
        List<ASTValidator> validators = this.partBinding.getEnvironment().getCompiler().getValidatorsFor(constructor);
        if (validators != null && validators.size() > 0) {
            for (ASTValidator validator : validators) {
                validator.validate(constructor, (IRPartBinding)this.partBinding, this.problemRequestor, this.compilerOptions);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        useStatement.accept(new UseStatementValidator(this.partBinding, this.partNode.getName().getCanonicalName(), this.problemRequestor, this.compilerOptions));
        return false;
    }

    protected void checkImplements(List<Name> implementedInterfaces) {
        if (implementedInterfaces == null || implementedInterfaces.size() == 0) {
            return;
        }
        for (Name name : implementedInterfaces) {
            Type type = name.resolveType();
            if (type == null || type instanceof Interface) continue;
            this.problemRequestor.acceptProblem(name, 7801);
        }
    }

    protected void checkInterfaceFunctionsOverriden(StructPart binding) {
        if (!BindingUtil.isAbstract((Type)binding)) {
            List<Function> declaredAndInheritedFunctions = null;
            for (Function interfaceFunc : this.getInterfaceFunctionList(binding)) {
                boolean foundMatchingFunc = false;
                if (declaredAndInheritedFunctions == null) {
                    declaredAndInheritedFunctions = this.getDeclaredAndInheritedFunctionList(binding);
                }
                for (Function func : declaredAndInheritedFunctions) {
                    if (!BindingUtil.functionSignituresAreIdentical(func, interfaceFunc)) continue;
                    foundMatchingFunc = true;
                    break;
                }
                if (foundMatchingFunc) continue;
                this.problemRequestor.acceptProblem((Node)this.partNode.getName(), 3400, new String[]{this.partNode.getName().getCanonicalName(), String.valueOf(interfaceFunc.getCaseSensitiveName()) + "(" + FunctionContainerValidator.getTypeNamesList(interfaceFunc.getParameters()) + ")", ((Interface)interfaceFunc.getContainer()).getCaseSensitiveName()});
            }
        }
    }

    protected void checkAbstractFunctionsOverriden(StructPart binding) {
        if (!BindingUtil.isAbstract((Type)binding)) {
            List<Function> declaredAndInheritedFunctions = null;
            for (Function abstractFunc : this.getAbstractFunctionList(binding)) {
                boolean foundMatchingFunc = false;
                if (declaredAndInheritedFunctions == null) {
                    declaredAndInheritedFunctions = this.getDeclaredAndInheritedFunctionList(binding);
                }
                for (Function func : declaredAndInheritedFunctions) {
                    if (!BindingUtil.functionSignituresAreIdentical(func, abstractFunc)) continue;
                    foundMatchingFunc = true;
                    break;
                }
                if (foundMatchingFunc) continue;
                this.problemRequestor.acceptProblem((Node)this.partNode.getName(), 3401, new String[]{this.partNode.getName().getCanonicalName(), String.valueOf(abstractFunc.getCaseSensitiveName()) + "(" + FunctionContainerValidator.getTypeNamesList(abstractFunc.getParameters()) + ")", ((org.eclipse.edt.mof.egl.Part)abstractFunc.getContainer()).getCaseSensitiveName()});
            }
        }
    }

    private List<Function> getDeclaredAndInheritedFunctionList(StructPart binding) {
        ArrayList<Function> retVal = new ArrayList<Function>();
        this.getInheritedFunctions(binding, retVal, new HashSet<StructPart>());
        return retVal;
    }

    private void getInheritedFunctions(StructPart part, List<Function> funcs, Set<StructPart> seenParts) {
        if (seenParts.contains(part)) {
            return;
        }
        seenParts.add(part);
        for (Function function : part.getFunctions()) {
            if (function.isAbstract().booleanValue() || function.getAccessKind() == AccessKind.ACC_PRIVATE) continue;
            funcs.add(function);
        }
        for (StructPart superPart : part.getSuperTypes()) {
            if (superPart instanceof Interface) continue;
            this.getInheritedFunctions(superPart, funcs, seenParts);
        }
    }

    private List<Function> getInterfaceFunctionList(StructPart binding) {
        ArrayList<Function> retVal = new ArrayList<Function>();
        HashSet<Interface> seen = new HashSet<Interface>();
        for (Interface iface : binding.getInterfaces()) {
            this.getInterfaceFunctions(iface, retVal, seen);
        }
        return retVal;
    }

    private void getInterfaceFunctions(Interface iface, List<Function> funcs, Set<Interface> seenInterfaces) {
        if (seenInterfaces.contains(iface)) {
            return;
        }
        seenInterfaces.add(iface);
        for (Function function : iface.getFunctions()) {
            if (function.getAccessKind() == AccessKind.ACC_PRIVATE) continue;
            funcs.add(function);
        }
        for (Interface iface2 : iface.getInterfaces()) {
            this.getInterfaceFunctions(iface2, funcs, seenInterfaces);
        }
    }

    private List<Function> getAbstractFunctionList(StructPart binding) {
        ArrayList<Function> retVal = new ArrayList<Function>();
        HashSet<StructPart> seen = new HashSet<StructPart>();
        for (StructPart superType : binding.getSuperTypes()) {
            if (superType instanceof Interface) continue;
            this.getAbstractFunctions(superType, retVal, seen);
        }
        return retVal;
    }

    private void getAbstractFunctions(StructPart structPart, List<Function> funcs, Set<StructPart> seenParts) {
        if (seenParts.contains(structPart)) {
            return;
        }
        seenParts.add(structPart);
        for (Function function : structPart.getFunctions()) {
            if (!function.isAbstract().booleanValue()) continue;
            funcs.add(function);
        }
        for (StructPart superType : structPart.getSuperTypes()) {
            this.getAbstractFunctions(superType, funcs, seenParts);
        }
    }

    public static String getTypeNamesList(List<FunctionParameter> types) {
        StringBuffer sb = new StringBuffer();
        if (!types.isEmpty()) {
            sb.append(" ");
        }
        Iterator<FunctionParameter> iter = types.iterator();
        while (iter.hasNext()) {
            FunctionParameter nextParm = iter.next();
            Type nextType = nextParm.getType();
            if (nextType == null) continue;
            sb.append(BindingUtil.getTypeName((Member)nextParm, nextType));
            switch (nextParm.getParameterKind()) {
                case PARM_IN: {
                    sb.append(" in");
                    break;
                }
                case PARM_OUT: {
                    sb.append(" out");
                    break;
                }
                case PARM_INOUT: {
                    sb.append(" inOut");
                }
            }
            if (iter.hasNext()) {
                sb.append(", ");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    protected void checkImplicitConstructor(Part part) {
        class FoundContructor
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            FoundContructor() {
            }
        }
        List superTypes;
        try {
            part.accept(new AbstractASTVisitor(){

                @Override
                public boolean visit(Constructor constructor) {
                    throw new FoundContructor();
                }

                @Override
                public boolean visit(NestedFunction nestedFunction) {
                    return false;
                }

                @Override
                public boolean visit(ClassDataDeclaration classDataDeclaration) {
                    return false;
                }
            });
        }
        catch (FoundContructor foundContructor) {
            return;
        }
        Type type = part.getName().resolveType();
        if (type instanceof StructPart && (superTypes = ((StructPart)type).getSuperTypes()) != null && superTypes.size() > 0 && !TypeValidator.hasPublicDefaultConstructor((Type)superTypes.get(0))) {
            this.problemRequestor.acceptProblem((Node)part.getName(), 6759, new String[]{String.valueOf(BindingUtil.getShortTypeString((Type)superTypes.get(0), false)) + "()"});
        }
    }

    public static class StaticReferenceChecker
    extends AbstractASTVisitor {
        IProblemRequestor problemRequestor;

        public StaticReferenceChecker(IProblemRequestor problemRequestor) {
            this.problemRequestor = problemRequestor;
        }

        @Override
        public boolean visit(SimpleName simpleName) {
            this.checkStatic(simpleName, simpleName);
            return false;
        }

        @Override
        public boolean visit(QualifiedName qualifiedName) {
            this.checkStatic(qualifiedName, qualifiedName);
            return false;
        }

        private void checkStatic(Node errorNode, Name name) {
            Object element = name.resolveElement();
            if (element instanceof Member && !((Member)element).isStatic().booleanValue() && !(((Member)element).getContainer() instanceof FunctionMember)) {
                if (name.isSimpleName()) {
                    if (element instanceof FunctionMember) {
                        this.problemRequestor.acceptProblem(errorNode, 3406, new String[]{String.valueOf(name.getCaseSensitiveIdentifier()) + "(" + FunctionContainerValidator.getTypeNamesList(((FunctionMember)element).getParameters()) + ")"});
                    } else {
                        this.problemRequestor.acceptProblem(errorNode, 3405, new String[]{name.getCaseSensitiveIdentifier()});
                    }
                } else {
                    this.checkStatic(errorNode, ((QualifiedName)name).getQualifier());
                }
            }
        }
    }
}

