/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ThrowStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ThrowStatementValidator
extends DefaultASTVisitor {
    public static final String AnyExceptionMofKey = "egl:eglx.lang.AnyException";
    private IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;

    public ThrowStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement) {
        Type type;
        if (this.enclosingPart != null && (type = throwStatement.getExpression().resolveType()) != null && !ThrowStatementValidator.isAnyException(type)) {
            this.problemRequestor.acceptProblem((Node)throwStatement.getExpression(), 3444, new String[]{BindingUtil.getShortTypeString(type)});
        }
        return false;
    }

    public static boolean isAnyException(Type type) {
        return TypeUtils.isTypeOrSubtypeOf((Type)type, (String)AnyExceptionMofKey);
    }
}

