/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.BytesLiteral;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.ObjectExpression;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofStatement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.ArrayLiteral;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.BooleanLiteral;
import org.eclipse.edt.mof.egl.ConstructorInvocation;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DecimalLiteral;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.DelegateInvocation;
import org.eclipse.edt.mof.egl.DynamicAccess;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FloatingPointLiteral;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.IsAExpression;
import org.eclipse.edt.mof.egl.IsNotExpression;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.NumericLiteral;
import org.eclipse.edt.mof.egl.ObjectExpressionEntry;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartName;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.StringLiteral;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.SubstringAccess;
import org.eclipse.edt.mof.egl.SuperExpression;
import org.eclipse.edt.mof.egl.TernaryExpression;
import org.eclipse.edt.mof.egl.ThisExpression;
import org.eclipse.edt.mof.egl.UnaryExpression;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;

abstract class Egl2MofExpression
extends Egl2MofStatement {
    private Stack<org.eclipse.edt.mof.egl.Expression> sveStack = new Stack();
    private Stack<org.eclipse.edt.mof.egl.Type> sveTypeStack = new Stack();
    private Stack<LHSExpr> localStack = new Stack();

    Egl2MofExpression(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.AsExpression expr) {
        AsExpression asExpr = this.factory.createAsExpression();
        this.stack.push(asExpr);
        this.setElementInformation((Node)expr, (EObject)asExpr);
        expr.getExpression().accept(this);
        asExpr.setObjectExpr((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        org.eclipse.edt.mof.egl.Type eType = (org.eclipse.edt.mof.egl.Type)this.mofTypeFor(expr.resolveType());
        asExpr.setEType(eType);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ArrayAccess node) {
        node.getArray().accept(this);
        org.eclipse.edt.mof.egl.Expression arrayExpression = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
        ArrayAccess lastAC = null;
        int i = 0;
        while (i < node.getIndices().size()) {
            Expression indexExpr = node.getIndices().get(i);
            indexExpr.accept(this);
            org.eclipse.edt.mof.egl.Expression index = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
            org.eclipse.edt.mof.egl.Type exprType = indexExpr.resolveType();
            if (exprType == null) {
                ArrayAccess ax = this.factory.createArrayAccess();
                ax.setIndex(index);
                ax.setArray(arrayExpression);
                lastAC = ax;
            } else {
                DynamicAccess ax;
                boolean isDynamicAccess = TypeUtils.isTextType((org.eclipse.edt.mof.egl.Type)((org.eclipse.edt.mof.egl.Type)this.mofTypeFor(exprType)));
                if (isDynamicAccess) {
                    ax = this.factory.createDynamicAccess();
                    ax.setAccess(index);
                    ax.setExpression(arrayExpression);
                    lastAC = ax;
                } else {
                    ax = this.factory.createArrayAccess();
                    ax.setIndex((org.eclipse.edt.mof.egl.Expression)IRUtils.createAsExpression((org.eclipse.edt.mof.egl.Expression)index, (org.eclipse.edt.mof.egl.Type)((org.eclipse.edt.mof.egl.Type)this.getMofSerializable("egl:eglx.lang.EInt"))));
                    ax.setArray(arrayExpression);
                    lastAC = ax;
                }
            }
            ++i;
        }
        this.setElementInformation((Node)node, (EObject)lastAC);
        this.stack.push(lastAC);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ArrayLiteral node) {
        ArrayList<org.eclipse.edt.mof.egl.Expression> entries = new ArrayList<org.eclipse.edt.mof.egl.Expression>();
        for (Expression expr : node.getExpressions()) {
            expr.accept(this);
            entries.add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        }
        ArrayLiteral lit = this.factory.createArrayLiteral();
        lit.getEntries().addAll(entries);
        this.setElementInformation((Node)node, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(ObjectExpression node) {
        ArrayList<ObjectExpressionEntry> entries = new ArrayList<ObjectExpressionEntry>();
        for (org.eclipse.edt.compiler.core.ast.ObjectExpressionEntry entry : node.getEntries()) {
            ObjectExpressionEntry entryIR = this.factory.createObjectExpressionEntry();
            entryIR.setId(entry.getId());
            entry.getExpression().accept(this);
            entryIR.setExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            entries.add(entryIR);
        }
        org.eclipse.edt.mof.egl.ObjectExpression objExpr = this.factory.createObjectExpression();
        objExpr.getEntries().addAll(entries);
        this.setElementInformation((Node)node, (EObject)objExpr);
        this.stack.push(objExpr);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Assignment assignment) {
        Assignment expr = this.factory.createAssignment();
        expr.setOperator(assignment.getOperator().toString());
        this.setElementInformation((Node)assignment, (EObject)expr);
        this.stack.push(expr);
        assignment.getLeftHandSide().accept(this);
        expr.setLHS((LHSExpr)this.eStackPop());
        assignment.getRightHandSide().accept(this);
        expr.setRHS((org.eclipse.edt.mof.egl.Expression)this.eStackPop());
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.BinaryExpression binExpr) {
        BinaryExpression expr = this.factory.createBinaryExpression();
        this.setElementInformation((Node)binExpr, (EObject)expr);
        this.stack.push(expr);
        binExpr.getFirstExpression().accept(this);
        org.eclipse.edt.mof.egl.Expression arg1 = (org.eclipse.edt.mof.egl.Expression)this.eStackPop();
        binExpr.getSecondExpression().accept(this);
        org.eclipse.edt.mof.egl.Expression arg2 = (org.eclipse.edt.mof.egl.Expression)this.eStackPop();
        expr.setLHS(arg1);
        expr.setRHS(arg2);
        expr.setOperator(binExpr.getOperator().toString());
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.TernaryExpression ternaryExpr) {
        TernaryExpression expr = this.factory.createTernaryExpression();
        this.setElementInformation((Node)ternaryExpr, (EObject)expr);
        this.stack.push(expr);
        ternaryExpr.getFirstExpr().accept(this);
        org.eclipse.edt.mof.egl.Expression arg1 = (org.eclipse.edt.mof.egl.Expression)this.eStackPop();
        ternaryExpr.getSecondExpr().accept(this);
        org.eclipse.edt.mof.egl.Expression arg2 = (org.eclipse.edt.mof.egl.Expression)this.eStackPop();
        ternaryExpr.getThirdExpr().accept(this);
        org.eclipse.edt.mof.egl.Expression arg3 = (org.eclipse.edt.mof.egl.Expression)this.eStackPop();
        expr.setFirst(arg1);
        expr.setSecond(arg2);
        expr.setThird(arg3);
        expr.setOperator("?");
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.BooleanLiteral literal) {
        BooleanLiteral lit = this.factory.createBooleanLiteral();
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(BytesLiteral literal) {
        org.eclipse.edt.mof.egl.BytesLiteral lit = this.factory.createBytesLiteral();
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(FloatLiteral literal) {
        FloatingPointLiteral lit = this.factory.createFloatingPointLiteral();
        if (literal.getLiteralKind() == 15) {
            lit.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.ESmallfloat"));
        } else {
            lit.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.EFloat"));
        }
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.DecimalLiteral literal) {
        DecimalLiteral lit = this.factory.createDecimalLiteral();
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(FieldAccess fieldAccess) {
        org.eclipse.edt.mof.egl.Type type = (org.eclipse.edt.mof.egl.Type)this.mofTypeFor(fieldAccess.getPrimary().resolveType());
        if (TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)type)) {
            DynamicAccess expr = this.factory.createDynamicAccess();
            this.setElementInformation((Node)fieldAccess, (EObject)expr);
            StringLiteral index = this.factory.createStringLiteral();
            index.setValue(fieldAccess.getCaseSensitiveID());
            expr.setAccess((org.eclipse.edt.mof.egl.Expression)index);
            this.stack.push(expr);
            fieldAccess.getPrimary().accept(this);
            expr.setExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        } else {
            MemberAccess expr = this.factory.createMemberAccess();
            expr.setId(fieldAccess.getCaseSensitiveID());
            this.setElementInformation((Node)fieldAccess, (EObject)expr);
            this.stack.push(expr);
            fieldAccess.getPrimary().accept(this);
            expr.setQualifier((org.eclipse.edt.mof.egl.Expression)this.eStackPop());
        }
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        DelegateInvocation fi;
        List functionParmBindings;
        org.eclipse.edt.mof.egl.Type typeBinding = node.getTarget().resolveType();
        if (typeBinding instanceof Delegate) {
            functionParmBindings = ((Delegate)typeBinding).getParameters();
            fi = this.factory.createDelegateInvocation();
            fi.setId(((Delegate)typeBinding).getCaseSensitiveName());
            node.getTarget().accept(this);
            fi.setExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        } else {
            String id;
            Member mbr;
            boolean isStatic;
            Element targetBinding = (Element)node.getTarget().resolveElement();
            Function functionBinding = null;
            Part declarer = null;
            if (targetBinding instanceof Function) {
                functionBinding = (Function)targetBinding;
                functionParmBindings = functionBinding.getParameters();
                declarer = (Part)functionBinding.getContainer();
            } else {
                functionParmBindings = new ArrayList();
            }
            boolean bl = isStatic = functionBinding != null && (functionBinding.isStatic() != false || functionBinding.getContainer() instanceof Library);
            if (node.getTarget() instanceof org.eclipse.edt.compiler.core.ast.ThisExpression || node.getTarget() instanceof org.eclipse.edt.compiler.core.ast.SuperExpression) {
                ThisExpression expr;
                fi = this.factory.createConstructorInvocation();
                fi.setId("constructor");
                if (node.getTarget() instanceof org.eclipse.edt.compiler.core.ast.ThisExpression) {
                    expr = this.factory.createThisExpression();
                    expr.setThisObject((Element)((Part)this.currentPart));
                } else {
                    expr = this.factory.createSuperExpression();
                    ((SuperExpression)expr).setThisObject((Element)((Part)this.currentPart));
                }
                ((ConstructorInvocation)fi).setExpression((org.eclipse.edt.mof.egl.Expression)expr);
            } else if (node.getTarget() instanceof SimpleName && !isStatic) {
                if (functionBinding == null || this.isSuperTypeMember(functionBinding)) {
                    fi = this.factory.createQualifiedFunctionInvocation();
                    fi.setId(node.getTarget().getCanonicalString());
                    ThisExpression thisExpr = this.factory.createThisExpression();
                    thisExpr.setThisObject((Element)((Part)this.currentPart));
                    ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)thisExpr);
                } else {
                    mbr = (Member)this.getEObjectFor((Member)functionBinding);
                    id = null;
                    if (mbr instanceof FunctionMember) {
                        id = ((FunctionMember)mbr).getCaseSensitiveName();
                    } else if (functionBinding != null) {
                        id = functionBinding.getCaseSensitiveName();
                    }
                    fi = this.factory.createFunctionInvocation();
                    fi.setId(id);
                    ((org.eclipse.edt.mof.egl.FunctionInvocation)fi).setTarget(mbr);
                }
            } else if (isStatic && node.getTarget() instanceof org.eclipse.edt.compiler.core.ast.Name) {
                if (this.mofTypeFor((org.eclipse.edt.mof.egl.Type)declarer) == this.currentPart) {
                    mbr = (Member)this.getEObjectFor((Member)functionBinding);
                    id = null;
                    if (mbr instanceof FunctionMember) {
                        id = ((FunctionMember)mbr).getCaseSensitiveName();
                    } else if (functionBinding != null) {
                        id = functionBinding.getCaseSensitiveName();
                    }
                    fi = this.factory.createFunctionInvocation();
                    fi.setId(id);
                    ((org.eclipse.edt.mof.egl.FunctionInvocation)fi).setTarget(mbr);
                } else {
                    fi = this.factory.createQualifiedFunctionInvocation();
                    fi.setId(functionBinding.getCaseSensitiveName());
                    PartName partName = this.factory.createPartName();
                    partName.setId(declarer.getCaseSensitiveName());
                    partName.setPackageName(declarer.getCaseSensitivePackageName());
                    this.setElementInformation((Node)node.getTarget(), (EObject)partName);
                    ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)partName);
                }
            } else if (node.getTarget() instanceof FieldAccess) {
                FieldAccess fa = (FieldAccess)node.getTarget();
                if (fa.getPrimary() instanceof org.eclipse.edt.compiler.core.ast.ThisExpression || fa.getPrimary() instanceof org.eclipse.edt.compiler.core.ast.SuperExpression) {
                    if (functionBinding == null || this.isSuperTypeMember(functionBinding)) {
                        fi = this.factory.createQualifiedFunctionInvocation();
                        fi.setId(functionBinding.getCaseSensitiveName());
                        if (fa.getPrimary() instanceof org.eclipse.edt.compiler.core.ast.SuperExpression) {
                            SuperExpression superExpr = this.factory.createSuperExpression();
                            superExpr.setThisObject((Element)((Part)this.currentPart));
                            ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)superExpr);
                        } else {
                            ThisExpression thisExpr = this.factory.createThisExpression();
                            thisExpr.setThisObject((Element)((Part)this.currentPart));
                            ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)thisExpr);
                        }
                    } else {
                        Member mbr2 = (Member)this.getEObjectFor((Member)functionBinding);
                        String id2 = null;
                        if (mbr2 instanceof FunctionMember) {
                            id2 = ((FunctionMember)mbr2).getCaseSensitiveName();
                        } else if (functionBinding != null) {
                            id2 = functionBinding.getCaseSensitiveName();
                        }
                        fi = this.factory.createFunctionInvocation();
                        fi.setId(id2);
                        ((org.eclipse.edt.mof.egl.FunctionInvocation)fi).setTarget(mbr2);
                    }
                } else {
                    fi = this.factory.createQualifiedFunctionInvocation();
                    if (functionBinding == null) {
                        fi.setId(node.getTarget().getCaseSensitiveID());
                    } else {
                        fi.setId(functionBinding.getCaseSensitiveName());
                    }
                    fa.getPrimary().accept(this);
                    ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
                }
            } else if (node.getTarget() instanceof QualifiedName) {
                fi = this.factory.createQualifiedFunctionInvocation();
                QualifiedName name = (QualifiedName)node.getTarget();
                fi.setId(name.getCaseSensitiveIdentifier());
                name.getQualifier().accept(this);
                ((QualifiedFunctionInvocation)fi).setQualifier((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            } else {
                fi = this.factory.createFunctionInvocation();
                fi.setId(node.getTarget().getCanonicalString());
            }
        }
        int index = 0;
        for (Expression argExpr : node.getArguments()) {
            argExpr.accept(this);
            org.eclipse.edt.mof.egl.Expression expr = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
            if (functionParmBindings.size() > 0) {
                if (functionParmBindings.size() > index) {
                    FunctionParameter cfr_ignored_0 = (FunctionParameter)functionParmBindings.get(index);
                } else {
                    FunctionParameter cfr_ignored_1 = (FunctionParameter)functionParmBindings.get(functionParmBindings.size() - 1);
                }
            }
            fi.getArguments().add(expr);
            ++index;
        }
        this.setElementInformation((Node)node, (EObject)fi);
        this.stack.push(fi);
        return false;
    }

    @Override
    public boolean visit(IntegerLiteral literal) {
        org.eclipse.edt.mof.egl.IntegerLiteral lit = this.factory.createIntegerLiteral();
        switch (literal.getLiteralKind()) {
            case 14: {
                lit.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.EBigint"));
                break;
            }
            case 13: {
                lit.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.ESmallint"));
                break;
            }
            default: {
                lit.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.EInt"));
            }
        }
        lit.setValue(literal.getValue());
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.IsAExpression expr) {
        IsAExpression isaExpr = this.factory.createIsAExpression();
        this.setElementInformation((Node)expr, (EObject)isaExpr);
        this.stack.push(isaExpr);
        expr.getExpression().accept(this);
        isaExpr.setObjectExpr((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        org.eclipse.edt.mof.egl.Type type = (org.eclipse.edt.mof.egl.Type)this.mofTypeFor(expr.getType().resolveType());
        isaExpr.setEType(type);
        return false;
    }

    @Override
    public boolean visit(ParenthesizedExpression parenExpr) {
        return true;
    }

    private Name createNameForPart(org.eclipse.edt.mof.egl.Type binding) {
        if (binding instanceof StructPart || binding instanceof ExternalType || binding instanceof Enumeration || binding instanceof Program || binding instanceof Interface || binding instanceof Service) {
            PartName name = this.factory.createPartName();
            String packageName = ((Part)binding).getCaseSensitivePackageName();
            name.setPackageName(packageName);
            name.setId(((Part)binding).getCaseSensitiveName());
            return name;
        }
        return this.factory.createDanglingReference();
    }

    @Override
    public boolean visit(SimpleName node) {
        Object binding = node.resolveElement();
        if (binding == null) {
            Object invalid = this.currentPart instanceof FunctionPart ? this.factory.createDanglingReference() : this.factory.createInvalidName();
            invalid.setId(node.getCanonicalName());
            this.setElementInformation((Node)node, (EObject)invalid);
            this.stack.push(invalid);
            return false;
        }
        Name name = null;
        if (binding instanceof Part) {
            name = this.createNameForPart((org.eclipse.edt.mof.egl.Type)((Part)binding));
            name.setId(((Part)binding).getCaseSensitiveName());
        } else if (binding instanceof Member) {
            name = this.factory.createMemberName();
            if (((Member)binding).getContainer() == null && TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)((Member)binding).getType())) {
                name.setId(node.getCaseSensitiveIdentifier());
            } else {
                name.setId(((Member)binding).getCaseSensitiveName());
            }
        }
        Container qualifier = null;
        if (binding instanceof Member && this.isInOtherLibrary(((Member)binding).getContainer())) {
            qualifier = ((Member)binding).getContainer();
        } else if (binding instanceof EnumerationEntry) {
            qualifier = ((Member)binding).getContainer();
        }
        if (qualifier != null) {
            if (qualifier instanceof Part) {
                name = (Name)this.addQualifier((Element)this.createNameForPart((org.eclipse.edt.mof.egl.Type)((Part)qualifier)), (LHSExpr)name);
            } else {
                Element context = (Element)this.getEObjectFor(qualifier);
                name = (Name)this.addQualifier(context, (LHSExpr)name);
            }
        }
        if (name instanceof MemberName) {
            if (this.isSuperTypeMember(binding)) {
                ThisExpression thisExpr = this.factory.createThisExpression();
                thisExpr.setThisObject((Element)((Part)this.currentPart));
                name = (Name)this.addQualifier((Element)thisExpr, (LHSExpr)name);
            } else {
                EObject result = this.getEObjectFor(binding);
                if (result instanceof Member) {
                    Member mbr = (Member)result;
                    ((MemberName)name).setMember(mbr);
                }
            }
        }
        this.setElementInformation((Node)node, (EObject)name);
        this.stack.push(name);
        return false;
    }

    @Override
    public boolean visit(QualifiedName name) {
        Object element = name.resolveElement();
        if (element instanceof Member && ((Member)element).getContainer() == null && TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)((Member)element).getType())) {
            DynamicAccess expr = this.factory.createDynamicAccess();
            this.setElementInformation((Node)name, (EObject)expr);
            StringLiteral index = this.factory.createStringLiteral();
            index.setValue(name.getCaseSensitiveIdentifier());
            expr.setAccess((org.eclipse.edt.mof.egl.Expression)index);
            this.stack.push(expr);
            name.getQualifier().accept(this);
            expr.setExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        } else {
            MemberAccess nameExpr = this.factory.createMemberAccess();
            this.setElementInformation((Node)name, (EObject)nameExpr);
            this.stack.push(nameExpr);
            nameExpr.setId(name.getCaseSensitiveIdentifier());
            Object qualBinding = name.getQualifier().resolveElement();
            if (qualBinding instanceof Part) {
                nameExpr.setQualifier((org.eclipse.edt.mof.egl.Expression)this.createNameForPart((org.eclipse.edt.mof.egl.Type)((Part)qualBinding)));
            } else {
                name.getQualifier().accept(this);
                nameExpr.setQualifier((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            }
        }
        return false;
    }

    private boolean isInOtherLibrary(Container binding) {
        return binding instanceof Library && !this.mofTypeFor((org.eclipse.edt.mof.egl.Type)((Library)binding)).equals(this.currentPart);
    }

    @Override
    public boolean visit(NullLiteral literal) {
        org.eclipse.edt.mof.egl.NullLiteral lit = this.factory.createNullLiteral();
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.StringLiteral literal) {
        StringLiteral lit = this.factory.createStringLiteral();
        lit.setValue(literal.getValue());
        lit.setIsHex(Boolean.valueOf(literal.isHex()));
        this.setElementInformation((Node)literal, (EObject)lit);
        this.stack.push(lit);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.IsNotExpression isNotExpression) {
        IsNotExpression expr = this.factory.createIsNotExpression();
        this.setElementInformation((Node)isNotExpression, (EObject)expr);
        this.stack.push(expr);
        isNotExpression.getFirstExpression().accept(this);
        expr.setExpr((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        expr.setOperation(isNotExpression.getOperator().toString());
        SimpleName mnemonic = (SimpleName)isNotExpression.getSecondExpression();
        expr.setMnemonic(mnemonic.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(NewExpression newExpression) {
        org.eclipse.edt.mof.egl.NewExpression expr = this.factory.createNewExpression();
        org.eclipse.edt.mof.egl.Type type = newExpression.resolveType();
        if (type == null) {
            this.stack.push(expr);
            return false;
        }
        EObject obj = this.mofTypeFor(type);
        if (!(obj instanceof org.eclipse.edt.mof.egl.Type)) {
            this.stack.push(expr);
            return false;
        }
        org.eclipse.edt.mof.egl.Type mofType = (org.eclipse.edt.mof.egl.Type)obj;
        expr.setId(type.getTypeSignature());
        this.setElementInformation((Node)newExpression, (EObject)expr);
        if (newExpression.getType() instanceof NameType) {
            for (Expression argument : ((NameType)newExpression.getType()).getArguments()) {
                argument.accept(this);
                expr.getArguments().add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            }
        }
        if (newExpression.getType().isArrayType()) {
            this.processNewArray(newExpression.getType(), expr);
        }
        if (newExpression.getSettingsBlock() != null && newExpression.getSettingsBlock().getSettings().size() > 0) {
            org.eclipse.edt.mof.egl.SetValuesExpression sve = this.processSettings((org.eclipse.edt.mof.egl.Expression)expr, newExpression, mofType, newExpression.getSettingsBlock());
            this.setElementInformation((Node)newExpression, (EObject)sve);
            this.stack.push(sve);
        } else {
            this.stack.push(expr);
        }
        return false;
    }

    private void processNewArray(Type type, org.eclipse.edt.mof.egl.NewExpression expr) {
        if (type.isArrayType()) {
            ArrayType arrType = (ArrayType)type;
            this.processNewArray(arrType.getElementType(), expr);
            if (arrType.hasInitialSize()) {
                arrType.getInitialSize().accept(this);
                expr.getArguments().add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            } else {
                org.eclipse.edt.mof.egl.IntegerLiteral lit = this.factory.createIntegerLiteral();
                lit.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.EInt"));
                lit.setValue("0");
                this.setElementInformation((Node)type, (EObject)lit);
                expr.getArguments().add(lit);
            }
        }
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        EObject obj;
        setValuesExpression.getExpression().accept(this);
        org.eclipse.edt.mof.egl.Type targetType = null;
        if (setValuesExpression.getExpression().resolveType() != null && (obj = this.mofTypeFor(setValuesExpression.getExpression().resolveType())) instanceof org.eclipse.edt.mof.egl.Type) {
            targetType = (org.eclipse.edt.mof.egl.Type)obj;
        }
        org.eclipse.edt.mof.egl.SetValuesExpression sve = this.processSettings((org.eclipse.edt.mof.egl.Expression)this.stack.pop(), setValuesExpression.getExpression(), targetType, setValuesExpression.getSettingsBlock());
        this.setElementInformation((Node)setValuesExpression, (EObject)sve);
        this.stack.push(sve);
        return false;
    }

    private org.eclipse.edt.mof.egl.SetValuesExpression processSettings(org.eclipse.edt.mof.egl.Expression target, Expression targetNode, org.eclipse.edt.mof.egl.Type targetType, SettingsBlock settings) {
        if (!this.localStack.isEmpty() && target instanceof LHSExpr) {
            if (!this.sveTypeStack.isEmpty() && TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)this.sveTypeStack.peek())) {
                DynamicAccess da = this.factory.createDynamicAccess();
                this.setElementInformation((Node)settings, (EObject)da);
                LHSExpr newLHS = this.setAccessForDynamicAccess(da, target);
                da.setExpression((org.eclipse.edt.mof.egl.Expression)this.localStack.peek());
                target = newLHS;
            } else {
                target = this.addQualifier((Element)this.localStack.peek(), (LHSExpr)target);
            }
        }
        this.sveStack.push(target);
        this.sveTypeStack.push(targetType);
        org.eclipse.edt.mof.egl.SetValuesExpression sve = this.factory.createSetValuesExpression();
        sve.setTarget(target);
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)settings, (Statement)block);
        MemberName localRef = null;
        Field decl = null;
        if (!(target instanceof LHSExpr)) {
            LocalVariableDeclarationStatement local = this.factory.createLocalVariableDeclarationStatement();
            DeclarationExpression declExpr = this.factory.createDeclarationExpression();
            decl = this.factory.createField();
            decl.setName("eze$SettingTarget" + this.sveStack.size());
            decl.setType(targetType);
            this.setElementInformation((Node)targetNode, (EObject)decl);
            declExpr.getFields().add(decl);
            local.setExpression(declExpr);
            this.setElementInformation((Node)targetNode, (Statement)local);
            Assignment assignExpr = this.factory.createAssignment();
            localRef = this.factory.createMemberName();
            localRef.setId(decl.getCaseSensitiveName());
            localRef.setMember((Member)decl);
            this.localStack.push((LHSExpr)localRef);
            assignExpr.setLHS((LHSExpr)localRef);
            assignExpr.setRHS(target);
            StatementBlock initializer = this.factory.createStatementBlock();
            AssignmentStatement stmt = this.createAssignmentStatement(assignExpr);
            this.setElementInformation((Node)targetNode, (Statement)stmt);
            initializer.getStatements().add(stmt);
            this.setElementInformation((Node)targetNode, (Statement)initializer);
            decl.setInitializerStatements(initializer);
            decl.setContainer(initializer.getContainer());
            block.getStatements().add(local);
        } else {
            this.localStack.push((LHSExpr)target);
        }
        for (Node setting : settings.getSettings()) {
            AssignmentStatement stmt2;
            setting.accept(this);
            org.eclipse.edt.mof.egl.Expression setexpr = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
            LHSExpr ref = null;
            if (decl == null) {
                ref = (LHSExpr)target;
            } else {
                ref = this.factory.createMemberName();
                ((MemberName)ref).setId(decl.getCaseSensitiveName());
                ((MemberName)ref).setMember((Member)decl);
            }
            if (setexpr instanceof Assignment) {
                Assignment assign = (Assignment)setexpr;
                if (TypeUtils.isDynamicType((org.eclipse.edt.mof.egl.Type)targetType)) {
                    DynamicAccess da = this.factory.createDynamicAccess();
                    this.setElementInformation(setting, (EObject)da);
                    LHSExpr newLHS = this.setAccessForDynamicAccess(da, (org.eclipse.edt.mof.egl.Expression)assign.getLHS());
                    da.setExpression((org.eclipse.edt.mof.egl.Expression)ref);
                    assign.setLHS(newLHS);
                } else {
                    LHSExpr lhs = this.addQualifier((Element)ref, assign.getLHS());
                    assign.setLHS(lhs);
                }
                stmt2 = this.createAssignmentStatement(assign);
                this.setElementInformation(setting, (Statement)stmt2);
                block.getStatements().add(stmt2);
                continue;
            }
            if (setexpr instanceof org.eclipse.edt.mof.egl.SetValuesExpression && !(setting instanceof NewExpression)) {
                org.eclipse.edt.mof.egl.SetValuesExpression ex = (org.eclipse.edt.mof.egl.SetValuesExpression)setexpr;
                for (AssignmentStatement stmt2 : ex.getSettings().getStatements()) {
                    block.getStatements().add(stmt2);
                }
                continue;
            }
            QualifiedFunctionInvocation func = this.factory.createQualifiedFunctionInvocation();
            this.setElementInformation(setting, (EObject)func);
            func.setQualifier((org.eclipse.edt.mof.egl.Expression)ref);
            func.setId("appendElement");
            func.getArguments().add(setexpr);
            stmt2 = this.factory.createFunctionStatement();
            stmt2.setExpr((org.eclipse.edt.mof.egl.Expression)func);
            this.setElementInformation(setting, (Statement)stmt2);
            block.getStatements().add(stmt2);
        }
        sve.setSettings(block);
        this.sveStack.pop();
        this.sveTypeStack.pop();
        this.localStack.pop();
        return sve;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.SubstringAccess substringAccess) {
        SubstringAccess access = this.factory.createSubstringAccess();
        this.setElementInformation((Node)substringAccess, (EObject)access);
        this.stack.push(access);
        substringAccess.getExpr().accept(this);
        access.setStart((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        substringAccess.getExpr2().accept(this);
        access.setEnd((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        substringAccess.getPrimary().accept(this);
        access.setStringExpression((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.SuperExpression superExpression) {
        SuperExpression expr = this.factory.createSuperExpression();
        expr.setThisObject((Element)((Part)this.currentPart));
        this.setElementInformation((Node)superExpression, (EObject)expr);
        this.stack.push(expr);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ThisExpression thisExpression) {
        ThisExpression expr = this.factory.createThisExpression();
        Element binding = (Element)thisExpression.resolveElement();
        if (binding == null) {
            binding = thisExpression.resolveType();
        }
        Element obj = (Element)this.getEObjectFor(binding);
        expr.setThisObject(obj);
        this.setElementInformation((Node)thisExpression, (EObject)expr);
        this.stack.push(expr);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.UnaryExpression unaryExpression) {
        boolean isMinus;
        unaryExpression.getExpression().accept(this);
        org.eclipse.edt.mof.egl.Expression subExpr = (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
        if (unaryExpression.getOperator() == UnaryExpression.Operator.PLUS) {
            this.stack.push(subExpr);
            return false;
        }
        boolean bl = isMinus = unaryExpression.getOperator() == UnaryExpression.Operator.MINUS;
        if (subExpr instanceof NumericLiteral && isMinus) {
            ((NumericLiteral)subExpr).setIsNegated(Boolean.valueOf(((NumericLiteral)subExpr).isNegated() == false));
            this.stack.push(subExpr);
        } else {
            UnaryExpression expr = this.factory.createUnaryExpression();
            this.setElementInformation((Node)unaryExpression, (EObject)expr);
            this.stack.push(expr);
            expr.setExpression(subExpr);
            expr.setOperator(unaryExpression.getOperator().toString());
        }
        return false;
    }

    private boolean isSuperTypeMember(Object binding) {
        if (binding == null) {
            return false;
        }
        StructPart part = null;
        if (binding instanceof Member && ((Member)binding).getContainer() instanceof StructPart) {
            part = (StructPart)this.mofTypeFor((org.eclipse.edt.mof.egl.Type)((Member)binding).getContainer());
        } else if (binding instanceof Member) {
            return this.isSuperTypeMember(((Member)binding).getContainer());
        }
        StructPart current = (StructPart)this.currentBindingLevelPart;
        return part != null && current.equals(part) == false && current.isSubtypeOf(part);
    }
}

