/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofPart;
import org.eclipse.edt.compiler.internal.egl2mof.ElementGenerator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EModelElement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BytesLiteral;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DynamicAccess;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.InvalidName;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Parameter;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.StringLiteral;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.utils.EList;

class Egl2MofMember
extends Egl2MofPart {
    Egl2MofMember(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(ClassDataDeclaration node) {
        ArrayList<EField> list = new ArrayList<EField>();
        for (Name name : node.getNames()) {
            EField obj;
            Member field = name.resolveMember();
            if (field == null) {
                this.stack.push(null);
                return false;
            }
            if (this.inMofContext) {
                EField f = this.mof.createEField(true);
                this.setUpMofTypedElement((EMember)f, field);
                this.setInitialValue(node, f);
                obj = f;
            } else {
                EClass fieldClass = field.getEClass();
                Field f = (Field)fieldClass.newInstance();
                this.setUpEglTypedElement((TypedElement)f, field);
                f.setIsStatic(field.isStatic());
                f.setAccessKind(field.getAccessKind());
                this.addInitializers(node, f, node.getType());
                obj = f;
            }
            this.eObjects.put(field, obj);
            this.setElementInformation(node, (EObject)obj);
            list.add(obj);
        }
        if (list.isEmpty()) {
            this.stack.push(null);
        } else if (list.size() == 1) {
            this.stack.push(list.get(0));
        } else {
            this.stack.push(list);
        }
        return false;
    }

    private void setMetadata(Element binding, EField field) {
        for (Annotation annotation : binding.getAnnotations()) {
            field.getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
        }
    }

    @Override
    public boolean visit(StructureItem node) {
        Object elem = node.getName().resolveElement();
        if (elem == null) {
            this.stack.push(null);
            return false;
        }
        Field obj = null;
        if (this.inMofContext) {
            final EField f = this.mof.createEField(true);
            if (elem instanceof EField) {
                f.setIsNullable(((EField)elem).isNullable());
                f.setEType(((EField)elem).getEType());
                f.setName(((EField)elem).getCaseSensitiveName());
                if (node.hasSettingsBlock()) {
                    DefaultASTVisitor visitor = new DefaultASTVisitor(){

                        @Override
                        public boolean visit(SettingsBlock settingsBlock) {
                            return true;
                        }

                        @Override
                        public boolean visit(AnnotationExpression annExpr) {
                            if (annExpr.resolveAnnotation() != null) {
                                f.getMetadataList().add((EMetadataObject)Egl2MofMember.this.mofValueFrom(annExpr.resolveAnnotation()));
                            }
                            return false;
                        }
                    };
                    node.getSettingsBlock().accept(visitor);
                }
            } else {
                this.setUpMofTypedElement((EMember)f, (Member)((Field)elem));
                this.setMetadata((Element)((Field)elem), f);
            }
            this.setInitialValue(node, f);
            obj = f;
        } else {
            Field field = (Field)elem;
            EClass fieldClass = this.mofMemberTypeFor((Element)field);
            Field f = (Field)fieldClass.newInstance();
            this.setUpEglTypedElement((TypedElement)f, (Member)field);
            this.addInitializers(node, f, node.getType());
            obj = f;
        }
        this.eObjects.put(elem, obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(NestedFunction node) {
        EFunction func;
        Function function = (Function)node.getName().resolveElement();
        if (function == null) {
            this.stack.push(null);
            return false;
        }
        EFunction obj = null;
        if (this.inMofContext) {
            func = this.mof.createEFunction(true);
            this.setUpMofTypedElement((EMember)func, (Member)function);
            obj = func;
        } else {
            func = null;
            ElementGenerator gen = this.getElementGenerator(node);
            if (gen != null) {
                func = (Function)gen.generate(node, this.eObjects);
            }
            if (func == null) {
                func = (Function)function.getEClass().newInstance();
            }
            this.setUpEglTypedElement((TypedElement)func, (Member)function);
            func.setIsStatic(function.isStatic());
            func.setIsAbstract(function.isAbstract());
            if (!function.isAbstract().booleanValue()) {
                StatementBlock stmts = this.factory.createStatementBlock();
                stmts.setContainer((Container)func);
                func.setStatementBlock(stmts);
                this.functionsToProcess.add(node);
            }
            if (node.hasSettingsBlock()) {
                this.processSettings((Element)func, node.getSettingsBlock());
            }
            if (function.getAccessKind() == AccessKind.ACC_PRIVATE) {
                func.setAccessKind(AccessKind.ACC_PRIVATE);
            }
            obj = func;
        }
        for (org.eclipse.edt.compiler.core.ast.FunctionParameter parm : node.getFunctionParameters()) {
            parm.accept(this);
            if (this.inMofContext) {
                obj.addMember((EMember)((EParameter)this.stack.pop()));
                continue;
            }
            Parameter parameter = (Parameter)this.stack.pop();
            parameter.setContainer((Container)((FunctionMember)obj));
            ((FunctionMember)obj).addMember((Member)parameter);
        }
        this.eObjects.put(function, obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Constructor node) {
        Part etAST = (Part)node.getParent();
        org.eclipse.edt.mof.egl.Part constBinding = (org.eclipse.edt.mof.egl.Part)etAST.getName().resolveType();
        if (constBinding == null) {
            this.stack.push(null);
            return false;
        }
        Constructor constructor = node.getBinding();
        Constructor obj = null;
        if (this.inMofContext) {
            obj = null;
        } else {
            EClass constClass = this.mofMemberTypeFor((Element)constructor);
            Constructor cons = (Constructor)constClass.newInstance();
            if (node.getStmts() != null) {
                StatementBlock stmts = this.factory.createStatementBlock();
                stmts.setContainer((Container)cons);
                cons.setStatementBlock(stmts);
                this.functionsToProcess.add(node);
            }
            if (node.isPrivate()) {
                cons.setAccessKind(AccessKind.ACC_PRIVATE);
            }
            this.setUpEglTypedElement((TypedElement)cons, (Member)constructor);
            obj = cons;
        }
        for (org.eclipse.edt.compiler.core.ast.FunctionParameter parm : node.getParameters()) {
            parm.accept(this);
            if (this.inMofContext) {
                ((EFunction)obj).addMember((EMember)((EParameter)this.stack.pop()));
                continue;
            }
            ((FunctionMember)obj).addMember((Member)((Parameter)this.stack.pop()));
        }
        this.eObjects.put(constructor, obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.FunctionParameter node) {
        EParameter obj;
        FunctionParameter parameter = (FunctionParameter)node.getName().resolveMember();
        if (parameter == null) {
            this.stack.push(null);
            return false;
        }
        if (this.inMofContext) {
            EParameter parm = this.mof.createEParameter(true);
            parm.setName(parameter.getCaseSensitiveName());
            this.setUpMofTypedElement((EMember)parm, (Member)parameter);
            obj = parm;
        } else {
            FunctionParameter parm = this.factory.createFunctionParameter();
            parm.setParameterKind(parameter.getParameterKind());
            parm.setAccessKind(parameter.getAccessKind());
            parm.setIsConst(parameter.isConst());
            parm.setIsField(parameter.isField());
            parm.setIsNullable(parameter.isNullable());
            this.setUpEglTypedElement((TypedElement)parm, (Member)parameter);
            obj = parm;
        }
        this.eObjects.put(parameter, obj);
        this.setElementInformation(node, (EObject)obj);
        this.stack.push(obj);
        return false;
    }

    @Override
    public boolean visit(SettingsBlock node) {
        this.stack.push(null);
        return false;
    }

    @Override
    public boolean visit(EnumerationField enumField) {
        if (enumField.getName().resolveElement() != null) {
            EnumerationEntry binding = (EnumerationEntry)enumField.getName().resolveElement();
            Integer value = binding.getValue();
            if (this.inMofContext) {
                EEnumLiteral literal = (EEnumLiteral)this.mof.getEEnumLiteralClass().newInstance();
                literal.setName(binding.getCaseSensitiveName());
                literal.setValue(value.intValue());
                this.createAnnotations((Element)binding, (EModelElement)literal);
                this.stack.push(literal);
            } else {
                EnumerationEntry entry = this.factory.createEnumerationEntry();
                entry.setName(binding.getCaseSensitiveName());
                entry.setValue(value.intValue());
                this.eObjects.put(binding, entry);
                this.createAnnotations((Element)binding, (Element)entry);
                this.setElementInformation(enumField, (EObject)entry);
                this.stack.push(entry);
            }
        }
        return false;
    }

    private void setUpMofTypedElement(EMember obj, Member edtObj) {
        EObject eObj = this.mofTypeFromTypedElement((Element)edtObj);
        if (eObj instanceof EType) {
            Annotation mofName;
            EType type = (EType)eObj;
            obj.setEType(type);
            obj.setIsNullable(edtObj.isNullable());
            if (obj instanceof EField) {
                Annotation ann = this.getAnnotation((Element)edtObj, "egl.lang.reflect.mof.transient");
                if (ann != null) {
                    ((EField)obj).setIsTransient(((java.lang.Boolean)ann.getValue()).booleanValue());
                }
                if ((ann = BindingUtil.getAnnotationWithSimpleName((Element)edtObj, "containment")) != null) {
                    ((EField)obj).setContainment(((java.lang.Boolean)ann.getValue()).booleanValue());
                }
            }
            if ((mofName = this.getAnnotation((Element)edtObj, "egl.lang.reflect.mof.mofName")) != null) {
                obj.setName((String)this.getValue(mofName.getValue(), false));
            } else {
                obj.setName(edtObj.getCaseSensitiveName());
            }
        }
    }

    protected LHSExpr setAccessForDynamicAccess(DynamicAccess da, Expression expr) {
        if (expr == null) {
            return da;
        }
        if (expr instanceof MemberName) {
            StringLiteral index = this.factory.createStringLiteral();
            index.setValue(((MemberName)expr).getId());
            da.setAccess((Expression)index);
            return da;
        }
        if (expr instanceof DynamicAccess) {
            DynamicAccess oldDA = (DynamicAccess)expr;
            this.setAccessForDynamicAccess(da, oldDA.getExpression());
            if (oldDA.getExpression() instanceof MemberName) {
                oldDA.setExpression((Expression)da);
            }
            return oldDA;
        }
        if (expr instanceof ArrayAccess) {
            ArrayAccess oldAA = (ArrayAccess)expr;
            this.setAccessForDynamicAccess(da, oldAA.getArray());
            if (oldAA.getArray() instanceof MemberName) {
                oldAA.setArray((Expression)da);
            }
            return oldAA;
        }
        return null;
    }

    protected void processSettings(Element context, SettingsBlock settings) {
        StatementBlock block = null;
        int arrayIndex = 0;
        for (Node expr : settings.getSettings()) {
            Expression qualifier;
            AssignmentStatement stmt;
            if (expr instanceof AnnotationExpression && ((AnnotationExpression)expr).getName().resolveElement() instanceof Annotation) {
                Annotation value = (Annotation)this.mofValueFrom(((AnnotationExpression)expr).getName().resolveElement());
                context.getAnnotations().add(value);
                continue;
            }
            if (expr instanceof org.eclipse.edt.compiler.core.ast.Assignment) {
                org.eclipse.edt.compiler.core.ast.Assignment assignment = (org.eclipse.edt.compiler.core.ast.Assignment)expr;
                org.eclipse.edt.compiler.core.ast.Expression lhsExpr = assignment.getLeftHandSide();
                if (lhsExpr.resolveType() == null) continue;
                if (lhsExpr.resolveType() instanceof Annotation) {
                    Annotation value = (Annotation)this.mofValueFrom(lhsExpr.resolveType());
                    if (assignment.getRightHandSide() instanceof NullLiteral && value != null) {
                        value.setValue((Object)this.factory.createNullLiteral());
                    }
                    context.getAnnotations().add(value);
                    continue;
                }
                if (context instanceof org.eclipse.edt.mof.egl.Part) {
                    if (context.getEClass().getEField(((Name)lhsExpr).getNameComponents()) == null) continue;
                    EField field = context.getEClass().getEField(((Name)lhsExpr).getNameComponents());
                    Object value = this.evaluateExpression(assignment.getRightHandSide());
                    context.eSet(field, value);
                    continue;
                }
                expr.accept(this);
                Assignment assign = (Assignment)this.stack.pop();
                org.eclipse.edt.mof.egl.Type type = null;
                if (context instanceof TypedElement) {
                    type = ((TypedElement)context).getType();
                }
                if (TypeUtils.isDynamicType(type)) {
                    DynamicAccess da = this.factory.createDynamicAccess();
                    this.setElementInformation(expr, (EObject)da);
                    LHSExpr newLHS = this.setAccessForDynamicAccess(da, (Expression)assign.getLHS());
                    if (context instanceof Expression) {
                        da.setExpression((Expression)context);
                    } else if (context instanceof Member) {
                        MemberName exp = this.factory.createMemberName();
                        exp.setId(((Member)context).getCaseSensitiveName());
                        exp.setMember((Member)context);
                        da.setExpression((Expression)exp);
                    }
                    assign.setLHS(newLHS);
                } else {
                    assign.setLHS(this.addQualifier(context, assign.getLHS()));
                }
                if (block == null) {
                    block = this.factory.createStatementBlock();
                }
                stmt = this.createAssignmentStatement(assign);
                this.setElementInformation(expr, (EObject)stmt);
                block.getStatements().add(stmt);
                continue;
            }
            if (expr instanceof SetValuesExpression && ((SetValuesExpression)expr).getExpression() instanceof AnnotationExpression) {
                Annotation annBinding;
                if (!(((AnnotationExpression)((SetValuesExpression)expr).getExpression()).resolveAnnotation() instanceof Annotation) || (annBinding = ((AnnotationExpression)((SetValuesExpression)expr).getExpression()).resolveAnnotation()) == null || this.isEMetadataObject(annBinding)) continue;
                Annotation value = (Annotation)this.evaluateExpression(expr);
                context.getAnnotations().add(value);
                continue;
            }
            expr.accept(this);
            Element result = (Element)this.stack.pop();
            if (block == null) {
                block = this.factory.createStatementBlock();
            }
            if (result instanceof StatementBlock) {
                for (Statement stmt2 : ((StatementBlock)result).getStatements()) {
                    if (stmt2 instanceof AssignmentStatement) {
                        Assignment assignExpr = ((AssignmentStatement)stmt2).getAssignment();
                        LHSExpr lhs = this.addQualifier(context, assignExpr.getLHS());
                        assignExpr.setLHS(lhs);
                    }
                    block.getStatements().add(stmt2);
                }
                continue;
            }
            if (result instanceof org.eclipse.edt.mof.egl.SetValuesExpression) {
                org.eclipse.edt.mof.egl.SetValuesExpression sve = (org.eclipse.edt.mof.egl.SetValuesExpression)result;
                for (Statement stmt3 : sve.getSettings().getStatements()) {
                    if (stmt3 instanceof AssignmentStatement) {
                        Assignment assignExpr = ((AssignmentStatement)stmt3).getAssignment();
                        org.eclipse.edt.mof.egl.Type type = null;
                        if (context instanceof TypedElement) {
                            type = ((TypedElement)context).getType();
                        }
                        if (TypeUtils.isDynamicType(type)) {
                            DynamicAccess da = this.factory.createDynamicAccess();
                            this.setElementInformation(expr, (EObject)da);
                            LHSExpr newLHS = this.setAccessForDynamicAccess(da, (Expression)assignExpr.getLHS());
                            if (context instanceof Expression) {
                                da.setExpression((Expression)context);
                            } else if (context instanceof Member) {
                                MemberName exp = this.factory.createMemberName();
                                exp.setId(((Member)context).getCaseSensitiveName());
                                exp.setMember((Member)context);
                                da.setExpression((Expression)exp);
                            }
                            assignExpr.setLHS(newLHS);
                        } else {
                            LHSExpr lhs = this.addQualifier(context, assignExpr.getLHS());
                            assignExpr.setLHS(lhs);
                        }
                    }
                    block.getStatements().add(stmt3);
                }
                continue;
            }
            ++arrayIndex;
            if (context instanceof Member) {
                qualifier = this.factory.createMemberName();
                ((MemberName)qualifier).setId(((Member)context).getCaseSensitiveName());
                ((MemberName)qualifier).setMember((Member)context);
            } else {
                qualifier = (Expression)context;
            }
            org.eclipse.edt.mof.egl.IntegerLiteral indexExpr = this.factory.createIntegerLiteral();
            indexExpr.setType((org.eclipse.edt.mof.egl.Type)IRUtils.getEGLPrimitiveType((String)"eglx.lang.EInt"));
            indexExpr.setValue(String.valueOf(arrayIndex));
            QualifiedFunctionInvocation func = this.factory.createQualifiedFunctionInvocation();
            this.setElementInformation(expr, (EObject)func);
            func.setQualifier(qualifier);
            func.setId("appendElement");
            func.getArguments().add((Expression)result);
            stmt = this.factory.createFunctionStatement();
            this.setElementInformation(expr, (EObject)stmt);
            stmt.setExpr((Expression)func);
            block.getStatements().add(stmt);
        }
        if (block != null && !(context instanceof org.eclipse.edt.mof.egl.Part) && context instanceof Field) {
            ((Field)context).setInitializerStatements(block);
        }
    }

    private Object evaluateExpression(Node expr) {
        Object value = null;
        if (expr instanceof ArrayLiteral) {
            value = new EList();
            for (org.eclipse.edt.compiler.core.ast.Expression ex : ((ArrayLiteral)expr).getExpressions()) {
                ((List)value).add(this.evaluateExpression(ex));
            }
        } else if (expr instanceof BooleanLiteral) {
            value = ((BooleanLiteral)expr).booleanValue() == Boolean.YES ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE;
        } else if (expr instanceof BytesLiteral) {
            value = ((BytesLiteral)expr).getValue();
        } else if (expr instanceof IntegerLiteral) {
            try {
                switch (((IntegerLiteral)expr).getLiteralKind()) {
                    case 14: {
                        value = Long.parseLong(((IntegerLiteral)expr).getValue());
                        break;
                    }
                    case 13: {
                        value = Short.parseShort(((IntegerLiteral)expr).getValue());
                        break;
                    }
                    default: {
                        value = Integer.parseInt(((IntegerLiteral)expr).getValue());
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (expr instanceof org.eclipse.edt.compiler.core.ast.StringLiteral) {
            value = ((org.eclipse.edt.compiler.core.ast.StringLiteral)expr).getValue();
        } else if (expr instanceof FloatLiteral) {
            value = Float.valueOf(Float.parseFloat(((FloatLiteral)expr).getValue()));
        } else if (expr instanceof AnnotationExpression) {
            org.eclipse.edt.mof.egl.Type typeBinding = ((AnnotationExpression)expr).resolveType();
            EClass annType = (EClass)this.mofTypeFor(typeBinding);
            if (annType != null) {
                value = annType.newInstance();
            }
        } else if (expr instanceof SetValuesExpression) {
            value = this.evaluateExpression(((SetValuesExpression)expr).getExpression());
            if (((SetValuesExpression)expr).getSettingsBlock() != null) {
                this.executeSettings(value, ((SetValuesExpression)expr).getSettingsBlock());
            }
        } else if (expr instanceof Name) {
            expr.accept(this);
            value = this.stack.pop();
        }
        return value;
    }

    private void executeSettings(Object context, SettingsBlock settings) {
        if (settings == null) {
            return;
        }
        for (Node setting : settings.getSettings()) {
            Object value;
            if (context instanceof List) {
                ((List)context).add(this.evaluateExpression(setting));
                continue;
            }
            if (!(context instanceof Annotation)) continue;
            EObject target = (EObject)context;
            if (setting instanceof org.eclipse.edt.compiler.core.ast.Assignment) {
                org.eclipse.edt.compiler.core.ast.Assignment assignment = (org.eclipse.edt.compiler.core.ast.Assignment)setting;
                Name nameExpr = (Name)assignment.getLeftHandSide();
                Object source = null;
                EField field = target.getEClass().getEField(nameExpr.getNameComponents());
                if (field == null) {
                    if (nameExpr.resolveType() == null) continue;
                    source = this.mofValueFrom(nameExpr.resolveType());
                    ((Element)target).getAnnotations().add((Annotation)source);
                    continue;
                }
                source = assignment.getRightHandSide() instanceof NullLiteral ? this.factory.createNullLiteral() : this.evaluateExpression(assignment.getRightHandSide());
                this.eSet(target, field, source);
                continue;
            }
            if (setting instanceof SetValuesExpression) {
                value = (Annotation)this.evaluateExpression(setting);
                ((Element)target).getAnnotations().add(value);
                continue;
            }
            value = this.evaluateExpression(setting);
            this.eSet(target, (EField)target.getEClass().getEFields().get(0), value);
        }
    }

    protected void setInitialValue(StructureItem node, EField field) {
        this.setInitialValue(node.getInitializer(), node.getSettingsBlock(), field);
    }

    protected void setInitialValue(ClassDataDeclaration node, EField field) {
        this.setInitialValue(node.getInitializer(), node.getSettingsBlockOpt(), field);
    }

    private void setInitialValue(org.eclipse.edt.compiler.core.ast.Expression initializer, SettingsBlock settings, EField field) {
        Object value = null;
        if (initializer != null) {
            if (initializer instanceof LiteralExpression && this.inAnnotationTypeContext && !this.inEMetadataTypeContext) {
                initializer.accept(this);
                value = this.stack.pop();
            } else {
                value = this.evaluateExpression(initializer);
            }
        } else if (settings != null && this.isInitializer(settings)) {
            EType type = field.getEType();
            value = type instanceof EClass ? ((EClass)type).newInstance() : new EList();
            this.executeSettings(value, settings);
        }
        field.setInitialValue(value);
    }

    private boolean isInitializer(SettingsBlock settings) {
        for (Node expr : settings.getSettings()) {
            if (expr instanceof org.eclipse.edt.compiler.core.ast.Assignment) {
                org.eclipse.edt.compiler.core.ast.Assignment assignment = (org.eclipse.edt.compiler.core.ast.Assignment)expr;
                Name nameExpr = (Name)assignment.getLeftHandSide();
                if (nameExpr.resolveType() instanceof Annotation) continue;
                return true;
            }
            if (expr instanceof SetValuesExpression) {
                return !(((SetValuesExpression)expr).getExpression() instanceof AnnotationExpression);
            }
            if (expr instanceof AnnotationExpression) continue;
            return true;
        }
        return false;
    }

    private void addInitializers(StructureItem node, Field field, Type type) {
        this.addInitializers(node.getInitializer(), node.getSettingsBlock(), field, type);
    }

    private void addInitializers(ClassDataDeclaration node, Field field, Type type) {
        this.addInitializers(node.getInitializer(), node.getSettingsBlockOpt(), field, type);
    }

    protected void addInitializers(org.eclipse.edt.compiler.core.ast.Expression initializer, SettingsBlock settingsBlock, Field field, Type type) {
        if (field.getType() == null) {
            return;
        }
        if (initializer != null) {
            if (settingsBlock != null) {
                this.processSettings((Element)field, settingsBlock);
            }
            if (field.getInitializerStatements() == null) {
                field.setInitializerStatements(this.factory.createStatementBlock());
            }
            this.setElementInformation(initializer, (EObject)field.getInitializerStatements());
            initializer.accept(this);
            Expression expr = (Expression)this.stack.pop();
            AssignmentStatement stmt = this.createAssignmentStatement(field, expr);
            this.setElementInformation(initializer, (EObject)stmt);
            field.getInitializerStatements().getStatements().add(stmt);
            field.setHasSetValuesBlock(java.lang.Boolean.valueOf(true));
        } else if (settingsBlock != null) {
            this.processSettings((Element)field, settingsBlock);
        }
    }

    private AssignmentStatement createAssignmentStatement(Field field, Expression rhs) {
        Assignment assign = this.factory.createAssignment();
        assign.setRHS(rhs);
        MemberName nameExpr = this.factory.createMemberName();
        nameExpr.setMember((Member)field);
        nameExpr.setId(field.getCaseSensitiveName());
        assign.setLHS((LHSExpr)nameExpr);
        return this.createAssignmentStatement(assign);
    }

    protected AssignmentStatement createAssignmentStatement(Assignment assign) {
        AssignmentStatement stmt = this.factory.createAssignmentStatement();
        stmt.setExpr((Expression)assign);
        return stmt;
    }

    protected LHSExpr addQualifier(Element context, LHSExpr expr) {
        if (context instanceof Member) {
            return this.addQualifier((Member)context, expr);
        }
        if (context instanceof Expression) {
            if (expr instanceof InvalidName) {
                return expr;
            }
            return expr.addQualifier((Expression)context);
        }
        throw new IllegalArgumentException("Qualifier " + context.toString() + " must be a Member or Expression");
    }

    private LHSExpr addQualifier(Member context, LHSExpr lhsExpr) {
        MemberName qualifier = this.createMemberName(context);
        return lhsExpr.addQualifier((Expression)qualifier);
    }

    private MemberName createMemberName(Member context) {
        MemberName mbrName = this.factory.createMemberName();
        mbrName.setId(context.getCaseSensitiveName());
        mbrName.setMember(context);
        return mbrName;
    }

    private ElementGenerator getElementGenerator(Node node) {
        ElementGenerator generator = this.context.getCompiler().getElementGeneratorFor(node);
        if (generator != null) {
            generator.setCurrentPart(this.currentPart);
            generator.setCurrentBindingLevelPart(this.currentBindingLevelPart);
            generator.setCurrentFunction(this.currentFunction);
            generator.setContext(this.context);
            generator.setEnvironment(this.env);
            return generator;
        }
        return null;
    }
}

