/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Parameter;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofBase;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EMemberContainer;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EMetadataType;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ProxyEClass;

abstract class Egl2MofPart
extends Egl2MofBase {
    public MofSerializable currentPart;
    public org.eclipse.edt.mof.egl.Part currentBindingLevelPart;
    protected FunctionMember currentFunction;
    public List<Node> functionsToProcess = new ArrayList<Node>();

    Egl2MofPart(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Record node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Enumeration node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        if (!(part instanceof org.eclipse.edt.mof.egl.Part)) {
            this.setElementInformation(node, (EObject)part);
        }
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ExternalType node) {
        org.eclipse.edt.mof.egl.Part partBinding = (org.eclipse.edt.mof.egl.Part)node.getName().resolveType();
        this.setFlags(partBinding);
        MofSerializable part = this.handleVisitPart(node);
        this.handleContents(node, (EObject)part);
        if (part instanceof EClass) {
            ArrayList<EClass> superTypes = new ArrayList<EClass>();
            for (Name name : node.getExtendedTypes()) {
                org.eclipse.edt.mof.egl.Part superType = (org.eclipse.edt.mof.egl.Part)name.resolveType();
                if (superType == null) continue;
                EType proxiedType = BindingUtil.getETypeFromProxy((Element)superType);
                EClass superTypeClass = proxiedType instanceof EClass ? (EClass)proxiedType : (EClass)this.mofTypeFor((Type)superType);
                this.fixSuperTypes(superTypeClass);
                superTypes.add(superTypeClass);
            }
            ((EClass)part).addSuperTypes(superTypes);
        } else {
            for (Name name : node.getExtendedTypes()) {
                org.eclipse.edt.mof.egl.Part superType = (org.eclipse.edt.mof.egl.Part)name.resolveType();
                if (!(superType instanceof ExternalType)) continue;
                ((EGLClass)part).getSuperTypes().add((EGLClass)this.mofTypeFor((Type)superType));
            }
        }
        this.handleEndVisitPart(node, part);
        this.stack.push(part);
        return false;
    }

    private void fixSuperTypes(EClass eclass) {
        List superTypes = eclass.getSuperTypes();
        int i = 0;
        while (i < superTypes.size()) {
            EObject obj = this.getMofSerializable(((EClass)superTypes.get(i)).getMofSerializationKey());
            if (obj instanceof EClass) {
                if (obj == superTypes.get(i)) {
                    this.fixSuperTypes((EClass)obj);
                } else {
                    superTypes.set(i, (EClass)obj);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean visit(Program node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Interface interfaceNode) {
        this.setFlags((org.eclipse.edt.mof.egl.Part)interfaceNode.getName().resolveType());
        Interface part = (Interface)this.handleVisitPart(interfaceNode);
        this.handleContents(interfaceNode, (EObject)part);
        this.addInterfaces((StructPart)part, interfaceNode.getExtendedTypes());
        this.handleEndVisitPart(interfaceNode, (MofSerializable)part);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Handler handler) {
        org.eclipse.edt.mof.egl.Handler part = (org.eclipse.edt.mof.egl.Handler)this.defaultHandleVisitPart(handler);
        this.addInterfaces((StructPart)part, handler.getImplementedInterfaces());
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Class eglClass) {
        EObject obj;
        Type tb;
        EGLClass part = (EGLClass)this.defaultHandleVisitPart(eglClass);
        if (eglClass.getExtends() != null && (tb = eglClass.getExtends().resolveType()) instanceof EGLClass && (obj = this.mofTypeFor(tb)) instanceof StructPart) {
            part.getSuperTypes().clear();
            part.getSuperTypes().add((StructPart)obj);
        }
        this.addInterfaces((StructPart)part, eglClass.getImplementedInterfaces());
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Library node) {
        MofSerializable part = this.defaultHandleVisitPart(node);
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(Delegate delegate) {
        org.eclipse.edt.mof.egl.Delegate part = this.factory.createDelegate();
        org.eclipse.edt.mof.egl.Delegate binding = (org.eclipse.edt.mof.egl.Delegate)delegate.getName().resolveType();
        part.setName(binding.getCaseSensitiveName());
        part.setPackageName(binding.getCaseSensitivePackageName());
        if (binding.getReturnType() != null) {
            part.setReturnType((Type)this.mofTypeFor(binding.getReturnType()));
            part.setIsNullable(binding.isNullable());
        } else {
            part.setIsNullable(Boolean.valueOf(false));
        }
        this.partProcessingStack.push(part);
        for (Parameter parm : delegate.getParameters()) {
            parm.accept(this);
            part.addMember((Member)((FunctionParameter)this.stack.pop()));
        }
        this.setElementInformation(delegate, (EObject)part);
        this.partProcessingStack.pop();
        if (delegate.isPrivate()) {
            part.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        this.stack.push(part);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Service service) {
        Service part = (Service)this.defaultHandleVisitPart(service);
        this.addInterfaces((StructPart)part, service.getImplementedInterfaces());
        this.stack.push(part);
        return false;
    }

    private void addInterfaces(StructPart part, List<Name> implemented) {
        for (Name name : implemented) {
            EObject obj;
            Type intfce = name.resolveType();
            if (!(intfce instanceof Interface) || !((obj = this.mofTypeFor(intfce)) instanceof StructPart)) continue;
            part.getSuperTypes().add((StructPart)intfce);
        }
    }

    @Override
    public boolean visit(UseStatement stmt) {
        for (Name name : stmt.getNames()) {
            Type partBinding = name.resolveType();
            if (partBinding == null) continue;
            org.eclipse.edt.mof.egl.Part part = (org.eclipse.edt.mof.egl.Part)this.mofTypeFor(partBinding);
            ((LogicAndDataPart)this.currentPart).getUsedParts().add(part);
        }
        this.stack.push(null);
        return false;
    }

    private MofSerializable defaultHandleVisitPart(Part node) {
        this.setFlags((org.eclipse.edt.mof.egl.Part)node.getName().resolveType());
        MofSerializable part = this.handleVisitPart(node);
        this.handleContents(node, (EObject)part);
        this.handleEndVisitPart(node, part);
        return part;
    }

    private void setFlags(org.eclipse.edt.mof.egl.Part partBinding) {
        this.inMofProxyContext = this.isMofProxy(partBinding);
        this.inEMetadataTypeContext = this.isEMetadataType((Type)partBinding);
        this.inAnnotationTypeContext = partBinding instanceof AnnotationType && !this.inEMetadataTypeContext;
        this.inMofContext = this.inAnnotationTypeContext || this.isMofReflectType(partBinding) || this.inEMetadataTypeContext;
    }

    private MofSerializable handleVisitPart(Part node) {
        org.eclipse.edt.mof.egl.Part partBinding = (org.eclipse.edt.mof.egl.Part)node.getName().resolveType();
        EClass typeClass = (EClass)this.getMofSerializable(this.mofPartTypeSignatureFor(node));
        MofSerializable eObj = (MofSerializable)typeClass.newInstance();
        this.partProcessingStack.push(eObj);
        eObj.eSet("name", (Object)partBinding.getCaseSensitiveName());
        eObj.eSet("packageName", (Object)partBinding.getCaseSensitivePackageName());
        if (!this.inMofProxyContext) {
            if (partBinding instanceof AnnotationType) {
                this.setReflectTypeValues((EObject)eObj, (AnnotationType)partBinding);
            } else {
                this.setReflectTypeValues((EObject)eObj, (Annotation)partBinding.getStereotype());
            }
        }
        this.env.save(partBinding.getMofSerializationKey(), (EObject)eObj, false);
        if (!partBinding.getMofSerializationKey().equals(eObj.getMofSerializationKey())) {
            this.env.save(eObj.getMofSerializationKey(), (EObject)eObj, false);
        }
        if (!this.inMofContext) {
            this.eObjects.put(partBinding, eObj);
            this.currentPart = eObj;
            this.currentBindingLevelPart = (org.eclipse.edt.mof.egl.Part)node.getName().resolveType();
        }
        return eObj;
    }

    private void createInitializerStatements(Part astPart, StructPart structPart) {
        final Egl2MofPart converter = this;
        final ArrayList statements = new ArrayList();
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                for (Node node : settingsBlock.getSettings()) {
                    node.accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(org.eclipse.edt.compiler.core.ast.Assignment assignment) {
                if (assignment.resolveBinding() == null && assignment.getLeftHandSide().resolveType() != null) {
                    assignment.accept(converter);
                    Assignment assign = (Assignment)Egl2MofPart.this.stack.pop();
                    AssignmentStatement stmt = Egl2MofPart.this.factory.createAssignmentStatement();
                    stmt.setExpr((Expression)assign);
                    Egl2MofPart.this.setElementInformation(assignment, (EObject)stmt);
                    statements.add(stmt);
                }
                return false;
            }
        };
        for (Node node : astPart.getContents()) {
            node.accept(visitor);
        }
        if (!statements.isEmpty()) {
            StatementBlock block = this.factory.createStatementBlock();
            structPart.setInitializerStatements(block);
            for (Statement stmt : statements) {
                block.getStatements().add(stmt);
            }
        }
    }

    private void handleEndVisitPart(Part astPart, MofSerializable mofPart) {
        MofSerializable part = (MofSerializable)this.partProcessingStack.peek();
        org.eclipse.edt.mof.egl.Part partBinding = (org.eclipse.edt.mof.egl.Part)astPart.getName().resolveType();
        if (mofPart instanceof EClass) {
            this.createAnnotations(partBinding, (EClass)mofPart);
            this.setElementInformation(astPart, (EObject)((EClass)mofPart));
            if (mofPart instanceof AnnotationType && astPart.isPrivate()) {
                ((AnnotationType)mofPart).setAccessKind(AccessKind.ACC_PRIVATE);
            }
        } else if (mofPart instanceof org.eclipse.edt.mof.egl.Part) {
            if (astPart.isPrivate()) {
                ((org.eclipse.edt.mof.egl.Part)mofPart).setAccessKind(AccessKind.ACC_PRIVATE);
            }
            if (astPart.isAbstract() && mofPart instanceof EGLClass) {
                ((EGLClass)mofPart).setIsAbstract(Boolean.valueOf(true));
            }
            this.createAnnotations(partBinding, (org.eclipse.edt.mof.egl.Part)mofPart);
            if (mofPart instanceof StructPart) {
                this.setDefaultSuperType((StructPart)mofPart);
            }
            this.setElementInformation(astPart, (EObject)((org.eclipse.edt.mof.egl.Part)mofPart));
            if (mofPart instanceof StructPart) {
                this.createInitializerStatements(astPart, (StructPart)mofPart);
            }
        }
        for (Node node : this.functionsToProcess) {
            List<org.eclipse.edt.compiler.core.ast.Statement> stmts;
            Object binding;
            if (node instanceof NestedFunction) {
                binding = ((NestedFunction)node).getName().resolveElement();
                stmts = ((NestedFunction)node).getStmts();
            } else {
                binding = ((Constructor)node).getBinding();
                stmts = ((Constructor)node).getStmts();
            }
            FunctionMember irFunc = (FunctionMember)this.getEObjectFor(binding);
            this.setCurrentFunctionMember(irFunc);
            for (org.eclipse.edt.compiler.core.ast.Statement stmt : stmts) {
                stmt.accept(this);
                Statement irStmt = (Statement)this.stack.pop();
                irFunc.getStatements().add(irStmt);
            }
            this.setCurrentFunctionMember(null);
        }
        if (part instanceof LogicAndDataPart) {
            IRUtils.markOverloadedFunctions((LogicAndDataPart)((LogicAndDataPart)part));
        }
        if (this.inMofProxyContext) {
            Stereotype stereotype = partBinding.getStereotype();
            EMetadataObject metadata = (EMetadataObject)this.mofValueFrom((Annotation)stereotype);
            ((EClass)mofPart).getMetadataList().add(metadata);
        }
        for (Map.Entry entry : this.proxies.entrySet()) {
            EObject real = (EObject)this.eObjects.get(entry.getKey());
            this.updateProxyReferences(entry.getKey(), real);
        }
        this.partProcessingStack.pop();
    }

    private void handleContents(Part part, EObject container) {
        for (Node n : part.getContents()) {
            n.accept(this);
            Object obj = this.stack.pop();
            if (obj instanceof List) {
                for (EObject eobj : (List)obj) {
                    this.handleMember(eobj, container);
                }
                continue;
            }
            this.handleMember((EObject)obj, container);
        }
    }

    private void handleMember(EObject mofObj, EObject container) {
        if (mofObj != null) {
            if (this.inMofContext) {
                ((EMemberContainer)container).addMember((EMember)mofObj);
                if (mofObj instanceof EField && (container instanceof AnnotationType || container instanceof EMetadataType)) {
                    ((EField)mofObj).setContainment(true);
                }
            } else {
                ((Container)container).addMember((Member)mofObj);
            }
        }
    }

    private MofSerializable resolveProxy(ProxyEClass proxy) {
        String key = proxy.getMofSerializationKey();
        EObject result = this.getMofSerializable(key);
        if (result instanceof MofSerializable) {
            return (MofSerializable)result;
        }
        if (!this.inMofContext && key.indexOf(":") < 0 && (result = this.getMofSerializable(key = "egl:" + key)) instanceof MofSerializable) {
            return (MofSerializable)result;
        }
        return null;
    }

    private void setDefaultSuperType(StructPart part) {
        if (part.getSuperTypes().isEmpty()) {
            Stereotype stereotype = part.getStereotype();
            StructPart superType = null;
            if (stereotype != null) {
                MofSerializable mofST = ((StereotypeType)stereotype.getEClass()).getDefaultSuperType();
                if (mofST instanceof ProxyEClass) {
                    mofST = this.resolveProxy((ProxyEClass)mofST);
                }
                if (mofST instanceof StructPart && !mofST.getMofSerializationKey().equalsIgnoreCase(part.getMofSerializationKey())) {
                    superType = (StructPart)mofST;
                }
            }
            if (superType == null) {
                String typeSignature = "egl:eglx.lang.EAny";
                if (part instanceof Record) {
                    typeSignature = "egl:eglx.lang.AnyRecord";
                } else if (part instanceof StructPart && !part.equals(TypeUtils.Type_ANY).booleanValue()) {
                    typeSignature = "egl:eglx.lang.AnyStruct";
                } else if (part instanceof AnnotationType) {
                    typeSignature = "org.eclipse.edt.mof.egl.Annotation";
                } else if (part instanceof StereotypeType) {
                    typeSignature = "org.eclipse.edt.mof.egl.Stereotype";
                }
                superType = (StructPart)this.getMofSerializable(typeSignature);
            }
            if (superType != null && !superType.getMofSerializationKey().equalsIgnoreCase(part.getMofSerializationKey())) {
                part.getSuperTypes().add(superType);
            }
        }
    }

    private void setCurrentFunctionMember(FunctionMember function) {
        this.currentFunction = function;
    }

    protected FunctionMember getCurrentFunctionMember() {
        return this.currentFunction;
    }

    @Override
    protected void setElementInformation(Node node, EObject obj) {
        Statement stmt;
        if (obj instanceof Statement && (stmt = (Statement)obj).getContainer() == null && this.currentPart instanceof Container) {
            stmt.setContainer((Container)this.currentPart);
        }
        super.setElementInformation(node, obj);
    }
}

