/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.Stack;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GotoStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesStatement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofMember;
import org.eclipse.edt.compiler.internal.egl2mof.ElementGenerator;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.CallStatement;
import org.eclipse.edt.mof.egl.CloseStatement;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.ContinueStatement;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.DeleteStatement;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ExceptionBlock;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.ForEachStatement;
import org.eclipse.edt.mof.egl.FunctionStatement;
import org.eclipse.edt.mof.egl.GetByPositionKind;
import org.eclipse.edt.mof.egl.GetByPositionStatement;
import org.eclipse.edt.mof.egl.GoToStatement;
import org.eclipse.edt.mof.egl.IOStatement;
import org.eclipse.edt.mof.egl.IfStatement;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.OpenStatement;
import org.eclipse.edt.mof.egl.Parameter;
import org.eclipse.edt.mof.egl.PrepareStatement;
import org.eclipse.edt.mof.egl.ReplaceStatement;
import org.eclipse.edt.mof.egl.SetStatement;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.ThrowStatement;
import org.eclipse.edt.mof.egl.TryStatement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.WhileStatement;
import org.eclipse.edt.mof.serialization.IEnvironment;

abstract class Egl2MofStatement
extends Egl2MofMember {
    Stack<org.eclipse.edt.mof.egl.LabelStatement> caseLabelStack = new Stack();
    int caseLabelCounter = 0;

    Egl2MofStatement(IEnvironment env) {
        super(env);
    }

    protected void setElementInformation(Node node, Statement stmt) {
        stmt.setContainer((Container)this.getCurrentFunctionMember());
        super.setElementInformation(node, (EObject)stmt);
    }

    @Override
    public boolean visit(AddStatement node) {
        org.eclipse.edt.mof.egl.AddStatement stmt;
        ElementGenerator gen = this.getElementGenerator(node);
        if (gen != null && (stmt = (org.eclipse.edt.mof.egl.AddStatement)gen.generate(node, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)node, (Statement)stmt);
            this.commonIOVisit(node, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.CloseStatement node) {
        CloseStatement stmt;
        ElementGenerator gen = this.getElementGenerator(node);
        if (gen != null && (stmt = (CloseStatement)gen.generate(node, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)node, (Statement)stmt);
            this.commonIOVisit(node, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(AssignmentStatement assignmentStatement) {
        org.eclipse.edt.mof.egl.AssignmentStatement stmt = this.factory.createAssignmentStatement();
        assignmentStatement.getAssignment().accept(this);
        stmt.setExpr((Expression)this.stack.pop());
        this.setElementInformation((Node)assignmentStatement, (Statement)stmt);
        this.stack.push(stmt);
        return false;
    }

    @Override
    public boolean visit(SetValuesStatement setValuesStatement) {
        org.eclipse.edt.mof.egl.SetValuesStatement stmt = this.factory.createSetValuesStatement();
        setValuesStatement.getSetValuesExpression().accept(this);
        stmt.setExpr((Expression)this.stack.pop());
        this.setElementInformation((Node)setValuesStatement, (Statement)stmt);
        this.stack.push(stmt);
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration decl) {
        LocalVariableDeclarationStatement stmt = this.factory.createLocalVariableDeclarationStatement();
        this.stack.push(stmt);
        DeclarationExpression expr = this.factory.createDeclarationExpression();
        for (Name name : decl.getNames()) {
            if (name.resolveMember() == null) continue;
            Member binding = name.resolveMember();
            Object field = binding instanceof ConstantField ? this.factory.createConstantField() : this.factory.createField();
            field.setName(binding.getCaseSensitiveName());
            EObject objType = this.mofTypeFor(binding.getType());
            if (objType instanceof Type) {
                field.setType((Type)this.mofTypeFor(binding.getType()));
            }
            field.setIsNullable(binding.isNullable());
            field.setContainer((Container)this.getCurrentFunctionMember());
            this.addInitializers(decl.getInitializer(), decl.getSettingsBlockOpt(), (Field)field, decl.getType());
            expr.getFields().add(field);
            this.setElementInformation((Node)name, (EObject)field);
            this.eObjects.put(binding, field);
        }
        this.setElementInformation((Node)decl, (EObject)expr);
        this.setElementInformation((Node)decl, (Statement)stmt);
        stmt.setExpression(expr);
        return false;
    }

    @Override
    public boolean visit(ReturnStatement stmt) {
        org.eclipse.edt.mof.egl.ReturnStatement irStmt = this.factory.createReturnStatement();
        this.stack.push(irStmt);
        if (stmt.getParenthesizedExprOpt() != null) {
            stmt.getParenthesizedExprOpt().accept(this);
            irStmt.setExpression((Expression)this.stack.pop());
        }
        this.setElementInformation((Node)stmt, (Statement)irStmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.CallStatement callStatement) {
        CallStatement stmt;
        ElementGenerator gen = this.getElementGenerator(callStatement);
        if (gen != null && (stmt = (CallStatement)gen.generate(callStatement, this.eObjects)) != null) {
            callStatement.getInvocationTarget().accept(this);
            stmt.setInvocationTarget((Expression)this.stack.pop());
            if (callStatement.hasArguments()) {
                for (Node node : callStatement.getArguments()) {
                    node.accept(this);
                    stmt.getArguments().add((Expression)this.stack.pop());
                }
            }
            if (callStatement.getUsing() != null) {
                callStatement.getUsing().accept(this);
                stmt.setUsing((Expression)this.stack.pop());
            }
            if (callStatement.getCallSynchronizationValues() != null) {
                if (callStatement.getCallSynchronizationValues().getReturnTo() != null) {
                    callStatement.getCallSynchronizationValues().getReturnTo().accept(this);
                    stmt.setCallback((Expression)this.stack.pop());
                }
                if (callStatement.getCallSynchronizationValues().getOnException() != null) {
                    callStatement.getCallSynchronizationValues().getOnException().accept(this);
                    stmt.setErrorCallback((Expression)this.stack.pop());
                }
                if (callStatement.getCallSynchronizationValues().getReturns() != null) {
                    callStatement.getCallSynchronizationValues().getReturns().accept(this);
                    stmt.setReturns((LHSExpr)this.stack.pop());
                }
            }
            this.setElementInformation((Node)callStatement, (Statement)stmt);
            this.stack.push(stmt);
            if (callStatement.hasSettingsBlock()) {
                this.processSettings((Element)stmt, callStatement.getSettingsBlock());
            }
        }
        return false;
    }

    private Expression addWhenCriterion(Expression criterion, Expression condition) {
        if (condition instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)condition;
            Expression expr = this.addWhenCriterion(criterion, binExp.getLHS());
            binExp.setLHS(expr);
            expr = this.addWhenCriterion(criterion, binExp.getRHS());
            binExp.setRHS(expr);
            return condition;
        }
        BinaryExpression binExp = this.factory.createBinaryExpression();
        binExp.setLHS(criterion);
        binExp.setRHS(condition);
        binExp.setOperator("==");
        return binExp;
    }

    @Override
    public boolean visit(CaseStatement caseStatement) {
        IfStatement stmt = null;
        Expression criterion = null;
        StatementBlock block = this.factory.createStatementBlock();
        org.eclipse.edt.mof.egl.LabelStatement label = this.factory.createLabelStatement();
        label.setLabel("eze_CaseLabel_" + this.caseLabelCounter);
        ++this.caseLabelCounter;
        this.caseLabelStack.push(label);
        this.setElementInformation((Node)caseStatement, (Statement)label);
        block.getStatements().add(label);
        if (caseStatement.hasCriterion()) {
            caseStatement.getCriterion().accept(this);
            criterion = (Expression)this.stack.pop();
        }
        IfStatement current = null;
        for (Node node : caseStatement.getWhenClauses()) {
            node.accept(this);
            IfStatement when = (IfStatement)this.stack.pop();
            if (criterion != null) {
                when.setCondition(this.addWhenCriterion(criterion, when.getCondition()));
            }
            if (stmt == null) {
                stmt = current = when;
                continue;
            }
            current.setFalseBranch((Statement)when);
            current = when;
        }
        if (caseStatement.getDefaultClause() != null) {
            caseStatement.getDefaultClause().accept(this);
            current.setFalseBranch((Statement)this.stack.pop());
        }
        block.getStatements().add(stmt);
        this.stack.push(block);
        this.setElementInformation((Node)caseStatement, (Statement)stmt);
        return false;
    }

    @Override
    public void endVisit(CaseStatement caseStatement) {
        this.caseLabelStack.pop();
    }

    @Override
    public boolean visit(OtherwiseClause otherwiseClause) {
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)otherwiseClause, (Statement)block);
        this.stack.push(block);
        for (Node node : otherwiseClause.getStatements()) {
            node.accept(this);
            Statement stmt = (Statement)this.stack.pop();
            if (stmt == null) continue;
            block.getStatements().add(stmt);
        }
        return false;
    }

    @Override
    public boolean visit(WhenClause whenClause) {
        IfStatement clause = this.factory.createIfStatement();
        Expression prevCond = null;
        for (Node node : whenClause.getExpr_plus()) {
            node.accept(this);
            Expression expr = (Expression)this.stack.pop();
            if (prevCond != null) {
                BinaryExpression binExp = this.factory.createBinaryExpression();
                binExp.setLHS(prevCond);
                binExp.setRHS(expr);
                binExp.setOperator("||");
                expr = binExp;
            }
            prevCond = expr;
            clause.setCondition(expr);
        }
        StatementBlock statementBlock = this.factory.createStatementBlock();
        for (Node node : whenClause.getStmts()) {
            node.accept(this);
            Statement stmt = (Statement)this.stack.pop();
            if (stmt == null) continue;
            statementBlock.getStatements().add(stmt);
        }
        clause.setTrueBranch((Statement)statementBlock);
        this.stack.push(clause);
        this.setElementInformation((Node)whenClause, (Statement)clause);
        this.setElementInformation((Node)whenClause, (Statement)statementBlock);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ContinueStatement node) {
        ContinueStatement stmt = this.factory.createContinueStatement();
        stmt.setLabel(stmt.getLabel());
        if (node.isContinueFor()) {
            stmt.setContinueType(Integer.valueOf(1));
        } else if (node.isContinueForEach()) {
            stmt.setContinueType(Integer.valueOf(2));
        } else if (node.isContinueWhile()) {
            stmt.setContinueType(Integer.valueOf(4));
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)node, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.DeleteStatement deleteStatement) {
        DeleteStatement stmt;
        ElementGenerator gen = this.getElementGenerator(deleteStatement);
        if (gen != null && (stmt = (DeleteStatement)gen.generate(deleteStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)deleteStatement, (Statement)stmt);
            this.commonIOVisit(deleteStatement, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(ExecuteStatement executeStatement) {
        org.eclipse.edt.mof.egl.ExecuteStatement stmt;
        ElementGenerator gen = this.getElementGenerator(executeStatement);
        if (gen != null && (stmt = (org.eclipse.edt.mof.egl.ExecuteStatement)gen.generate(executeStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)executeStatement, (Statement)stmt);
            this.commonIOVisit(executeStatement, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(ExitStatement node) {
        org.eclipse.edt.mof.egl.ExitStatement ext = this.factory.createExitStatement();
        ext.setLabel(node.getLabel());
        if (node.isExitCase()) {
            if (this.caseLabelStack.isEmpty()) {
                ext.setExitStatementType(Integer.valueOf(1));
            } else {
                ext.setLabel(this.caseLabelStack.peek().getLabel());
            }
        } else if (node.isExitFor()) {
            ext.setExitStatementType(Integer.valueOf(3));
        } else if (node.isExitForEach()) {
            ext.setExitStatementType(Integer.valueOf(5));
        } else if (node.isExitIf()) {
            ext.setExitStatementType(Integer.valueOf(2));
        } else if (node.isExitProgram()) {
            ext.setExitStatementType(Integer.valueOf(7));
        } else if (node.isExitRunUnit()) {
            ext.setExitStatementType(Integer.valueOf(9));
        } else if (node.isExitStack()) {
            ext.setExitStatementType(Integer.valueOf(9));
        } else if (node.isExitWhile()) {
            ext.setExitStatementType(Integer.valueOf(4));
        }
        if (node.getReturnCode() != null) {
            node.getReturnCode().accept(this);
            ext.setReturnExpr((Expression)this.stack.pop());
        }
        if (node.hasSettingsBlock()) {
            this.processSettings((Element)ext, node.getSettingsBlock());
        }
        this.stack.push(ext);
        this.setElementInformation((Node)node, (Statement)ext);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ForEachStatement forEachStatement) {
        ForEachStatement stmt;
        ElementGenerator gen = this.getElementGenerator(forEachStatement);
        if (gen != null && (stmt = (ForEachStatement)gen.generate(forEachStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)forEachStatement, (Statement)stmt);
            if (forEachStatement.hasVariableDeclaration()) {
                DeclarationExpression decl = this.factory.createDeclarationExpression();
                Field field = this.factory.createField();
                field.setName(forEachStatement.getVariableDeclarationName().getCanonicalName());
                Type type = forEachStatement.getVariableDeclarationType().resolveType();
                field.setType((Type)this.mofTypeFor(type));
                field.setIsNullable(forEachStatement.isNullable());
                decl.getFields().add(field);
                this.eObjects.put(forEachStatement.getVariableDeclarationName().resolveMember(), field);
                stmt.setDeclarationExpression(decl);
                this.setElementInformation((Node)forEachStatement.getVariableDeclarationName(), (EObject)field);
                this.setElementInformation((Node)forEachStatement.getVariableDeclarationName(), (EObject)decl);
            }
            forEachStatement.getResultSet().accept(this);
            stmt.setDataSource((Expression)this.stack.pop());
            StatementBlock block = this.factory.createStatementBlock();
            stmt.setBody((Statement)block);
            for (Node nodeStmt : forEachStatement.getStmts()) {
                nodeStmt.accept(this);
                Statement currStmt = (Statement)this.stack.pop();
                if (currStmt == null) continue;
                block.getStatements().add(currStmt);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        org.eclipse.edt.mof.egl.ForStatement stmt = this.factory.createForStatement();
        if (forStatement.getCounterVariable() == null) {
            DeclarationExpression decl = this.factory.createDeclarationExpression();
            Field field = this.factory.createField();
            field.setName(forStatement.getVariableDeclarationName().getCanonicalName());
            Type type = forStatement.getVariableDeclarationType().resolveType();
            field.setType((Type)this.mofTypeFor(type));
            decl.getFields().add(field);
            this.eObjects.put(forStatement.getVariableDeclarationName().resolveMember(), field);
            stmt.setDeclarationExpression(decl);
            this.setElementInformation((Node)forStatement.getVariableDeclarationName(), (EObject)field);
            this.setElementInformation((Node)forStatement.getVariableDeclarationName(), (EObject)decl);
        } else {
            forStatement.getCounterVariable().accept(this);
            stmt.setCounterVariable((Expression)this.stack.pop());
        }
        if (forStatement.getDeltaExpression() != null) {
            forStatement.getDeltaExpression().accept(this);
            stmt.setDeltaExpression((Expression)this.stack.pop());
            stmt.setIsIncrement(Boolean.valueOf(forStatement.hasPositiveDelta()));
        }
        if (forStatement.getFromIndex() != null) {
            forStatement.getFromIndex().accept(this);
            stmt.setFromExpression((Expression)this.stack.pop());
        }
        if (forStatement.getEndIndex() != null) {
            forStatement.getEndIndex().accept(this);
            stmt.setToExpression((Expression)this.stack.pop());
        }
        StatementBlock block = this.factory.createStatementBlock();
        for (Node node : forStatement.getStmts()) {
            node.accept(this);
            Statement currStmt = (Statement)this.stack.pop();
            if (currStmt == null) continue;
            block.getStatements().add(currStmt);
        }
        stmt.setBody((Statement)block);
        this.stack.push(stmt);
        this.setElementInformation((Node)forStatement, (Statement)stmt);
        this.setElementInformation((Node)forStatement, (Statement)block);
        return false;
    }

    @Override
    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        FunctionStatement stmt = this.factory.createFunctionStatement();
        functionInvocationStatement.getFunctionInvocation().accept(this);
        stmt.setExpr((Expression)this.stack.pop());
        this.stack.push(stmt);
        this.setElementInformation((Node)functionInvocationStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.GetByPositionStatement getByPositionStatement) {
        GetByPositionStatement stmt;
        ElementGenerator gen = this.getElementGenerator(getByPositionStatement);
        if (gen != null && (stmt = (GetByPositionStatement)gen.generate(getByPositionStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)getByPositionStatement, (Statement)stmt);
            this.commonIOVisit(getByPositionStatement, (IOStatement)stmt);
            stmt.setDirective(this.getDirective(getByPositionStatement));
            if (getByPositionStatement.hasPosition()) {
                getByPositionStatement.getPosition().accept(this);
                stmt.setPosition((Expression)this.stack.pop());
            }
        }
        return false;
    }

    @Override
    public boolean visit(GetByKeyStatement getByKeyStatement) {
        org.eclipse.edt.mof.egl.GetByKeyStatement stmt;
        ElementGenerator gen = this.getElementGenerator(getByKeyStatement);
        if (gen != null && (stmt = (org.eclipse.edt.mof.egl.GetByKeyStatement)gen.generate(getByKeyStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)getByKeyStatement, (Statement)stmt);
            this.commonIOVisit(getByKeyStatement, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(GotoStatement gotoStatement) {
        GoToStatement stmt = this.factory.createGoToStatement();
        stmt.setLabel(gotoStatement.getLabel());
        this.stack.push(stmt);
        this.setElementInformation((Node)gotoStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.IfStatement ifStatement) {
        Statement currStmt;
        IfStatement stmt = this.factory.createIfStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)ifStatement, (Statement)stmt);
        ifStatement.getCondition().accept(this);
        stmt.setCondition((Expression)this.stack.pop());
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)ifStatement, (Statement)block);
        stmt.setTrueBranch((Statement)block);
        for (Node node : ifStatement.getStmts()) {
            node.accept(this);
            currStmt = (Statement)this.stack.pop();
            if (currStmt == null) continue;
            block.getStatements().add(currStmt);
        }
        if (ifStatement.hasElse()) {
            block = this.factory.createStatementBlock();
            this.setElementInformation((Node)ifStatement, (Statement)block);
            stmt.setFalseBranch((Statement)block);
            for (Node node : ifStatement.getElse().getStmts()) {
                node.accept(this);
                currStmt = (Statement)this.stack.pop();
                if (currStmt == null) continue;
                block.getStatements().add(currStmt);
            }
        }
        return false;
    }

    @Override
    public boolean visit(LabelStatement labelStatement) {
        org.eclipse.edt.mof.egl.LabelStatement stmt = this.factory.createLabelStatement();
        stmt.setLabel(labelStatement.getLabel());
        this.stack.push(stmt);
        this.setElementInformation((Node)labelStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(MoveStatement moveStatement) {
        org.eclipse.edt.mof.egl.MoveStatement stmt = this.factory.createMoveStatement();
        moveStatement.getSource().accept(this);
        stmt.setSourceExpr((Expression)this.stack.pop());
        moveStatement.getTarget().accept(this);
        stmt.setTargetExpr((LHSExpr)this.stack.pop());
        if (moveStatement.getMoveModifierOpt() != null) {
            if (moveStatement.getMoveModifierOpt().isByName()) {
                stmt.setModifier(1);
            } else if (moveStatement.getMoveModifierOpt().isByPosition()) {
                stmt.setModifier(2);
            } else if (moveStatement.getMoveModifierOpt().isFor()) {
                stmt.setModifier(3);
                moveStatement.getMoveModifierOpt().getExpression().accept(this);
                stmt.setModifierExpr((Expression)this.stack.pop());
            } else if (moveStatement.getMoveModifierOpt().isForAll()) {
                stmt.setModifier(4);
            } else if (moveStatement.getMoveModifierOpt().isWithV60Compat()) {
                stmt.setModifier(5);
            }
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)moveStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.OpenStatement openStatement) {
        OpenStatement stmt;
        ElementGenerator gen = this.getElementGenerator(openStatement);
        if (gen != null && (stmt = (OpenStatement)gen.generate(openStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)openStatement, (Statement)stmt);
            this.commonIOVisit(openStatement, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.PrepareStatement prepareStatement) {
        PrepareStatement stmt;
        ElementGenerator gen = this.getElementGenerator(prepareStatement);
        if (gen != null && (stmt = (PrepareStatement)gen.generate(prepareStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)prepareStatement, (Statement)stmt);
            this.commonIOVisit(prepareStatement, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ReplaceStatement replaceStatement) {
        ReplaceStatement stmt;
        ElementGenerator gen = this.getElementGenerator(replaceStatement);
        if (gen != null && (stmt = (ReplaceStatement)gen.generate(replaceStatement, this.eObjects)) != null) {
            this.stack.push(stmt);
            this.setElementInformation((Node)replaceStatement, (Statement)stmt);
            this.commonIOVisit(replaceStatement, (IOStatement)stmt);
        }
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.SetStatement setStatement) {
        SetStatement stmt = this.factory.createSetStatement();
        for (Node node : setStatement.getSetTargets()) {
            node.accept(this);
            stmt.getTargets().add((Expression)this.stack.pop());
        }
        for (String state : setStatement.getStates()) {
            stmt.getStates().add(state);
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)setStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ThrowStatement throwStatement) {
        ThrowStatement stmt = this.factory.createThrowStatement();
        throwStatement.getExpression().accept(this);
        stmt.setException((Expression)this.stack.pop());
        this.stack.push(stmt);
        this.setElementInformation((Node)throwStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.TryStatement tryStatement) {
        TryStatement stmt = this.factory.createTryStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)tryStatement, (Statement)stmt);
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)tryStatement, (Statement)block);
        stmt.setTryBlock(block);
        for (Node node : tryStatement.getStmts()) {
            node.accept(this);
            Statement currStmt = (Statement)this.stack.pop();
            if (currStmt == null) continue;
            block.getStatements().add(currStmt);
        }
        for (Node node : tryStatement.getOnExceptionBlocks()) {
            node.accept(this);
            stmt.getExceptionBlocks().add((ExceptionBlock)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(OnExceptionBlock onExceptionBlock) {
        ExceptionBlock block = this.factory.createExceptionBlock();
        this.stack.push(block);
        this.setElementInformation((Node)onExceptionBlock, (Statement)block);
        if (onExceptionBlock.getExceptionName() != null) {
            Parameter ex = this.factory.createParameter();
            this.setElementInformation((Node)onExceptionBlock.getExceptionName(), (EObject)ex);
            ex.setName(onExceptionBlock.getExceptionName().getCaseSensitiveIdentifier());
            Type type = onExceptionBlock.getExceptionType().resolveType();
            ex.setType((Type)this.mofTypeFor(type));
            this.eObjects.put(onExceptionBlock.getExceptionName().resolveMember(), ex);
            block.setException(ex);
        }
        for (Node node : onExceptionBlock.getStmts()) {
            node.accept(this);
            Statement currStmt = (Statement)this.stack.pop();
            if (currStmt == null) continue;
            block.getStatements().add(currStmt);
        }
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.WhileStatement whileStatement) {
        WhileStatement stmt = this.factory.createWhileStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)whileStatement, (Statement)stmt);
        whileStatement.getExpr().accept(this);
        stmt.setCondition((Expression)this.stack.pop());
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)whileStatement, (Statement)block);
        stmt.setBody((Statement)block);
        for (Node node : whileStatement.getStmts()) {
            node.accept(this);
            Statement currStmt = (Statement)this.stack.pop();
            if (currStmt == null) continue;
            block.getStatements().add(currStmt);
        }
        return false;
    }

    private ElementGenerator getElementGenerator(Node node) {
        ElementGenerator generator = this.context.getCompiler().getElementGeneratorFor(node);
        if (generator != null) {
            generator.setCurrentPart(this.currentPart);
            generator.setCurrentBindingLevelPart(this.currentBindingLevelPart);
            generator.setCurrentFunction(this.currentFunction);
            generator.setContext(this.context);
            generator.setEnvironment(this.env);
            return generator;
        }
        return null;
    }

    private GetByPositionKind getDirective(org.eclipse.edt.compiler.core.ast.GetByPositionStatement node) {
        if (node.isAbsoluteDirection()) {
            return GetByPositionKind.ABSOLUTE;
        }
        if (node.isCurrentDirection()) {
            return GetByPositionKind.CURRENT;
        }
        if (node.isFirstDirection()) {
            return GetByPositionKind.FIRST;
        }
        if (node.isLastDirection()) {
            return GetByPositionKind.LAST;
        }
        if (node.isNextDirection()) {
            return GetByPositionKind.NEXT;
        }
        if (node.isPreviousDirection()) {
            return GetByPositionKind.PREVIOUS;
        }
        if (node.isRelativeDirection()) {
            return GetByPositionKind.RELATIVE;
        }
        return null;
    }

    private void commonIOVisit(org.eclipse.edt.compiler.core.ast.Statement node, final IOStatement stmt) {
        for (Node expr : node.getIOObjects()) {
            expr.accept(this);
            stmt.getTargets().add((Expression)this.stack.pop());
        }
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(IntoClause clause) {
                for (Node expr : clause.getExpressions()) {
                    expr.accept(Egl2MofStatement.this);
                    stmt.getTargets().add((Expression)Egl2MofStatement.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept(Egl2MofStatement.this);
                stmt.setDataSource((Expression)Egl2MofStatement.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(UsingClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expression : clause.getExpressions()) {
                    expression.accept(Egl2MofStatement.this);
                    stmt.getUsingExpressions().add((Expression)Egl2MofStatement.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept(Egl2MofStatement.this);
                    stmt.getUsingKeyExpressions().add((Expression)Egl2MofStatement.this.stack.pop());
                }
                return false;
            }
        });
    }
}

