/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.io;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.io.DefaultZipFileIOBufferReader;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class ZipFileBuildPathEntry {
    private DefaultZipFileIOBufferReader reader = null;
    private Map<String, Map<String, String>> partNamesByPackage = new HashMap<String, Map<String, String>>();
    private Map<String, String> partNamesWithoutPackage = new HashMap<String, String>();
    private String path = null;

    public ZipFileBuildPathEntry(String path) {
        this.path = path;
        this.reader = new DefaultZipFileIOBufferReader(path);
    }

    public void clear() {
        this.reader = null;
        this.partNamesByPackage.clear();
        this.partNamesWithoutPackage.clear();
    }

    public boolean hasPackage(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return false;
        }
        return this.partNamesByPackage.get(packageName) != null;
    }

    protected String getEntry(String packageName, String partName) {
        String entry = "";
        if (packageName == null || packageName.length() == 0) {
            entry = this.partNamesWithoutPackage.get(partName);
        } else {
            Map<String, String> partpackage = this.partNamesByPackage.get(packageName);
            if (partpackage != null) {
                entry = partpackage.get(partName);
            }
        }
        return entry;
    }

    protected String getPackageName(String packagename) {
        return this.getPackageName(packagename, true);
    }

    protected String getPackageName(String packagename, boolean removeLast) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(packagename, new String("\\/"));
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            list.add(s);
        }
        if (removeLast) {
            list.remove(list.size() - 1);
        }
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (String segment : list) {
            if (first) {
                first = false;
            } else {
                buff.append(".");
            }
            buff.append(segment);
        }
        return NameUtile.getAsName((String)buff.toString());
    }

    protected boolean processEntry(String entry) {
        if (entry.endsWith(this.getFileExtension())) {
            String partname = this.getPartName(entry);
            String packageName = this.getPackageName(entry);
            if (packageName == null || packageName.length() == 0) {
                this.partNamesWithoutPackage.put(NameUtile.getAsName((String)partname), entry);
            } else {
                Map<String, String> partpackage = this.getPackagePartNames(packageName);
                partpackage.put(partname, entry);
                String subPkg = BindingUtil.removeLastSegment(packageName);
                while (subPkg != null && subPkg.length() > 0) {
                    this.getPackagePartNames(NameUtile.getAsName((String)subPkg));
                    subPkg = BindingUtil.removeLastSegment(subPkg);
                }
            }
            return true;
        }
        return false;
    }

    protected String getPartName(String entry) {
        File temppath = new File(entry);
        String partname = temppath.getName();
        return NameUtile.getAsName((String)partname.substring(0, partname.indexOf(46)));
    }

    protected String getFileExtension() {
        return ".eglxml";
    }

    protected String[] getAllEntries() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.partNamesWithoutPackage.values());
        for (Map<String, String> map : this.partNamesByPackage.values()) {
            list.addAll(map.values());
        }
        return list.toArray(new String[list.size()]);
    }

    private Map<String, String> getPackagePartNames(String packageName) {
        Map<String, String> map = this.partNamesByPackage.get(packageName);
        if (map == null) {
            map = new HashMap<String, String>();
            this.partNamesByPackage.put(packageName, map);
        }
        return map;
    }

    protected void processEntries() {
        try {
            List<String> entries = this.reader.getEntries();
            int i = 0;
            while (i < entries.size()) {
                String entry = entries.get(i);
                this.processEntry(entry);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    public boolean isZipFile() {
        return true;
    }

    public String getID() {
        return this.path;
    }

    public InputStream getResourceAsStream(String relativePath) {
        try {
            return this.reader.getInputStream(relativePath);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getResourceLocation(String relativePath) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Map<String, String>> getPartNamesByPackage() {
        return this.partNamesByPackage;
    }

    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        ArrayList<String> list = new ArrayList<String>();
        if (pkg.length() == 0) {
            list.addAll(this.getAllEntriesAsKeys(this.partNamesWithoutPackage));
            if (includeSubPkgs) {
                for (Map<String, String> map : this.partNamesByPackage.values()) {
                    list.addAll(this.getAllEntriesAsKeys(map));
                }
            }
            return list;
        }
        String pkgName = this.getPackageName(pkg.replace('.', '/'), false);
        for (String key : this.partNamesByPackage.keySet()) {
            if (!NameUtile.equals((String)pkgName, (String)key) && (!this.isSubPkg(key, pkgName) || !includeSubPkgs)) continue;
            Map<String, String> map = this.partNamesByPackage.get(key);
            list.addAll(this.getAllEntriesAsKeys(map));
        }
        return list;
    }

    private boolean isSubPkg(String pkgName, String subPkgName) {
        if (pkgName.length() <= subPkgName.length()) {
            return false;
        }
        String temp = NameUtile.getAsName((String)pkgName.substring(0, subPkgName.length()));
        return NameUtile.equals((String)temp, (String)subPkgName) && pkgName.substring(subPkgName.length(), subPkgName.length() + 1).equals(".");
    }

    private List<String> getAllEntriesAsKeys(Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (String entry : map.values()) {
            list.add(this.convertToStoreKey(entry));
        }
        return list;
    }

    protected String convertToStoreKey(String entry) {
        String value = entry.substring(0, entry.indexOf("."));
        value = value.replaceAll("/", ".");
        value = "egl:" + value;
        return value;
    }
}

