/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sdk.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.mof.utils.NameUtile;

public class Util {
    public static final char[] SUFFIX_egl = ".egl".toCharArray();
    public static final char[] SUFFIX_EGL = ".EGL".toCharArray();

    public static String getFilePartName(File file) {
        return NameUtile.getAsName((String)file.getAbsolutePath().toString());
    }

    public static String getCaseSensitiveFilePartName(File file) {
        return file.getAbsolutePath().toString();
    }

    public static final boolean isEGLFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_EGL.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name.charAt(offset + i);
            if (c != SUFFIX_egl[i] && c != SUFFIX_EGL[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getPartType(Node part) {
        final Integer[] value = new Integer[1];
        part.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Handler handler) {
                value[0] = new Integer(10);
                return false;
            }

            @Override
            public boolean visit(Class eglClass) {
                value[0] = new Integer(30);
                return false;
            }

            @Override
            public boolean visit(ExternalType extType) {
                value[0] = new Integer(28);
                return false;
            }

            @Override
            public boolean visit(Enumeration enumeration) {
                value[0] = new Integer(19);
                return false;
            }

            @Override
            public boolean visit(DataItem dataItem) {
                value[0] = new Integer(17);
                return false;
            }

            @Override
            public boolean visit(Interface interfaceNode) {
                value[0] = new Integer(15);
                return false;
            }

            @Override
            public boolean visit(Library library) {
                value[0] = new Integer(11);
                return false;
            }

            @Override
            public boolean visit(Program program) {
                value[0] = new Integer(13);
                return false;
            }

            @Override
            public boolean visit(Delegate delegate) {
                value[0] = new Integer(27);
                return false;
            }

            @Override
            public boolean visit(Record record) {
                if (record.isAnnotationType()) {
                    value[0] = new Integer(18);
                    return false;
                }
                if (record.isStereotypeType()) {
                    value[0] = new Integer(31);
                    return false;
                }
                value[0] = new Integer(7);
                return false;
            }

            @Override
            public boolean visit(Service service) {
                value[0] = new Integer(14);
                return false;
            }

            @Override
            public boolean visit(org.eclipse.edt.compiler.core.ast.File file) {
                value[0] = new Integer(16);
                return false;
            }
        });
        return value[0];
    }

    public static void log(String message, Exception e) {
        System.out.println(message);
        e.printStackTrace();
    }

    public static List getPartFiles(String pattern, String extension) {
        ArrayList<File> list = new ArrayList<File>();
        if (pattern.indexOf(42) > 0 || pattern.indexOf(63) > 0) {
            int index = pattern.lastIndexOf(File.separatorChar);
            char[] patternChars = index != -1 ? pattern.substring(index + 1).toCharArray() : pattern.toCharArray();
            File userDir = new File(pattern).getParentFile();
            if (userDir.isDirectory() && userDir.exists()) {
                File[] files = userDir.listFiles();
                int i = 0;
                while (i < files.length) {
                    File thisFile = files[i];
                    if (thisFile.getName().toLowerCase().endsWith(extension.toLowerCase()) && CharOperation.pathMatch(patternChars, thisFile.getName().toCharArray(), true, File.separatorChar)) {
                        try {
                            list.add(thisFile.getCanonicalFile());
                        }
                        catch (IOException iOException) {}
                    }
                    ++i;
                }
            }
        } else if (!Util.compileAll(list, pattern, extension)) {
            list.add(new File(pattern));
        }
        return list;
    }

    private static boolean compileAll(List list, String pattern, String extension) {
        File dir = new File(pattern);
        if (dir.exists() && dir.isDirectory()) {
            Util.addAllFilesToList(list, dir, extension);
            return true;
        }
        return false;
    }

    private static void addAllFilesToList(List list, File dir, String extension) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                Util.addAllFilesToList(list, files[i], extension);
            } else if (files[i].getName().toLowerCase().endsWith(extension.toLowerCase())) {
                try {
                    list.add(files[i].getCanonicalFile());
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
    }
}

