/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.util;

import com.ibm.icu.util.StringTokenizer;

public class NameUtil {
    public static final String NAME_DELIMITER = ".";

    private NameUtil() {
    }

    public static String[] toStringArray(String str) {
        return NameUtil.toStringArray(str, NAME_DELIMITER);
    }

    public static String[] toStringArray(String str, String delim) {
        StringTokenizer parser = new StringTokenizer(str, delim);
        String[] names = new String[parser.countTokens()];
        int i = 0;
        while (i < names.length) {
            names[i] = parser.nextToken();
            ++i;
        }
        return names;
    }

    public static String toString(String[] names) {
        return NameUtil.toString(names, NAME_DELIMITER);
    }

    public static String toString(String[] names, String delim) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            if (i > 0) {
                buffer.append(delim);
            }
            buffer.append(names[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String getUnqualifiedName(String name) {
        String[] qualName = NameUtil.toStringArray(name);
        return qualName[qualName.length - 1];
    }
}

