/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.tools;

import java.io.File;
import java.io.IOException;
import org.eclipse.edt.compiler.EGL2IRArgumentProcessor;
import org.eclipse.edt.compiler.EGL2IREnvironment;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.PartEnvironmentStack;
import org.eclipse.edt.compiler.Processor;
import org.eclipse.edt.compiler.Util;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.NullBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.ISDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.compiler.sdk.compile.BuildPathException;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.FileSystemObjectStore;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class EGLC {
    public static final String EGLBIN = ".eglbin";
    public static final String EGLXML = ".eglxml";
    public static EGL2IREnvironment eglcEnv;

    public static void compile(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs, ICompiler compiler, ISDKProblemRequestorFactory problemRequestorFactory) {
        block11: {
            try {
                try {
                    Environment env = new Environment();
                    Environment.pushEnv((IEnvironment)env);
                    File[] files = processedArgs.getPartFiles();
                    if (files.length > 0) {
                        eglcEnv = new EGL2IREnvironment();
                        EGLC.initializeOutputPath(processedArgs);
                        EGLC.initializeSystemRoot(processedArgs, compiler);
                        EGLC.initializeEGLPath(processedArgs);
                        eglcEnv.setCompiler(compiler);
                        Bootstrap.initialize((IEnvironment)Environment.getCurrentEnv());
                        eglcEnv.setSystemPathEntries(compiler.getSystemBuildPathEntries());
                        for (ZipFileBindingBuildPathEntry entry : compiler.getSystemBuildPathEntries()) {
                            Environment.getCurrentEnv().registerObjectStore(entry.getObjectStore().getKeyScheme(), entry.getObjectStore());
                        }
                        Processor processor = new Processor(NullBuildNotifier.getInstance(), new ICompilerOptions(){}, problemRequestorFactory, compiler);
                        PartEnvironmentStack.pushEnv(eglcEnv);
                        processor.setEnvironment(eglcEnv);
                        SourcePathInfo.getInstance().setSourceLocations(EGLC.resolveSourcePathLocations(processedArgs.getSourcePathEntries(), processedArgs.getIROutputPath()));
                        SourcePathEntry.getInstance().setDeclaringEnvironment(eglcEnv);
                        SourcePathEntry.getInstance().setProcessor(processor);
                        int j = 0;
                        while (j < files.length) {
                            File file = files[j];
                            org.eclipse.edt.compiler.core.ast.File fileAST = ASTManager.getInstance().getFileAST(file);
                            String packageName = Util.createCaseSensitivePackageName(fileAST);
                            PackageAndPartName ppName = new PackageAndPartName(packageName, Util.getCaseSensitiveFilePartName(file));
                            processor.addPart(ppName);
                            SourcePathInfo.getInstance().addPart(ppName, 16, file);
                            for (Part part : fileAST.getParts()) {
                                ppName = new PackageAndPartName(packageName, part.getName().getCaseSensitiveIdentifier());
                                processor.addPart(ppName);
                                SourcePathInfo.getInstance().addPart(ppName, Util.getPartType(part), file);
                            }
                            ++j;
                        }
                        processor.process();
                        break block11;
                    }
                    throw new RuntimeException("cannot find target file");
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (BuildPathException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                PartEnvironmentStack.popEnv();
                Environment.popEnv();
                eglcEnv = null;
            }
        }
    }

    private static void deleteIRs(File path) {
        File[] files = path.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                EGLC.deleteIRs(files[i]);
            } else if (files[i].getName().indexOf(".ir") > 0) {
                files[i].delete();
            }
            ++i;
        }
    }

    private static void initializeEGLPath(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs) {
        File[] paths;
        File[] fileArray = paths = processedArgs.getSourcePathEntries();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            if (path.exists()) {
                String outType = processedArgs.xmlOut ? "XML" : "BINARY";
                String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
                FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
                eglcEnv.registerObjectStore("egl", (ObjectStore)store);
                eglcEnv.addRoot(path);
            }
            ++n2;
        }
    }

    private static void initializeOutputPath(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs) {
        File path;
        block4: {
            block2: {
                block3: {
                    path = processedArgs.getIROutputPath();
                    if (path == null) break block2;
                    if (path.exists()) break block3;
                    path.mkdirs();
                    break block4;
                }
                if (!processedArgs.isClean()) break block4;
                EGLC.deleteIRs(path);
                break block4;
            }
            if (processedArgs.isClean()) {
                File[] sourcelocs = processedArgs.getSourcePathEntries();
                int i = 0;
                while (i < sourcelocs.length) {
                    EGLC.deleteIRs(sourcelocs[i]);
                    ++i;
                }
            }
        }
        String outType = processedArgs.getXMLOut() ? "XML" : "BINARY";
        String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
        FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType);
        eglcEnv.registerObjectStore("mof", (ObjectStore)store);
        eglcEnv.setDefaultSerializeStore("mof", (ObjectStore)store);
        store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
        eglcEnv.registerObjectStore("egl", (ObjectStore)store);
        eglcEnv.setDefaultSerializeStore("egl", (ObjectStore)store);
        eglcEnv.addRoot(path);
    }

    private static void initializeSystemRoot(EGL2IRArgumentProcessor.EGL2IRArguments processedArgs, ICompiler compiler) {
        String outType = processedArgs.getXMLOut() ? "XML" : "BINARY";
        File path = processedArgs.getSystemRoot();
        if (path != null && path.exists()) {
            FileSystemObjectStore store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType);
            eglcEnv.registerObjectStore("mof", (ObjectStore)store);
            String fileext = processedArgs.xmlOut ? EGLXML : EGLBIN;
            store = new FileSystemObjectStore(path, (IEnvironment)eglcEnv, outType, fileext);
            eglcEnv.registerObjectStore("egl", (ObjectStore)store);
            eglcEnv.addRoot(path);
        }
    }

    private static File resolveSourcePathLocation(File sourcePathEntryLocation) {
        try {
            return sourcePathEntryLocation.getCanonicalFile();
        }
        catch (IOException e) {
            System.out.println("Could not find source path location: " + sourcePathEntryLocation);
            throw new RuntimeException(e);
        }
    }

    private static File[] resolveSourcePathLocations(File[] sourcePathEntryLocations, File outpath) throws Exception {
        File[] canonicalLocations = new File[sourcePathEntryLocations.length];
        int i = 0;
        while (i < sourcePathEntryLocations.length) {
            canonicalLocations[i] = EGLC.resolveSourcePathLocation(sourcePathEntryLocations[i]);
            ++i;
        }
        return canonicalLocations;
    }
}

