/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;

public class CVSTag
implements ITag {
    public static final int HEAD = 0;
    public static final int BRANCH = 1;
    public static final int VERSION = 2;
    public static final int DATE = 3;
    public static final CVSTag DEFAULT = new CVSTag();
    public static final CVSTag BASE = new CVSTag("BASE", 2);
    public static final String VENDOR_REVISION = "1.1.1";
    public static final String HEAD_REVISION = "1";
    public static final String UNKNOWN_BRANCH = CVSMessages.CVSTag_unknownBranch;
    public static final String HEAD_BRANCH = "HEAD";
    protected String name;
    protected String branchRevision;
    protected int type;
    private static final String DATE_TAG_NAME_FORMAT = "dd MMM yyyy HH:mm:ss Z";
    private static final SimpleDateFormat tagNameFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z", Locale.US);

    protected static synchronized String dateToTagName(Date date) {
        tagNameFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return tagNameFormat.format(date);
    }

    protected static synchronized Date tagNameToDate(String name) {
        if (name == null) {
            return null;
        }
        try {
            return tagNameFormat.parse(name);
        }
        catch (ParseException e) {
            CVSStatus status = new CVSStatus(4, 4, "Tag name " + name + " is not of the expected format " + DATE_TAG_NAME_FORMAT, e);
            CVSProviderPlugin.log((CoreException)((Object)new CVSException((IStatus)status)));
            return null;
        }
    }

    public CVSTag() {
        this(HEAD_BRANCH, HEAD_REVISION, 0);
    }

    public CVSTag(String name, int type) {
        this.name = name;
        this.type = type;
        this.branchRevision = null;
    }

    public CVSTag(String name, String branchRevision, int type) {
        this.name = name;
        this.branchRevision = branchRevision;
        this.type = type;
    }

    public CVSTag(Date date) {
        this(CVSTag.dateToTagName(date), 3);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CVSTag)) {
            return false;
        }
        CVSTag tag = (CVSTag)other;
        if (this.getType() != tag.getType()) {
            return false;
        }
        return this.getName().equals(tag.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getBranchRevision() {
        return this.branchRevision;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(CVSTag other) {
        if (this.getType() == 3 && other.getType() == 3) {
            Date date1 = this.asDate();
            Date date2 = other.asDate();
            if (date1 == null || date2 == null) {
                return -1;
            }
            return date1.compareTo(date2);
        }
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public static boolean equalTags(CVSTag tag1, CVSTag tag2) {
        if (tag1 == null) {
            tag1 = DEFAULT;
        }
        if (tag2 == null) {
            tag2 = DEFAULT;
        }
        return tag1.equals(tag2);
    }

    public static IStatus validateTagName(String tagName) {
        if (tagName == null) {
            return new CVSStatus(4, CVSMessages.CVSTag_nullName);
        }
        if (tagName.equals("")) {
            return new CVSStatus(4, CVSMessages.CVSTag_emptyName);
        }
        if (!Character.isLetter(tagName.charAt(0))) {
            return new CVSStatus(4, CVSMessages.CVSTag_beginName);
        }
        int i = 0;
        while (i < tagName.length()) {
            char c = tagName.charAt(i);
            if (Character.isSpaceChar(c) || c == '$' || c == ',' || c == '.' || c == ':' || c == ';' || c == '@' || c == '|') {
                return new CVSStatus(4, CVSMessages.CVSTag_badCharName);
            }
            ++i;
        }
        return new CVSStatus(0, CVSMessages.ok);
    }

    public Date asDate() {
        return CVSTag.tagNameToDate(this.name);
    }

    public boolean isHeadTag() {
        return this.getType() == 0 || this.getType() == 2 && this.getName().equals(HEAD_BRANCH);
    }

    public boolean isBaseTag() {
        return this.getName().equals("BASE");
    }
}

