/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.search;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.internal.search.UpdatePolicy;
import org.eclipse.update.internal.search.UpdateSiteAdapter;
import org.eclipse.update.internal.search.UpdatesSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchCategory;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.IUpdateSearchResultCollectorFromMirror;
import org.eclipse.update.search.IUpdateSearchSite;
import org.eclipse.update.search.IUpdateSiteAdapter;
import org.eclipse.update.search.UpdateSearchScope;

public class UpdateSearchRequest {
    private IUpdateSearchCategory category;
    private UpdateSearchScope scope;
    private boolean searchInProgress = false;
    private AggregateFilter aggregateFilter = new AggregateFilter();

    public static IUpdateSearchCategory createDefaultUpdatesSearchCategory() {
        return new UpdatesSearchCategory();
    }

    public static IUpdateSearchCategory createDefaultSiteSearchCategory() {
        return new SiteSearchCategory();
    }

    public UpdateSearchRequest(IUpdateSearchCategory category, UpdateSearchScope scope) {
        this.category = category;
        this.scope = scope;
    }

    public IUpdateSearchCategory getCategory() {
        return this.category;
    }

    public UpdateSearchScope getScope() {
        return this.scope;
    }

    public void addFilter(IUpdateSearchFilter filter) {
        if (this.searchInProgress) {
            return;
        }
        this.aggregateFilter.addFilter(filter);
    }

    public void removeFilter(IUpdateSearchFilter filter) {
        if (this.searchInProgress) {
            return;
        }
        this.aggregateFilter.removeFilter(filter);
    }

    public void setScope(UpdateSearchScope scope) {
        this.scope = scope;
    }

    public boolean isSearchInProgress() {
        return this.searchInProgress;
    }

    public void performSearch(IUpdateSearchResultCollector collector, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        HashSet visitedSites;
        ArrayList<IStatus> statusList;
        block20: {
            statusList = new ArrayList<IStatus>();
            this.searchInProgress = true;
            IUpdateSearchQuery[] queries = this.category.getQueries();
            IUpdateSearchSite[] candidates = this.scope.getSearchSites();
            HashSet<URL> visitedSitesURL = new HashSet<URL>();
            visitedSites = new HashSet();
            int i = 0;
            while (i < candidates.length) {
                visitedSitesURL.add(candidates[i].getURL());
                ++i;
            }
            URL updateMapURL = this.scope.getUpdateMapURL();
            boolean searchFeatureProvidedSites = this.scope.isFeatureProvidedSitesEnabled();
            if (monitor.isCanceled()) break block20;
            int nsearchsites = 0;
            try {
                int i2 = 0;
                while (i2 < queries.length) {
                    if (queries[i2].getQuerySearchSite() != null) {
                        ++nsearchsites;
                    }
                    ++i2;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            int ntasks = nsearchsites + queries.length * candidates.length;
            if (updateMapURL != null) {
                ++ntasks;
            }
            monitor.beginTask(Messages.UpdateSearchRequest_searching, ntasks);
            try {
                IStatus status;
                UpdatePolicy updatePolicy = null;
                if (updateMapURL != null && (status = UpdateUtils.loadUpdatePolicy(updatePolicy = new UpdatePolicy(), updateMapURL, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                    statusList.add(status);
                }
                List combinedAssociateSites = new ArrayList();
                int i3 = 0;
                while (i3 < queries.length) {
                    block22: {
                        IUpdateSearchQuery query;
                        block21: {
                            IUpdateSiteAdapter mappedSite;
                            IFeature feature;
                            query = queries[i3];
                            IQueryUpdateSiteAdapter qsite = query.getQuerySearchSite();
                            if (qsite == null || !searchFeatureProvidedSites) break block21;
                            if (query instanceof UpdatesSearchCategory.UpdateQuery && (feature = ((UpdatesSearchCategory.UpdateQuery)query).getFeature()) != null && !feature.getSite().getCurrentConfiguredSite().verifyUpdatableStatus().isOK() || (mappedSite = this.getMappedSite(updatePolicy, qsite)) == null || mappedSite.getURL() == null) break block22;
                            ArrayList associateSites = new ArrayList();
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                            IStatus status2 = this.searchOneSite(mappedSite, null, query, collector, associateSites, subMonitor, true);
                            if (status2 != null) {
                                statusList.add(status2);
                            }
                            if (monitor.isCanceled()) break block20;
                            combinedAssociateSites = this.combineAssociateSites(combinedAssociateSites, associateSites, visitedSitesURL, visitedSites);
                        }
                        int j = 0;
                        while (j < candidates.length) {
                            if (monitor.isCanceled()) break;
                            IUpdateSearchSite source = candidates[j];
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                            ArrayList associateSites = new ArrayList();
                            IStatus status3 = this.searchOneSite(source, source.getCategoriesToSkip(), query, collector, associateSites, subMonitor, true);
                            if (status3 != null) {
                                statusList.add(status3);
                            }
                            combinedAssociateSites = this.combineAssociateSites(combinedAssociateSites, associateSites, visitedSitesURL, visitedSites);
                            ++j;
                        }
                        if (monitor.isCanceled()) break block20;
                        int associateSitesDepth = 0;
                        while (associateSitesDepth < 5) {
                            ArrayList tempCombinedSites = new ArrayList();
                            Iterator combinedAssociateSitesIterator = combinedAssociateSites.iterator();
                            while (combinedAssociateSitesIterator.hasNext()) {
                                IUpdateSearchSite source = (IUpdateSearchSite)combinedAssociateSitesIterator.next();
                                ArrayList associateSites = new ArrayList();
                                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                                IStatus status4 = this.searchOneSite(source, source.getCategoriesToSkip(), query, collector, associateSites, subMonitor, true);
                                combinedAssociateSites = this.combineAssociateSites(tempCombinedSites, associateSites, visitedSitesURL, visitedSites);
                                if (status4 == null) continue;
                                statusList.add(status4);
                            }
                            combinedAssociateSites = tempCombinedSites;
                            ++associateSitesDepth;
                        }
                        if (monitor.isCanceled()) break block20;
                    }
                    ++i3;
                }
            }
            catch (CoreException e) {
                this.searchInProgress = false;
                monitor.done();
                throw e;
            }
        }
        this.searchInProgress = false;
        monitor.done();
        Iterator visitedSitesIterator = visitedSites.iterator();
        while (visitedSitesIterator.hasNext()) {
            IUpdateSearchSite associateSite = (IUpdateSearchSite)visitedSitesIterator.next();
            this.scope.addSearchSite(associateSite.getLabel(), associateSite.getURL(), null);
        }
        if (statusList.size() > 0) {
            if (statusList.size() == 1 && ((IStatus)statusList.get(0)).getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            IStatus[] children = statusList.toArray(new IStatus[statusList.size()]);
            MultiStatus multiStatus = new MultiStatus("org.eclipse.update.core", 42, children, Messages.Search_networkProblems, null);
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private List combineAssociateSites(List combinedAssociateSites, List associateSites, Set visitedSitesURL, Set visitedSites) {
        Iterator iterator = associateSites.iterator();
        while (iterator.hasNext()) {
            UpdateSearchSite associateSite = (UpdateSearchSite)iterator.next();
            if (visitedSitesURL.contains(associateSite.getURL())) continue;
            combinedAssociateSites.add(associateSite);
            visitedSitesURL.add(associateSite.getURL());
            visitedSites.add(associateSite);
        }
        return combinedAssociateSites;
    }

    private IUpdateSiteAdapter getMappedSite(UpdatePolicy policy, IQueryUpdateSiteAdapter qsite) {
        if (policy != null && policy.isLoaded()) {
            IUpdateSiteAdapter mappedSite = policy.getMappedSite(qsite.getMappingId());
            if (mappedSite != null) {
                return mappedSite;
            }
            return policy.isFallbackAllowed() ? qsite : null;
        }
        return qsite;
    }

    private IStatus searchOneSite(IUpdateSiteAdapter siteAdapter, String[] categoriesToSkip, IUpdateSearchQuery query, IUpdateSearchResultCollector collector, List associateSites, SubProgressMonitor monitor, boolean checkMirrors) throws CoreException {
        IURLEntry[] associateSitesList;
        ISite site;
        String text;
        block11: {
            block10: {
                text = NLS.bind((String)Messages.UpdateSearchRequest_contacting, (Object)siteAdapter.getLabel());
                monitor.subTask(text);
                monitor.beginTask("", 10);
                URL siteURL = siteAdapter.getURL();
                try {
                    site = SiteManager.getSite(siteURL, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                    if (site != null) break block10;
                    monitor.worked(9);
                    return null;
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status == null) {
                        throw e;
                    }
                    monitor.worked(10);
                    return status;
                }
            }
            if (!(collector instanceof IUpdateSearchResultCollectorFromMirror) || !(site instanceof ISiteWithMirrors) || siteAdapter instanceof MirroredUpdateSiteAdapter) break block11;
            IURLEntry mirror = null;
            try {
                mirror = ((IUpdateSearchResultCollectorFromMirror)collector).getMirror((ISiteWithMirrors)site, siteAdapter.getLabel());
                if (site instanceof ExtendedSite) {
                    ((ExtendedSite)site).setSelectedMirror(mirror);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                monitor.setCanceled(true);
                return Status.CANCEL_STATUS;
            }
            if (mirror != null) {
                return this.searchOneSite(new MirroredUpdateSiteAdapter(mirror), categoriesToSkip, query, collector, associateSites, new SubProgressMonitor((IProgressMonitor)monitor, 1), false);
            }
        }
        text = NLS.bind((String)Messages.UpdateSearchRequest_checking, (Object)siteAdapter.getLabel());
        monitor.getWrappedProgressMonitor().subTask(text);
        if (site instanceof ExtendedSite && (associateSitesList = ((ExtendedSite)site).getAssociateSites()) != null) {
            int i = 0;
            while (i < associateSitesList.length) {
                associateSites.add(new UpdateSearchSite(associateSitesList[i].getAnnotation(), associateSitesList[i].getURL(), null));
                ++i;
            }
        }
        query.run(site, categoriesToSkip, this.aggregateFilter, collector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 9));
        return null;
    }

    class AggregateFilter
    implements IUpdateSearchFilter {
        private ArrayList filters;

        AggregateFilter() {
        }

        public void addFilter(IUpdateSearchFilter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            if (!this.filters.contains(filter)) {
                this.filters.add(filter);
            }
        }

        public void removeFilter(IUpdateSearchFilter filter) {
            if (this.filters == null) {
                return;
            }
            this.filters.remove(filter);
        }

        public boolean accept(IFeature match) {
            if (this.filters == null) {
                return true;
            }
            int i = 0;
            while (i < this.filters.size()) {
                IUpdateSearchFilter filter = (IUpdateSearchFilter)this.filters.get(i);
                if (!filter.accept(match)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean accept(IFeatureReference match) {
            if (this.filters == null) {
                return true;
            }
            int i = 0;
            while (i < this.filters.size()) {
                IUpdateSearchFilter filter = (IUpdateSearchFilter)this.filters.get(i);
                if (!filter.accept(match)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class MirroredUpdateSiteAdapter
    extends UpdateSiteAdapter {
        public MirroredUpdateSiteAdapter(IURLEntry mirror) {
            super(mirror.getAnnotation(), mirror.getURL());
        }
    }

    private static class UpdateSearchSite
    extends UpdateSiteAdapter
    implements IUpdateSearchSite {
        private String[] categoriesToSkip;

        public UpdateSearchSite(String label, URL siteURL, String[] categoriesToSkip) {
            super(label, siteURL);
            this.categoriesToSkip = categoriesToSkip;
        }

        public String[] getCategoriesToSkip() {
            return this.categoriesToSkip;
        }
    }
}

