/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.viewsupport.IViewPartInputProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class EGLElementConfiguration {
    IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    protected IEGLElement getInitialEGLElement(IStructuredSelection selection) {
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        IEGLElement eelem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable && (eelem = (IEGLElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IEGLElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (eelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                eelem = (IEGLElement)resource.getAdapter(IEGLElement.class);
            }
            if (eelem == null) {
                eelem = EGLCore.create((IResource)resource);
            }
        }
        if (eelem == null) {
            Object elem;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window == null ? null : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof ContentOutline) {
                part = page.getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IEGLElement) {
                eelem = (IEGLElement)elem;
            }
        }
        if (eelem == null || eelem.getElementType() == 1) {
            try {
                IEGLProject[] projects = EGLCore.create((IWorkspaceRoot)this.fWorkspaceRoot).getEGLProjects();
                if (projects.length == 1) {
                    eelem = projects[0];
                }
            }
            catch (EGLModelException e) {
                EGLLogger.log((Object)this, e);
            }
        }
        return eelem;
    }
}

