/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.services.ext;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.utils.NameUtile;

public class Utils {
    private static final String IHttpMofKey = "egl:eglx.http.IHttp";

    public static boolean isIHTTP(Type type) {
        return TypeUtils.isTypeOrSubtypeOf((Type)type, (String)IHttpMofKey);
    }

    public static Node getRequestFormat(NestedFunction nestedFunction) {
        return Utils.getAnnotationValueNode("requestFormat", nestedFunction);
    }

    public static Node getResponseFormat(NestedFunction nestedFunction) {
        return Utils.getAnnotationValueNode("responseFormat", nestedFunction);
    }

    public static Node getUriTemplateNode(NestedFunction nestedFunction) {
        return Utils.getAnnotationValueNode("uriTemplate", nestedFunction);
    }

    private static Node getAnnotationValueNode(String annName, NestedFunction nestedFunction) {
        final Node[] result = new Node[1];
        final String name = NameUtile.getAsName((String)annName);
        nestedFunction.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(Assignment assignment) {
                if (assignment.getLeftHandSide() instanceof SimpleName && ((SimpleName)assignment.getLeftHandSide()).getIdentifier().equals(name)) {
                    result[0] = assignment.getRightHandSide();
                }
                return false;
            }
        });
        return result[0];
    }
}

