/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaAnnotationProvider;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryPersistentType;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.RootBinaryNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentTypeCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryPersistentTypeCache
extends RootBinaryNode
implements JavaResourcePersistentTypeCache {
    private final Vector<Entry> entries = new Vector();

    public BinaryPersistentTypeCache(JpaAnnotationProvider annotationProvider) {
        super(null, annotationProvider);
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistentTypes() {
        return this.getPersistentTypes().iterator();
    }

    private Iterable<JavaResourcePersistentType> getPersistentTypes() {
        return new TransformationIterable<Entry, JavaResourcePersistentType>(this.getEntries()){

            protected JavaResourcePersistentType transform(Entry entry) {
                return entry.persistentType;
            }
        };
    }

    private Iterable<Entry> getEntries() {
        return new LiveCloneIterable(this.entries);
    }

    @Override
    public int persistentTypesSize() {
        return this.entries.size();
    }

    @Override
    public JavaResourcePersistentType addPersistentType(IType jdtType) {
        Entry entry = this.buildEntry(jdtType);
        this.entries.add(entry);
        this.fireItemAdded("persistentTypes", entry.persistentType);
        return entry.persistentType;
    }

    private Entry buildEntry(IType jdtType) {
        return new Entry(this.buildPersistentType(jdtType), jdtType.getResource());
    }

    private JavaResourcePersistentType buildPersistentType(IType jdtType) {
        return new BinaryPersistentType((JavaResourceNode)this, jdtType);
    }

    @Override
    public boolean removePersistentTypes(IFile jarFile) {
        boolean modified = false;
        for (Entry entry : this.getEntries()) {
            IResource resource = entry.resource;
            if (resource == null || !resource.equals((Object)jarFile)) continue;
            this.removeEntry(entry);
            modified = true;
        }
        return modified;
    }

    private void removeEntry(Entry entry) {
        this.entries.remove(entry);
        this.fireItemRemoved("persistentTypes", entry.persistentType);
    }

    @Override
    protected void aspectChanged(String aspectName) {
        if (aspectName != null && !aspectName.equals("persistentTypes")) {
            super.aspectChanged(aspectName);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.entries);
    }

    static class Entry {
        final JavaResourcePersistentType persistentType;
        final IResource resource;

        Entry(JavaResourcePersistentType persistentType, IResource resource) {
            this.persistentType = persistentType;
            this.resource = resource;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.persistentType);
        }
    }
}

