/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.persistence.sql.validation;

import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;
import org.eclipse.edt.mof.eglx.persistence.sql.messages.SQLResourceKeys;
import org.eclipse.edt.mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class ReplaceStatementValidator
extends AbstractSqlStatementValidator {
    ReplaceStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    UsingClause using;
    UsingKeysClause usingKeys;
    FromOrToExpressionClause to;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    ForExpressionClause forExpression;

    public ReplaceStatementValidator(ReplaceStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateDataSource();
        this.validateFor();
    }

    private void validateTarget() {
        Expression target = this.statement.getRecord();
        Type targetType = target.resolveType();
        if (targetType == null) {
            return;
        }
        if (TypeUtils.isPrimitive((Type)targetType)) {
            targetType = this.getContainingType(target.resolveMember());
        }
        if (!this.isDataExpr(target) || targetType instanceof ArrayType) {
            this.problemRequestor.acceptProblem((Node)target, 8513, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
        if (this.isAssociationExpression(target)) {
            this.problemRequestor.acceptProblem((Node)target, 8508, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
        if (targetType != null && !this.isSingleTable(targetType)) {
            this.problemRequestor.acceptProblem((Node)target, 8515, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
        if (this.to != null && targetType != null && this.withExpression == null && this.withInline == null && Utils.isSQLDataSource(this.to.getExpression().resolveType()) && !this.hasID(targetType)) {
            this.problemRequestor.acceptProblem((Node)target, 8509, 2, new String[]{targetType.getTypeSignature()}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void validateFor() {
        if (this.forExpression != null) {
            Type type;
            if (this.using != null || this.withExpression != null || this.withInline != null) {
                this.problemRequestor.acceptProblem((Node)this.forExpression, 8503, 2, new String[0], SQLResourceKeys.getResourceBundleForKeys());
            }
            if ((type = this.forExpression.getExpression().resolveType()) != null && (!this.isEntityWithID(type) || this.isAssociationExpression(this.forExpression.getExpression()))) {
                this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8502, 2, new String[]{this.forExpression.getExpression().getCanonicalString()}, SQLResourceKeys.getResourceBundleForKeys());
                return;
            }
        }
    }

    private void validateDataSource() {
        Type type;
        if (this.to != null && Utils.isSQLResultSet(type = this.to.getExpression().resolveType()) && (this.withInline != null || this.withExpression != null || this.forExpression != null || this.using != null)) {
            this.problemRequestor.acceptProblem((Node)this.statement, 8517, 2, new String[]{"eglx.persistence.sql.SQLResultSet"}, SQLResourceKeys.getResourceBundleForKeys());
            return;
        }
    }

    private void initialize() {
        this.statement.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (ReplaceStatementValidator.this.withInline == null && ReplaceStatementValidator.this.withExpression == null) {
                    ReplaceStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"replace".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(WithExpressionClause withExpressionClause) {
                if (ReplaceStatementValidator.this.withInline == null && ReplaceStatementValidator.this.withExpression == null) {
                    ReplaceStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"replace".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingClause usingClause) {
                if (ReplaceStatementValidator.this.using == null) {
                    ReplaceStatementValidator.this.using = usingClause;
                } else {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6510, new String[]{"replace".toUpperCase(), "using".toUpperCase()});
                }
                return false;
            }

            public boolean visit(UsingKeysClause usingKeysClause) {
                if (ReplaceStatementValidator.this.usingKeys == null) {
                    ReplaceStatementValidator.this.usingKeys = usingKeysClause;
                } else {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6510, new String[]{"replace".toUpperCase(), "usingKeys".toUpperCase()});
                }
                return false;
            }

            public boolean visit(FromOrToExpressionClause clause) {
                if (ReplaceStatementValidator.this.to == null) {
                    ReplaceStatementValidator.this.to = clause;
                } else {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"replace".toUpperCase(), "to".toUpperCase()});
                }
                return false;
            }

            public boolean visit(ForExpressionClause forExpressionClause) {
                if (ReplaceStatementValidator.this.forExpression == null) {
                    ReplaceStatementValidator.this.forExpression = forExpressionClause;
                } else {
                    ReplaceStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"replace".toUpperCase(), "for".toUpperCase()});
                }
                return false;
            }
        });
    }
}

