/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IImportContainer;
import org.eclipse.edt.ide.core.model.IImportDeclaration;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IProperty;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.ISourceReference;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EGLFileOperation
extends WorkspaceModifyOperation {
    protected static String newLine = System.getProperty("line.separator");
    private EGLFileConfiguration configuration;
    protected IProject project;

    public EGLFileOperation(EGLFileConfiguration configuration) {
        this.configuration = configuration;
    }

    public EGLFileOperation(EGLFileConfiguration configuration, ISchedulingRule rule) {
        super(rule);
        this.configuration = configuration;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String packName;
        Path sourcePath;
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.configuration.getProjectName());
        IEGLProject eproject = EGLCore.create((IProject)this.project);
        IPackageFragmentRoot root = eproject.findPackageFragmentRoot((sourcePath = new Path(this.configuration.getContainerName())).makeAbsolute());
        IPackageFragment frag = root.getPackageFragment(packName = this.configuration.getFPackage());
        IContainer container = (IContainer)frag.getResource();
        IFile file = container.getFile((IPath)new Path(String.valueOf(this.configuration.getFileName()) + ".egl"));
        if (file.exists()) {
            this.updateExistingFile(root, frag, file, monitor);
        } else {
            this.writeFileWithNewContent(root, frag, file, monitor);
        }
        this.configuration.setFile(file);
        this.updateEGLPathIfNeeded(monitor);
    }

    protected void writeFileWithNewContent(IPackageFragmentRoot root, IPackageFragment frag, IFile file, IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            this.createFile(root, frag);
        }
        catch (CoreException e) {
            EGLLogger.log((Object)this, e);
            throw e;
        }
        catch (InterruptedException e0) {
            EGLLogger.log((Object)this, e0);
        }
        try {
            String fileHeader = this.getFileHeader(this.configuration.getFPackage());
            String fileContents = this.getFileContents();
            String fileOutputString = String.valueOf(fileHeader) + fileContents;
            String encoding = null;
            if (file.exists()) {
                encoding = file.getCharset();
            } else {
                IContainer folder = (IContainer)frag.getResource();
                encoding = folder.getDefaultCharset();
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? fileOutputString.getBytes() : fileOutputString.getBytes(encoding));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, monitor);
            } else {
                file.create((InputStream)stream, true, monitor);
            }
            ((InputStream)stream).close();
        }
        catch (IOException e1) {
            EGLLogger.log((Object)this, e1);
        }
    }

    protected void updateExistingFile(IPackageFragmentRoot root, IPackageFragment frag, IFile file, IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.writeFileWithNewContent(root, frag, file, monitor);
    }

    protected String getFileHeader(String packName) {
        String fileContents = "";
        fileContents = packName.compareTo("") != 0 ? fileContents.concat("package " + packName + ";\n\n") : "";
        return fileContents;
    }

    protected String getFileContents() throws PartTemplateException {
        return NewWizardMessages.NewEGLFileWizardPageFilecontents;
    }

    private void createFile(IPackageFragmentRoot root, IPackageFragment pack) throws CoreException, InterruptedException {
        Object createdWorkingCopy = null;
        try {
            if (pack == null) {
                pack = root.getPackageFragment("");
            }
            if (!pack.exists()) {
                String packName = pack.getElementName();
                pack = root.createPackageFragment(packName, true, null);
            }
            String fileOutputString = "";
            pack.createEGLFile(String.valueOf(this.configuration.getFileName()) + ".egl", fileOutputString, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (createdWorkingCopy != null) {
                createdWorkingCopy.destroy();
            }
        }
    }

    protected String RemoveRemainingTemplateTags(String outputString, String firstHalfOutputString, String secondHalfOutputString) {
        while (outputString.indexOf("${") != -1) {
            int tagStart = outputString.indexOf("${");
            int tagEnd = outputString.indexOf("}", tagStart);
            firstHalfOutputString = outputString.substring(0, tagStart);
            secondHalfOutputString = outputString.substring(tagStart + 2, outputString.length());
            outputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
            firstHalfOutputString = outputString.substring(0, tagEnd - 2);
            secondHalfOutputString = outputString.substring(tagEnd - 1, outputString.length());
            if (firstHalfOutputString.endsWith("cursor")) {
                firstHalfOutputString = firstHalfOutputString.substring(0, firstHalfOutputString.length() - 6);
            }
            outputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
        }
        return outputString;
    }

    protected static boolean getPropertyValueString(boolean first, String strPropName, String strPropValue, boolean addNewLine, boolean addQuote, StringBuffer str) {
        if (strPropValue != null && strPropValue.length() > 0) {
            if (!first) {
                str.append(", ");
            }
            first = false;
            if (addNewLine) {
                str.append(newLine);
            }
            str.append(strPropName);
            str.append("=");
            if (addQuote) {
                str.append("\"");
            }
            str.append(strPropValue);
            if (addQuote) {
                str.append("\"");
            }
        }
        return first;
    }

    protected static boolean getPropertyQuoteValueString(boolean first, String strPropName, String strPropValue, boolean addNewLine, StringBuffer str) {
        return EGLFileOperation.getPropertyValueString(first, strPropName, strPropValue, addNewLine, true, str);
    }

    protected static boolean getPropertyBooleanValueString(boolean first, String strPropName, boolean booleanvalue, boolean addNewLine, StringBuffer str) {
        String strValue = Boolean.toString(booleanvalue);
        return EGLFileOperation.getPropertyValueString(first, strPropName, strValue, addNewLine, false, str);
    }

    protected static boolean getPropertyBoolValueString(boolean first, String strPropName, boolean booleanvalue, boolean addNewLine, StringBuffer str) {
        String strYesNoValue = booleanvalue ? "yes" : "no";
        return EGLFileOperation.getPropertyValueString(first, strPropName, strYesNoValue, addNewLine, false, str);
    }

    protected static StringBuffer getXMLAnnotationString(String strNameSpace, String strName) {
        StringBuffer str = new StringBuffer();
        if (strNameSpace != null && strNameSpace.length() > 0 || strName != null && strName.length() > 0) {
            str.append("{@");
            str.append("xml");
            str.append(" {");
            boolean firstProp = true;
            firstProp = EGLFileOperation.getPropertyQuoteValueString(firstProp, "name", strName, false, str);
            firstProp = EGLFileOperation.getPropertyQuoteValueString(firstProp, "namespace", strNameSpace, false, str);
            str.append("}}");
        }
        return str;
    }

    protected static StringBuffer getXMLAnnotationString(IProperty[] xmlProperties) {
        StringBuffer str = new StringBuffer();
        str.append("{");
        str.append("@XML");
        str.append("{");
        str.append(EGLFileOperation.getProperty(xmlProperties));
        str.append("}");
        str.append("}");
        return str;
    }

    private static StringBuffer getProperty(IProperty[] properties) {
        StringBuffer str = new StringBuffer();
        IProperty[] iPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty prop = iPropertyArray[n2];
            boolean isNestedProp = false;
            try {
                if (prop.getValue() instanceof IProperty[]) {
                    isNestedProp = true;
                }
                if (isNestedProp) {
                    str.append("@");
                }
                str.append(prop.getElementName());
                if (isNestedProp) {
                    str.append("{");
                    str.append(EGLFileOperation.getProperty((IProperty[])prop.getValue()));
                    str.append("}");
                } else {
                    str.append("=");
                    if (prop.getValueType() == 2) {
                        str.append("\"");
                        str.append(prop.getValue());
                        str.append("\"");
                    } else {
                        str.append(prop.getValue());
                    }
                }
            }
            catch (EGLModelException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return str;
    }

    protected void updateEGLPathIfNeeded(IProgressMonitor monitor) throws EGLModelException {
        String initialProjName;
        String currProjName;
        if (this.configuration.isNeed2UpdateEGLPath() && !(currProjName = this.configuration.getProjectName()).equals(initialProjName = this.configuration.getInitialProjectName()) && this.configuration.isUpdateEGLPath()) {
            IProject currProject = this.configuration.fWorkspaceRoot.getProject(currProjName);
            IEGLProject currEGLProj = EGLCore.create((IProject)currProject);
            IProject initialProj = this.configuration.fWorkspaceRoot.getProject(initialProjName);
            IEGLPathEntry newEntry = EGLCore.newProjectEntry((IPath)initialProj.getFullPath());
            if (!currEGLProj.isOnEGLPath((IResource)initialProj) && !currEGLProj.hasEGLPathCycle(new IEGLPathEntry[]{newEntry})) {
                IEGLPathEntry[] eglPathEntries = currEGLProj.getRawEGLPath();
                int oldLen = eglPathEntries.length;
                IEGLPathEntry[] newEGLPathEntries = new IEGLPathEntry[oldLen + 1];
                int i = 0;
                while (i < oldLen) {
                    newEGLPathEntries[i] = eglPathEntries[i];
                    ++i;
                }
                newEGLPathEntries[oldLen] = newEntry;
                currEGLProj.setRawEGLPath(newEGLPathEntries, monitor);
            }
        }
    }

    private void doUpdateEGLBuffer(IEGLFile file, int position, int length, String text) throws EGLModelException, CoreException {
        IBuffer buffer = file.getBuffer();
        buffer.replace(position, length, text);
    }

    protected void saveExistingFileWithNewBuffer(IPackageFragment frag, IEGLFile eglfile, IFile file, IProgressMonitor monitor) throws CoreException {
        IBuffer buffer = eglfile.getBuffer();
        String newFileContents = buffer.getContents();
        buffer.close();
        frag.createEGLFile(file.getName(), newFileContents, true, (IProgressMonitor)new NullProgressMonitor());
        String encoding = null;
        if (file.exists()) {
            encoding = file.getCharset();
        } else {
            IContainer folder = (IContainer)frag.getResource();
            encoding = folder.getDefaultCharset();
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? newFileContents.getBytes() : newFileContents.getBytes(encoding));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, monitor);
            }
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            EGLLogger.log((Object)this, e);
        }
    }

    protected void addImports(IEGLFile file, List lstImportElemName) throws EGLModelException, CoreException {
        StringBuffer importStringBuffer = new StringBuffer();
        if (file != null) {
            IImportDeclaration[] imports = file.getImports();
            ISourceRange range = null;
            IEGLElement[] elements = file.getChildren();
            IEGLElement importBlock = null;
            IEGLElement packageBlock = null;
            for (String newImportElemName : lstImportElemName) {
                boolean fndDup = false;
                int i = 0;
                while (i < imports.length && !fndDup) {
                    String existingElementName = imports[i].getElementName();
                    if (newImportElemName.equalsIgnoreCase(existingElementName)) {
                        fndDup = true;
                    }
                    ++i;
                }
                if (fndDup) continue;
                importStringBuffer.append("import");
                importStringBuffer.append(" ");
                importStringBuffer.append(newImportElemName);
                importStringBuffer.append(";");
                importStringBuffer.append(newLine);
            }
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getElementType() == 12) {
                    packageBlock = elements[i];
                } else if (elements[i].getElementType() == 13) {
                    importBlock = elements[i];
                    break;
                }
                ++i;
            }
            int rangeOffset = 0;
            if (importBlock != null) {
                range = ((IImportContainer)importBlock).getSourceRange();
                rangeOffset = range != null ? range.getOffset() : 0;
            } else if (packageBlock != null) {
                range = ((ISourceReference)packageBlock).getSourceRange();
                rangeOffset = range != null ? range.getOffset() + range.getLength() : 0;
            }
            String importString = importStringBuffer.toString();
            if (importString.length() > 0) {
                this.doUpdateEGLBuffer(file, rangeOffset, 0, importString);
            }
        }
    }

    protected void insertMemeberPart(IEGLFile eglfile, IPart sourcePart, String insertionString) throws CoreException {
        if (sourcePart != null) {
            StringBuffer insertStringBuf = new StringBuffer(insertionString);
            try {
                ISourceRange range = null;
                IEGLElement[] elements = sourcePart.getChildren();
                IEGLElement propBlock = null;
                int i = 0;
                while (i < elements.length) {
                    if (elements[i].getElementType() == 16) {
                        propBlock = elements[i];
                        break;
                    }
                    ++i;
                }
                int insertposition = 0;
                if (propBlock != null) {
                    range = ((IMember)propBlock).getSourceRange();
                    String propBlockSource = ((IMember)propBlock).getSource();
                    if (propBlockSource.charAt(propBlockSource.length() - 1) != '\t') {
                        insertStringBuf.insert(0, "\t");
                    }
                    insertposition = range.getOffset() + range.getLength();
                } else {
                    insertposition = this.getInsertPosition(eglfile, sourcePart, insertStringBuf);
                }
                insertStringBuf.append("\n");
                if (propBlock != null && elements.length > 1) {
                    insertStringBuf.append("\t");
                }
                if (insertposition > 0) {
                    this.doUpdateEGLBuffer(eglfile, insertposition, 0, insertStringBuf.toString());
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
    }

    protected int getInsertPosition(IEGLFile eglfile, IPart sourcePart, StringBuffer insertStringBuf) throws EGLModelException {
        return 0;
    }
}

