/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.SchemaLibrary;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaLibraryImpl
implements SchemaLibrary {
    private JaxbProject project;
    private final Map<String, String> schemaLocations;
    private final Map<String, XSDResourceImpl> schemaResources;
    private Adapter schemaResourceAdapter = new SchemaResourceAdapter();

    SchemaLibraryImpl(JaxbProject project) {
        this.project = project;
        this.schemaLocations = new HashMap<String, String>();
        this.schemaResources = new HashMap<String, XSDResourceImpl>();
        this.readProjectPreferences();
    }

    @Override
    public XSDSchema getSchema(String namespace) {
        XSDSchema schema;
        String resolvedUri = this.getResolvedUri(namespace);
        if (resolvedUri == null) {
            return null;
        }
        XSDResourceImpl schemaResource = this.schemaResources.get(namespace);
        XSDSchema xSDSchema = schema = schemaResource == null ? null : schemaResource.getSchema();
        if (schemaResource != null) {
            if (schema != null && schemaResource.getURI().toString().equals(resolvedUri) && schemaResource.isLoaded()) {
                return schema;
            }
            this.removeSchemaResource(namespace, schemaResource);
        }
        return this.addSchema(namespace, resolvedUri);
    }

    protected String getResolvedUri(String namespace) {
        String location = this.schemaLocations.get(namespace);
        return XsdUtil.getResolvedUri(namespace, location);
    }

    protected XSDSchema addSchema(String namespace, String resolvedUri) {
        XSDResourceImpl schemaResource;
        XSDSchema schema = XsdUtil.buildXSDModel(resolvedUri);
        XSDResourceImpl xSDResourceImpl = schemaResource = schema == null ? null : (XSDResourceImpl)schema.eResource();
        if (schemaResource != null) {
            schemaResource.eAdapters().add((Object)this.schemaResourceAdapter);
            this.schemaResources.put(namespace, schemaResource);
            return schema;
        }
        return null;
    }

    protected void removeSchemaResource(XSDResourceImpl schemaResource) {
        for (String namespace : new SnapshotCloneIterable(this.schemaResources.keySet())) {
            if (!schemaResource.equals(this.schemaResources.get(namespace))) continue;
            this.removeSchemaResource(namespace, schemaResource);
        }
    }

    protected void removeSchemaResource(String namespace, XSDResourceImpl schemaResource) {
        schemaResource.eAdapters().remove((Object)this.schemaResourceAdapter);
        this.schemaResources.remove(namespace);
    }

    protected void readProjectPreferences() {
        Map<String, String> schemaMap = JptJaxbCorePlugin.getSchemaLocationMap(this.project.getProject());
        this.schemaLocations.putAll(schemaMap);
    }

    @Override
    public Map<String, String> getSchemaLocations() {
        return Collections.unmodifiableMap(this.schemaLocations);
    }

    @Override
    public void setSchemaLocations(Map<String, String> schemaLocations) {
        this.schemaLocations.clear();
        JptJaxbCorePlugin.setSchemaLocationMap(this.project.getProject(), schemaLocations);
        this.readProjectPreferences();
    }

    @Override
    public void refreshSchema(String namespace) {
        String resolvedUri = this.getResolvedUri(namespace);
        if (resolvedUri == null) {
            return;
        }
        XSDResourceImpl schemaResource = this.schemaResources.get(namespace);
        if (schemaResource != null) {
            this.removeSchemaResource(schemaResource);
        }
        this.addSchema(namespace, resolvedUri);
    }

    @Override
    public void refreshAllSchemas() {
        for (String namespace : new SnapshotCloneIterable(this.schemaResources.keySet())) {
            this.refreshSchema(namespace);
        }
    }

    public void validate(List<IMessage> messages) {
        for (String namespace : this.schemaLocations.keySet()) {
            if (this.getSchema(namespace) != null) continue;
            messages.add(DefaultValidationMessages.buildMessage(1, "PROJECT_UNRESOLVED_SCHEMA", new String[]{this.schemaLocations.get(namespace)}, this.project));
        }
    }

    private class SchemaResourceAdapter
    extends AdapterImpl {
        private SchemaResourceAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(Resource.class) == 4 && !msg.getNewBooleanValue()) {
                SchemaLibraryImpl.this.removeSchemaResource((XSDResourceImpl)msg.getNotifier());
            }
        }
    }
}

