/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.XmlIDREF;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlIDREF
extends AbstractJavaContextNode
implements XmlIDREF {
    protected final XmlIDREFAnnotation resourceXmlIDREF;

    public GenericJavaXmlIDREF(JaxbAttributeMapping parent, XmlIDREFAnnotation resource) {
        super(parent);
        this.resourceXmlIDREF = resource;
    }

    @Override
    public JaxbAttributeMapping getParent() {
        return (JaxbAttributeMapping)super.getParent();
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getParent().getParent();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getPersistentAttribute().getJavaResourceAttributeTypeName() == Object.class.getName()) {
            return;
        }
        String typeName = this.getPersistentAttribute().getJavaResourceAttributeTypeName();
        JaxbPersistentClass persistentClass = this.getContextRoot().getPersistentClass(typeName);
        if (persistentClass != null && !persistentClass.containsXmlId()) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_IDREF_TYPE_DOES_NOT_CONTAIN_XML_ID", new String[]{this.getPersistentAttribute().getName(), typeName}, this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourceXmlIDREF.getTextRange(astRoot);
    }
}

