/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.HttpUtilities;
import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonUtilities;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.JsonRpcInvoker;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;
import org.eclipse.edt.javart.services.servlet.TracerBase;
import org.eclipse.edt.javart.services.servlet.proxy.HttpServiceInvoker;
import org.eclipse.edt.javart.services.servlet.proxy.ProxyUtilities;

public class ProxyEventHandler
extends TracerBase {
    public Response runProxy(String urlString, Request ruiRequest, Request serviceRequest) {
        Response outerResponse;
        block14: {
            if (this.trace()) {
                this.tracer().put(" Request URL:" + ruiRequest.uri + " method:" + HttpUtilities.httpMethodToString(ruiRequest.method) + " header:" + ProxyUtilities.convert(ruiRequest.headers, " ") + " content:" + (ruiRequest.body == null ? "null" : ruiRequest.body));
            }
            outerResponse = new Response();
            Response innerResponse = null;
            ServiceKind serviceKind = ServiceKind.REST;
            try {
                if (urlString.indexOf("___proxy") != -1 && this.isEGLDedicatedCall(serviceRequest)) {
                    serviceKind = ServiceKind.EGL;
                    innerResponse = new JsonRpcInvoker(serviceRequest.uri, serviceKind).invoke(serviceRequest);
                } else if (urlString.indexOf("___proxy") != -1) {
                    HttpServiceInvoker invoker = new HttpServiceInvoker();
                    serviceKind = invoker.getServiceKind(serviceRequest);
                    innerResponse = invoker.invoke(serviceRequest);
                }
            }
            catch (ServiceInvocationException sie) {
                if (innerResponse == null) {
                    innerResponse = new Response();
                }
                innerResponse.status = 500;
                innerResponse.statusMessage = "FAILED";
                innerResponse.body = JsonUtilities.createJsonAnyException(sie);
                outerResponse.status = 200;
                outerResponse.statusMessage = "OK";
                this.setBody(outerResponse, innerResponse);
                break block14;
            }
            catch (Throwable t) {
                try {
                    if (innerResponse == null) {
                        innerResponse = new Response();
                    }
                    innerResponse.body = JsonUtilities.createJsonAnyException(ServiceUtilities.buildServiceInvocationException("EGL0028E", new Object[0], t, serviceKind));
                    innerResponse.status = 500;
                    innerResponse.statusMessage = "FAILED";
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    outerResponse.status = 200;
                    outerResponse.statusMessage = "OK";
                    this.setBody(outerResponse, innerResponse);
                }
            }
            outerResponse.status = 200;
            outerResponse.statusMessage = "OK";
            this.setBody(outerResponse, innerResponse);
        }
        if (this.trace()) {
            this.tracer().put(" Response Status:" + String.valueOf(outerResponse.status) + " status msg:" + outerResponse.statusMessage + " header:" + ProxyUtilities.convert(outerResponse.getHeaders(), " ") + " body:" + outerResponse.body);
        }
        return outerResponse;
    }

    protected boolean isEGLDedicatedCall(Request request) {
        return ProxyUtilities.isEGLDedicatedCall(request);
    }

    protected void setBody(Response outerResponse, Response innerResponse) {
        ServletUtilities.setBody(outerResponse, innerResponse);
    }
}

