/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPHeader;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BP4100
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP4100(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                throw new AssertionNotApplicableException();
            }
            Element root = doc.getDocumentElement();
            NodeList headerList = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (headerList == null || headerList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            Node header = headerList.item(0);
            NodeList elems = header.getChildNodes();
            if (elems == null || elems.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            int i = 0;
            while (i < elems.getLength()) {
                Node muNode;
                if (elems.item(i).hasAttributes() && (muNode = elems.item(i).getAttributes().getNamedItem(String.valueOf(root.getPrefix()) + ":" + "mustUnderstand")) != null && muNode.getNodeValue().equals("1")) {
                    throw new AssertionPassException();
                }
                String blockName = elems.item(i).getLocalName();
                if (blockName != null) {
                    boolean blockNameExists = false;
                    Binding[] bindings = this.validator.getWSDLDocument().getBindings();
                    int j = 0;
                    while (j < bindings.length) {
                        List operations = bindings[j].getBindingOperations();
                        Iterator k = operations.iterator();
                        while (k.hasNext() && !blockNameExists) {
                            BindingOperation operation = (BindingOperation)k.next();
                            if (entryContext.getMessageEntry().getType().equals("request")) {
                                BindingInput opInput = operation.getBindingInput();
                                if (opInput == null) continue;
                                blockNameExists = this.blockNameExists(opInput.getExtensibilityElements(), blockName);
                                continue;
                            }
                            BindingOutput opOutput = operation.getBindingOutput();
                            if (opOutput == null) continue;
                            blockNameExists = this.blockNameExists(opOutput.getExtensibilityElements(), blockName);
                        }
                        ++j;
                    }
                    if (!blockNameExists) {
                        throw new AssertionPassException();
                    }
                }
                ++i;
            }
            this.result = "notApplicable";
        }
        catch (AssertionPassException assertionPassException) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean blockNameExists(List elems, String blockName) {
        if (elems == null) {
            return false;
        }
        Iterator i = elems.iterator();
        while (i.hasNext()) {
            SOAPHeader soapHeader;
            ExtensibilityElement elem = (ExtensibilityElement)i.next();
            String elemName = elem.getElementType().getLocalPart();
            if (!elemName.equals("header") || !(soapHeader = (SOAPHeader)elem).getPart().equals(blockName)) continue;
            return true;
        }
        return false;
    }
}

