/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.services.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionArgumentValidator;
import org.eclipse.edt.compiler.internal.core.validation.AbstractStatementValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.services.ext.Utils;
import org.eclipse.edt.mof.eglx.services.messages.ResourceKeys;
import org.eclipse.edt.mof.utils.NameUtile;

public class ServicesCallStatementValidator
extends AbstractStatementValidator {
    public boolean visit(CallStatement callStatement) {
        Member function = callStatement.getInvocationTarget().resolveMember();
        if (function == null || !(function instanceof Function)) {
            this.problemRequestor.acceptProblem((Node)callStatement.getInvocationTarget(), 3390, 2, new String[0], ResourceKeys.getResourceBundleForKeys());
            return false;
        }
        callStatement.accept((IASTVisitor)new FunctionArgumentValidator((FunctionMember)((Function)function), this.problemRequestor, this.compilerOptions));
        callStatement.getInvocationTarget().accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                if (qualifiedName.getQualifier() instanceof SimpleName && qualifiedName.getQualifier().resolveElement() instanceof Part && !(qualifiedName.getQualifier().resolveElement() instanceof Library) && !(qualifiedName.getQualifier().resolveElement() instanceof Service)) {
                    ServicesCallStatementValidator.this.problemRequestor.acceptProblem((Node)qualifiedName.getQualifier(), 3410, 2, new String[0], ResourceKeys.getResourceBundleForKeys());
                    return false;
                }
                return false;
            }
        });
        if (callStatement.getUsing() == null && function.getAnnotation("eglx.lang.Resource") == null) {
            final boolean[] isService = new boolean[1];
            callStatement.getInvocationTarget().accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(QualifiedName qualifiedName) {
                    if (qualifiedName.getQualifier() instanceof SimpleName && qualifiedName.getQualifier().resolveElement() instanceof Part && !(qualifiedName.getQualifier().resolveElement() instanceof Library)) {
                        isService[0] = qualifiedName.getQualifier().resolveElement() instanceof Service;
                        return false;
                    }
                    return false;
                }
            });
            if (!isService[0]) {
                this.problemRequestor.acceptProblem((Node)callStatement, 3413, 2, new String[0], ResourceKeys.getResourceBundleForKeys());
            }
        }
        if (callStatement.getUsing() != null && !Utils.isIHTTP(callStatement.getUsing().resolveType())) {
            this.problemRequestor.acceptProblem((Node)callStatement, 3414, 2, new String[]{BindingUtil.getShortTypeString((Type)callStatement.getUsing().resolveType(), (boolean)true)}, ResourceKeys.getResourceBundleForKeys());
        }
        if (((Function)function).getReturnType() != null && (callStatement.getCallSynchronizationValues() == null || callStatement.getCallSynchronizationValues().getReturns() == null && callStatement.getCallSynchronizationValues().getReturnTo() == null)) {
            this.problemRequestor.acceptProblem((Node)callStatement.getInvocationTarget(), 3393, 2, new String[0], ResourceKeys.getResourceBundleForKeys());
        }
        if (callStatement.getCallSynchronizationValues() != null) {
            if (callStatement.getCallSynchronizationValues().getReturnTo() != null) {
                this.validateCallback(callStatement, callStatement.getCallSynchronizationValues().getReturnTo().getExpression(), false, callStatement.getInvocationTarget());
            }
            if (callStatement.getCallSynchronizationValues().getOnException() != null) {
                this.validateCallback(callStatement, callStatement.getCallSynchronizationValues().getOnException().getExpression(), true, callStatement.getInvocationTarget());
            }
        }
        return false;
    }

    private void validateCallback(CallStatement stmt, Expression expr, boolean isErrorCallback, Expression invocTarget) {
        Member cbMember = expr.resolveMember();
        if (cbMember == null) {
            return;
        }
        if (!(cbMember instanceof Function)) {
            this.problemRequestor.acceptProblem((Node)expr, 3394, 2, new String[0], ResourceKeys.getResourceBundleForKeys());
            return;
        }
        Node container = this.getContainer(stmt.getParent());
        if (container instanceof org.eclipse.edt.compiler.core.ast.Part && !cbMember.getContainer().equals(((org.eclipse.edt.compiler.core.ast.Part)container).getName().resolveType())) {
            this.problemRequestor.acceptProblem((Node)expr, 3391, 2, new String[]{cbMember.getCaseSensitiveName(), ((org.eclipse.edt.compiler.core.ast.Part)container).getName().getCanonicalName()}, ResourceKeys.getResourceBundleForKeys());
        }
        if (this.getReturnType(expr) != null) {
            this.problemRequestor.acceptProblem((Node)expr, 3395, 2, new String[]{expr.getCanonicalString()}, ResourceKeys.getResourceBundleForKeys());
        }
        List<FunctionParameter> parms = this.getParameters(expr);
        for (FunctionParameter parm : parms) {
            if (parm.getParameterKind() == ParameterKind.PARM_IN) continue;
            this.problemRequestor.acceptProblem((Node)expr, 3397, 2, new String[]{expr.getCanonicalString()}, ResourceKeys.getResourceBundleForKeys());
            break;
        }
        if (isErrorCallback) {
            if (parms.size() == 1 || parms.size() == 2 && this.lastParmIsIHttp(parms)) {
                if (!this.isAnyException(parms.get(0).getType())) {
                    this.problemRequestor.acceptProblem((Node)expr, 3398, 2, new String[]{"1", expr.getCanonicalString(), this.getQualAnyExceptionString()}, ResourceKeys.getResourceBundleForKeys());
                }
            } else {
                this.problemRequestor.acceptProblem((Node)expr, 3396, 2, new String[]{expr.getCanonicalString(), this.lastParmIsIHttp(parms) ? "2" : "1"}, ResourceKeys.getResourceBundleForKeys());
            }
        } else {
            List<Member> args = this.getArgTypesForCallback(invocTarget);
            if (args.size() == parms.size() || args.size() == parms.size() - 1 && this.lastParmIsIHttp(parms)) {
                int i = 0;
                while (i < args.size()) {
                    if (!this.argTypeCompatibleWithParm(args.get(i), parms.get(i))) {
                        this.problemRequestor.acceptProblem((Node)expr, 3399, 2, new String[]{BindingUtil.getTypeName((Member)args.get(i)), parms.get(i).getCaseSensitiveName(), expr.getCanonicalString(), BindingUtil.getTypeName((Member)((Member)parms.get(i)))}, ResourceKeys.getResourceBundleForKeys());
                    }
                    ++i;
                }
            } else {
                this.problemRequestor.acceptProblem((Node)expr, 3396, 2, new String[]{expr.getCanonicalString(), Integer.toString(this.lastParmIsIHttp(parms) ? args.size() + 1 : args.size())}, ResourceKeys.getResourceBundleForKeys());
            }
        }
    }

    private Node getContainer(Node node) {
        while (node.getParent() != null && !(node instanceof org.eclipse.edt.compiler.core.ast.Part)) {
            node = node.getParent();
        }
        return node;
    }

    private boolean lastParmIsIHttp(List<FunctionParameter> parms) {
        if (parms.size() > 0) {
            Type lastParmType = parms.get(parms.size() - 1).getType();
            return "eglx.http.IHttp".equals(lastParmType.getTypeSignature());
        }
        return false;
    }

    private List<Member> getArgTypesForCallback(Expression invocTarget) {
        ArrayList<Member> list = new ArrayList<Member>();
        for (FunctionParameter parameter : this.getParameters(invocTarget)) {
            if (parameter.getParameterKind() == ParameterKind.PARM_IN) continue;
            list.add((Member)parameter);
        }
        Member function = invocTarget.resolveMember();
        if (function != null && function.getType() != null) {
            list.add(function);
        }
        return list;
    }

    private List<FunctionParameter> getParameters(Expression expr) {
        if (expr.resolveMember() instanceof Delegate) {
            return ((Delegate)expr.resolveMember()).getParameters();
        }
        if (expr.resolveMember() instanceof Function) {
            return ((Function)expr.resolveMember()).getParameters();
        }
        return new ArrayList<FunctionParameter>();
    }

    private Type getReturnType(Expression expr) {
        if (expr.resolveMember() != null) {
            if (expr.resolveMember() instanceof Delegate) {
                return ((Delegate)expr.resolveMember()).getReturnType();
            }
            if (expr.resolveMember() instanceof Function) {
                return ((Function)expr.resolveMember()).getReturnType();
            }
        }
        return null;
    }

    private boolean argTypeCompatibleWithParm(Member argRHS, FunctionParameter parmLHS) {
        if (argRHS == null) {
            return true;
        }
        if (IRUtils.isMoveCompatible((Type)parmLHS.getType(), (Member)parmLHS, (Type)argRHS.getType(), (Member)argRHS)) {
            return true;
        }
        return argRHS.getType() instanceof NamedElement && TypeUtils.areCompatible((Classifier)parmLHS.getType().getClassifier(), (NamedElement)((NamedElement)argRHS.getType()));
    }

    private boolean isAnyException(Type type) {
        return "eglx.lang.AnyException".equals(type.getTypeSignature());
    }

    private String getQualAnyExceptionString() {
        return NameUtile.getAsName((String)"eglx.lang.AnyException");
    }
}

