/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.jtopen.ext;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class Utils {
    private static final String IBMiConnectionMofKey = "egl:eglx.jtopen.IBMiConnection";

    public static boolean isIBMiConnection(Type type) {
        return TypeUtils.isTypeOrSubtypeOf((Type)type, (String)IBMiConnectionMofKey);
    }

    public static boolean isFunctionServiceQualified(Expression exp, Function function) {
        return (!(exp instanceof FieldAccess) || !(((FieldAccess)exp).getPrimary() instanceof ThisExpression)) && function.getContainer() instanceof Service;
    }

    public static boolean requiresAS400TypeAnnotation(Type type) {
        if (type == null) {
            return false;
        }
        if (Utils.isSupportedPrimitiveTypes(type)) {
            return TypeUtils.isReferenceType((Type)type);
        }
        if (type instanceof ArrayType) {
            if (((ArrayType)type).getElementType() == null) {
                return false;
            }
            if (((ArrayType)type).getElementType() instanceof ArrayType) {
                return false;
            }
            return Utils.requiresAS400TypeAnnotation(((ArrayType)type).getElementType());
        }
        return false;
    }

    public static boolean isValidAS400Type(Type type) {
        if (type == null) {
            return true;
        }
        if (Utils.isSupportedPrimitiveTypes(type)) {
            return true;
        }
        if (type instanceof Handler) {
            return true;
        }
        if (type instanceof Record) {
            return true;
        }
        if (type instanceof ArrayType) {
            if (((ArrayType)type).getElementType() == null) {
                return true;
            }
            if (((ArrayType)type).getElementType() instanceof ArrayType) {
                return false;
            }
            return Utils.isValidAS400Type(((ArrayType)type).getElementType());
        }
        return false;
    }

    private static boolean isSupportedPrimitiveTypes(Type type) {
        return TypeUtils.isNumericType((Type)type) || TypeUtils.isTextType((Type)type) || type != null && type.getClassifier() instanceof EGLClass && (type.getClassifier().equals(TypeUtils.Type_DATE) != false || type.getClassifier().equals(TypeUtils.Type_TIME) != false || type.getClassifier().equals(TypeUtils.Type_TIMESTAMP) != false || type.getClassifier().equals(TypeUtils.Type_BYTES) != false);
    }
}

