/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.eglx.jtopen.validation.annotation;

import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.jtopen.messages.IBMiResourceKeys;
import org.eclipse.edt.mof.eglx.jtopen.validation.annotation.AbstractStructParameterAnnotationValidator;

public abstract class StructDecimalValidator
extends AbstractStructParameterAnnotationValidator {
    @Override
    protected void validateType(Annotation annotation, Node errorNode, Node target, Type type) {
        super.validateType(annotation, errorNode, target, type);
        if (type != null && this.isValidType(type)) {
            if (type instanceof FixedPrecisionType) {
                this.validateLengthAndDecimalsNotSpecified(annotation, errorNode, target);
            } else {
                this.validateLengthAndDecimalsSpecified(annotation, errorNode, target);
                this.validateLength(annotation, errorNode, target);
                this.validateDecimals(annotation, errorNode, target);
            }
        }
    }

    private void validateLength(Annotation ann, Node errorNode, Node target) {
        Integer length = (Integer)ann.getValue("length");
        if (length != null && (length < 1 || length > 32)) {
            this.problemRequestor.acceptProblem(errorNode, 5707, 2, new String[]{length.toString(), this.getName(), "32"}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    protected void validateDecimals(Annotation ann, Node errorNode, Node target) {
        Integer decimals = (Integer)ann.getValue("decimals");
        if (decimals != null) {
            Integer length;
            if (decimals < 0) {
                this.problemRequestor.acceptProblem(errorNode, 5708, 2, new String[]{decimals.toString(), this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
            if ((length = (Integer)ann.getValue("length")) != null && decimals > length) {
                this.problemRequestor.acceptProblem(errorNode, 5709, 2, new String[]{decimals.toString(), this.getName(), length.toString()}, IBMiResourceKeys.getResourceBundleForKeys());
            }
        }
    }

    protected void validateLengthAndDecimalsNotSpecified(Annotation ann, Node errorNode, Node target) {
        if (ann.getValue("length") != null) {
            this.problemRequestor.acceptProblem(errorNode, 5711, 2, new String[]{"length", this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
        if (ann.getValue("decimals") != null) {
            this.problemRequestor.acceptProblem(errorNode, 5711, 2, new String[]{"decimals", this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    protected void validateLengthAndDecimalsSpecified(Annotation ann, Node errorNode, Node target) {
        if (ann.getValue("length") == null) {
            this.problemRequestor.acceptProblem(errorNode, 5710, 2, new String[]{"length", this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
        if (ann.getValue("decimals") == null) {
            this.problemRequestor.acceptProblem(errorNode, 5710, 2, new String[]{"decimals", this.getName()}, IBMiResourceKeys.getResourceBundleForKeys());
        }
    }

    @Override
    protected Type getSupportedType() {
        return TypeUtils.Type_DECIMAL;
    }
}

